package net.openhft.chronicle.core.jlbh;

import java.util.function.Consumer;
import java.util.function.Supplier;


public interface JLBHResultConsumer extends Consumer<JLBHResult>, Supplier<JLBHResult> {

  /**
   * Thread safety (when reading the result from a thread that is different from the one executing the JLBH)
   * is guaranteed by making sure that the result data is visible after being generated by JLBH.
   * Additional requirement, JLBHResult immutability is met by JLBHResult implementation used by JLBH.
   *
   * When using this instance on its own, make sure the JLBHResult implementation passed to the
   * accept method is immutable.
   *
   */
  static JLBHResultConsumer newThreadSafeInstance() {
    return new ThreadSafeJLBHResultConsumer();
  }
}

