/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.annotation.ForceInline;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class UnsafeMemory
implements Memory {
    @NotNull
    public static final Unsafe UNSAFE;
    public static final UnsafeMemory INSTANCE;
    public static final boolean tracing = false;
    static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private final AtomicLong nativeMemoryUsed = new AtomicLong();

    private static int retryReadVolatileInt(long address, int value) {
        int value2 = UNSAFE.getIntVolatile(null, address);
        while (value2 != value) {
            if (value != 0 && value != Integer.MIN_VALUE) {
                Jvm.warn().on(UnsafeMemory.class, "Int@" + Long.toHexString(address) + " (" + (address & 0x3FL) + ") was " + Integer.toHexString(value) + " is now " + Integer.toHexString(value2));
            }
            value = value2;
            value2 = UNSAFE.getIntVolatile(null, address);
        }
        return value;
    }

    private static long retryReadVolatileLong(long address, long value) {
        long value2 = UNSAFE.getLongVolatile(null, address);
        while (value2 != value) {
            if (value != 0L) {
                Jvm.warn().on(UnsafeMemory.class, "please add padding() when using concurrent writers, Long@" + Long.toHexString(address) + " (" + (address & 0x3FL) + ") was " + Long.toHexString(value) + " is now " + Long.toHexString(value2));
            }
            value = value2;
            value2 = UNSAFE.getLongVolatile(null, address);
        }
        return value;
    }

    @Override
    @NotNull
    public <E> E allocateInstance(Class<? extends E> clazz) throws InstantiationException {
        Object e = UNSAFE.allocateInstance(clazz);
        return (E)e;
    }

    @Override
    public long getFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    @Override
    public void setInt(@NotNull Object object, long offset, int value) {
        if (object == null) {
            throw new NullPointerException();
        }
        UNSAFE.putInt(object, offset, value);
    }

    @Override
    @NotNull
    public <T> T getObject(@NotNull Object object, long offset) {
        if (object == null) {
            throw new NullPointerException();
        }
        return (T)UNSAFE.getObject(object, offset);
    }

    @Override
    @ForceInline
    public void storeFence() {
        UNSAFE.storeFence();
    }

    @Override
    @ForceInline
    public void loadFence() {
        UNSAFE.loadFence();
    }

    @Override
    @ForceInline
    public void setMemory(long address, long size, byte b) {
        UNSAFE.setMemory(address, size, b);
    }

    @Override
    public void freeMemory(long address, long size) {
        if (address != 0L) {
            UNSAFE.freeMemory(address);
        }
        this.nativeMemoryUsed.addAndGet(-size);
    }

    @Override
    public long allocate(long capacity) throws IllegalArgumentException {
        if (capacity <= 0L) {
            throw new IllegalArgumentException("Invalid capacity: " + capacity);
        }
        long address = UNSAFE.allocateMemory(capacity);
        if (address == 0L) {
            throw new OutOfMemoryError("Not enough free native memory, capacity attempted: " + capacity / 1024L + " KiB");
        }
        this.nativeMemoryUsed.addAndGet(capacity);
        return address;
    }

    @Override
    public long nativeMemoryUsed() {
        return this.nativeMemoryUsed.get();
    }

    @Override
    @ForceInline
    public void writeByte(long address, byte b) {
        UNSAFE.putByte(address, b);
    }

    @Override
    @ForceInline
    public void writeByte(@NotNull Object object, long offset, byte b) {
        if (object == null) {
            throw new NullPointerException();
        }
        UNSAFE.putByte(object, offset, b);
    }

    @Override
    @ForceInline
    public byte readByte(@NotNull Object object, long offset) {
        if (object == null) {
            throw new NullPointerException();
        }
        return UNSAFE.getByte(object, offset);
    }

    @Override
    @ForceInline
    public void writeBytes(long address, byte[] b, int offset, int length) {
        if (offset + length > b.length) {
            throw new IllegalArgumentException("Invalid offset or length, array's length is " + b.length);
        }
        UNSAFE.copyMemory(b, Unsafe.ARRAY_BYTE_BASE_OFFSET + offset, null, address, length);
    }

    @Override
    @ForceInline
    public void readBytes(long address, byte[] b, long offset, int length) {
        if (offset + (long)length > (long)b.length) {
            throw new IllegalArgumentException("Invalid offset or length, array's length is " + b.length);
        }
        UNSAFE.copyMemory(null, address, b, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + offset, length);
    }

    @Override
    @ForceInline
    public byte readByte(long address) {
        return UNSAFE.getByte(address);
    }

    @Override
    @ForceInline
    public void writeShort(long address, short i16) {
        UNSAFE.putShort(address, i16);
    }

    @Override
    @ForceInline
    public void writeShort(@NotNull Object object, long offset, short i16) {
        if (object == null) {
            throw new NullPointerException();
        }
        UNSAFE.putShort(object, offset, i16);
    }

    @Override
    @ForceInline
    public short readShort(long address) {
        return UNSAFE.getShort(address);
    }

    @Override
    @ForceInline
    public short readShort(@NotNull Object object, long offset) {
        if (object == null) {
            throw new NullPointerException();
        }
        return UNSAFE.getShort(object, offset);
    }

    @Override
    @ForceInline
    public void writeInt(long address, int i32) {
        UNSAFE.putInt(address, i32);
    }

    @Override
    @ForceInline
    public void writeInt(@NotNull Object object, long offset, int i32) {
        if (object == null) {
            throw new NullPointerException();
        }
        UNSAFE.putInt(object, offset, i32);
    }

    @Override
    @ForceInline
    public void writeOrderedInt(long address, int i32) {
        UNSAFE.putOrderedInt(null, address, i32);
    }

    @Override
    @ForceInline
    public void writeOrderedInt(@NotNull Object object, long offset, int i32) {
        if (object == null) {
            throw new NullPointerException();
        }
        UNSAFE.putOrderedInt(object, offset, i32);
    }

    @Override
    @ForceInline
    public int readInt(long address) {
        return UNSAFE.getInt(address);
    }

    @Override
    @ForceInline
    public int readInt(Object object, long offset) {
        if (object != null) {
            return UNSAFE.getInt(object, offset);
        }
        throw new NullPointerException();
    }

    @Override
    @ForceInline
    public void writeLong(long address, long i64) {
        UNSAFE.putLong(address, i64);
    }

    @Override
    @ForceInline
    public void writeLong(Object object, long offset, long i64) {
        if (object == null) {
            throw new NullPointerException();
        }
        UNSAFE.putLong(object, offset, i64);
    }

    @Override
    @ForceInline
    public long readLong(long address) {
        return UNSAFE.getLong(address);
    }

    @Override
    @ForceInline
    public long readLong(Object object, long offset) {
        if (object != null) {
            return UNSAFE.getLong(object, offset);
        }
        throw new NullPointerException();
    }

    @Override
    @ForceInline
    public void writeFloat(long address, float f) {
        UNSAFE.putFloat(address, f);
    }

    @Override
    @ForceInline
    public void writeFloat(Object object, long offset, float f) {
        if (object == null) {
            throw new NullPointerException();
        }
        UNSAFE.putFloat(object, offset, f);
    }

    @Override
    @ForceInline
    public float readFloat(long address) {
        return UNSAFE.getFloat(address);
    }

    @Override
    @ForceInline
    public float readFloat(Object object, long offset) {
        if (object != null) {
            return UNSAFE.getFloat(object, offset);
        }
        throw new NullPointerException();
    }

    @Override
    @ForceInline
    public void writeDouble(long address, double d) {
        UNSAFE.putDouble(address, d);
    }

    @Override
    @ForceInline
    public void writeDouble(Object object, long offset, double d) {
        if (object == null) {
            throw new NullPointerException();
        }
        UNSAFE.putDouble(object, offset, d);
    }

    @Override
    @ForceInline
    public double readDouble(long address) {
        return UNSAFE.getDouble(address);
    }

    @Override
    @ForceInline
    public double readDouble(Object object, long offset) {
        if (object != null) {
            return UNSAFE.getDouble(object, offset);
        }
        throw new NullPointerException();
    }

    @Override
    @ForceInline
    public void copyMemory(byte[] bytes, int offset, long address, int length) {
        this.copyMemory(bytes, offset, null, address, length);
    }

    @Override
    @ForceInline
    public void copyMemory(long fromAddress, long address, long length) {
        if (length < 0x100000L) {
            UNSAFE.copyMemory(null, fromAddress, null, address, length);
        } else {
            this.copyMemory0(null, fromAddress, null, address, length);
        }
    }

    @Override
    @ForceInline
    public void copyMemory(byte[] bytes, int offset, Object obj2, long offset2, int length) {
        if ((long)length < 0x100000L) {
            UNSAFE.copyMemory(bytes, Unsafe.ARRAY_BYTE_BASE_OFFSET + offset, obj2, offset2, length);
        } else {
            this.copyMemory0(bytes, Unsafe.ARRAY_BYTE_BASE_OFFSET + offset, obj2, offset2, length);
        }
    }

    @Override
    @ForceInline
    public void copyMemory(long fromAddress, Object obj2, long offset2, int length) {
        long time;
        long start = length > 131072 ? System.nanoTime() : 0L;
        this.copyMemory0(null, fromAddress, obj2, offset2, length);
        if (length > 131072 && (time = System.nanoTime() - start) > 100000L) {
            Jvm.warn().on(this.getClass(), "Took " + (double)(time / 1000L) / 1000.0 + " ms to copy " + length / 1024 + " KB");
        }
    }

    void copyMemory0(Object from, long fromOffset, Object to, long toOffset, long length) {
        while (length > 0L) {
            long size = Math.min(length, 0x100000L);
            UNSAFE.copyMemory(from, fromOffset, to, toOffset, size);
            length -= size;
            fromOffset += size;
            toOffset += size;
        }
    }

    @Override
    @ForceInline
    public void writeOrderedLong(long address, long i) {
        UNSAFE.putOrderedLong(null, address, i);
    }

    @Override
    @ForceInline
    public void writeOrderedLong(Object object, long offset, long i) {
        if (object == null) {
            throw new NullPointerException();
        }
        UNSAFE.putOrderedLong(object, offset, i);
    }

    @Override
    public void testAndSetInt(long address, long offset, int expected, int value) {
        if (UNSAFE.compareAndSwapInt(null, address, expected, value)) {
            return;
        }
        int actual = UNSAFE.getIntVolatile(null, address);
        throw new IllegalStateException("Cannot change at " + offset + " expected " + expected + " was " + actual);
    }

    @Override
    public void testAndSetInt(Object object, long offset, int expected, int value) {
        if (UNSAFE.compareAndSwapInt(object, offset, expected, value)) {
            return;
        }
        int actual = UNSAFE.getIntVolatile(object, offset);
        throw new IllegalStateException("Cannot change " + object.getClass().getSimpleName() + " at " + offset + " expected " + expected + " was " + actual);
    }

    @Override
    @ForceInline
    public boolean compareAndSwapInt(long address, int expected, int value) {
        return UNSAFE.compareAndSwapInt(null, address, expected, value);
    }

    @Override
    @ForceInline
    public boolean compareAndSwapInt(Object object, long offset, int expected, int value) {
        if (object != null) {
            return UNSAFE.compareAndSwapInt(object, offset, expected, value);
        }
        throw new NullPointerException();
    }

    @Override
    @ForceInline
    public boolean compareAndSwapLong(long address, long expected, long value) {
        return UNSAFE.compareAndSwapLong(null, address, expected, value);
    }

    @Override
    @ForceInline
    public boolean compareAndSwapLong(Object object, long offset, long expected, long value) {
        if (object != null) {
            return UNSAFE.compareAndSwapLong(object, offset, expected, value);
        }
        throw new NullPointerException();
    }

    @Override
    public int pageSize() {
        return UNSAFE.pageSize();
    }

    @Override
    @ForceInline
    public byte readVolatileByte(long address) {
        return UNSAFE.getByteVolatile(null, address);
    }

    @Override
    @ForceInline
    public byte readVolatileByte(Object object, long offset) {
        if (object != null) {
            return UNSAFE.getByteVolatile(object, offset);
        }
        throw new NullPointerException();
    }

    @Override
    @ForceInline
    public short readVolatileShort(long address) {
        return UNSAFE.getShortVolatile(null, address);
    }

    @Override
    @ForceInline
    public short readVolatileShort(Object object, long offset) {
        if (object != null) {
            return UNSAFE.getShortVolatile(object, offset);
        }
        throw new NullPointerException();
    }

    @Override
    @ForceInline
    public int readVolatileInt(long address) {
        int value = UNSAFE.getIntVolatile(null, address);
        if ((address & 0x3FL) <= 60L) {
            if (value == 0) {
                value = UNSAFE.getIntVolatile(null, address);
            }
            return value;
        }
        return UnsafeMemory.retryReadVolatileInt(address, value);
    }

    @Override
    @ForceInline
    public int readVolatileInt(Object object, long offset) {
        if (object == null) {
            throw new NullPointerException();
        }
        return UNSAFE.getIntVolatile(object, offset);
    }

    @Override
    @ForceInline
    public float readVolatileFloat(long address) {
        return UNSAFE.getFloatVolatile(null, address);
    }

    @Override
    @ForceInline
    public float readVolatileFloat(Object object, long offset) {
        if (object != null) {
            return UNSAFE.getFloatVolatile(object, offset);
        }
        throw new NullPointerException();
    }

    @Override
    @ForceInline
    public long readVolatileLong(long address) {
        long value = UNSAFE.getLongVolatile(null, address);
        if ((address & 0x3FL) <= 56L) {
            return value;
        }
        return UnsafeMemory.retryReadVolatileLong(address, value);
    }

    @Override
    @ForceInline
    public long readVolatileLong(Object object, long offset) {
        if (object != null) {
            return UNSAFE.getLongVolatile(object, offset);
        }
        throw new NullPointerException();
    }

    @Override
    @ForceInline
    public double readVolatileDouble(long address) {
        return UNSAFE.getDoubleVolatile(null, address);
    }

    @Override
    @ForceInline
    public double readVolatileDouble(Object object, long offset) {
        if (object != null) {
            return UNSAFE.getDoubleVolatile(object, offset);
        }
        throw new NullPointerException();
    }

    @Override
    @ForceInline
    public void writeVolatileByte(long address, byte b) {
        UNSAFE.putByteVolatile(null, address, b);
    }

    @Override
    @ForceInline
    public void writeVolatileByte(Object object, long offset, byte b) {
        if (object == null) {
            throw new NullPointerException();
        }
        UNSAFE.putByteVolatile(object, offset, b);
    }

    @Override
    @ForceInline
    public void writeVolatileShort(long address, short i16) {
        UNSAFE.putShortVolatile(null, address, i16);
    }

    @Override
    @ForceInline
    public void writeVolatileShort(Object object, long offset, short i16) {
        if (object == null) {
            throw new NullPointerException();
        }
        UNSAFE.putShortVolatile(object, offset, i16);
    }

    @Override
    @ForceInline
    public void writeVolatileInt(long address, int i32) {
        UNSAFE.putIntVolatile(null, address, i32);
    }

    @Override
    @ForceInline
    public void writeVolatileInt(Object object, long offset, int i32) {
        if (object == null) {
            throw new NullPointerException();
        }
        UNSAFE.putIntVolatile(object, offset, i32);
    }

    @Override
    @ForceInline
    public void writeVolatileFloat(long address, float f) {
        UNSAFE.putFloatVolatile(null, address, f);
    }

    @Override
    @ForceInline
    public void writeVolatileFloat(Object object, long offset, float f) {
        if (object == null) {
            throw new NullPointerException();
        }
        UNSAFE.putFloatVolatile(object, offset, f);
    }

    @Override
    @ForceInline
    public void writeVolatileLong(long address, long i64) {
        UNSAFE.putLongVolatile(null, address, i64);
    }

    @Override
    @ForceInline
    public void writeVolatileLong(Object object, long offset, long i64) {
        if (object == null) {
            throw new NullPointerException();
        }
        UNSAFE.putLongVolatile(object, offset, i64);
    }

    @Override
    @ForceInline
    public void writeVolatileDouble(long address, double d) {
        UNSAFE.putDoubleVolatile(null, address, d);
    }

    @Override
    @ForceInline
    public void writeVolatileDouble(Object object, long offset, double d) {
        if (object == null) {
            throw new NullPointerException();
        }
        UNSAFE.putDoubleVolatile(object, offset, d);
    }

    @Override
    @ForceInline
    public int addInt(long address, int increment) {
        return UNSAFE.getAndAddInt(null, address, increment) + increment;
    }

    @Override
    @ForceInline
    public int addInt(Object object, long offset, int increment) {
        if (object != null) {
            return UNSAFE.getAndAddInt(object, offset, increment) + increment;
        }
        throw new NullPointerException();
    }

    @Override
    @ForceInline
    public long addLong(long address, long increment) {
        return UNSAFE.getAndAddLong(null, address, increment) + increment;
    }

    @Override
    @ForceInline
    public long addLong(Object object, long offset, long increment) {
        if (object != null) {
            return UNSAFE.getAndAddLong(object, offset, increment) + increment;
        }
        throw new NullPointerException();
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
        INSTANCE = Jvm.isArm() ? new ARMMemory() : new UnsafeMemory();
    }

    static class ARMMemory
    extends UnsafeMemory {
        ARMMemory() {
        }

        @Override
        public short readVolatileShort(long address) {
            if ((address & 1L) == 0L) {
                return super.readVolatileShort(address);
            }
            UNSAFE.loadFence();
            return super.readShort(address);
        }

        @Override
        public void writeVolatileShort(long address, short i16) {
            if ((address & 1L) == 0L) {
                super.writeVolatileShort(address, i16);
            } else {
                super.writeShort(address, i16);
                UNSAFE.storeFence();
            }
        }

        @Override
        public void writeFloat(long address, float f) {
            if ((address & 3L) == 0L) {
                super.writeFloat(address, f);
            } else {
                super.writeInt(address, Float.floatToRawIntBits(f));
            }
        }

        @Override
        public float readFloat(long address) {
            if ((address & 3L) == 0L) {
                return super.readFloat(address);
            }
            return Float.intBitsToFloat(super.readInt(address));
        }

        @Override
        public void writeFloat(@NotNull Object object, long offset, float f) {
            if ((offset & 3L) == 0L) {
                super.writeFloat(object, offset, f);
            } else {
                super.writeInt(object, offset, Float.floatToRawIntBits(f));
            }
        }

        @Override
        public float readFloat(@NotNull Object object, long offset) {
            if ((offset & 3L) == 0L) {
                return super.readFloat(object, offset);
            }
            return Float.intBitsToFloat(super.readInt(object, offset));
        }

        @Override
        public int readVolatileInt(long address) {
            if ((address & 3L) == 0L) {
                return super.readVolatileInt(address);
            }
            UNSAFE.loadFence();
            return super.readInt(address);
        }

        @Override
        public float readVolatileFloat(long address) {
            if ((address & 3L) == 0L) {
                return super.readVolatileFloat(address);
            }
            UNSAFE.loadFence();
            return this.readFloat(address);
        }

        @Override
        public void writeVolatileInt(long address, int i32) {
            if ((address & 3L) == 0L) {
                super.writeVolatileInt(address, i32);
            } else {
                this.writeInt(address, i32);
                UNSAFE.storeFence();
            }
        }

        @Override
        public void writeOrderedInt(long address, int i32) {
            if ((address & 3L) == 0L) {
                super.writeOrderedInt(address, i32);
            } else {
                this.writeVolatileInt(address, i32);
            }
        }

        @Override
        public void writeOrderedInt(@NotNull Object object, long offset, int i32) {
            if ((offset & 3L) == 0L) {
                super.writeOrderedInt(object, offset, i32);
            } else {
                super.writeVolatileInt(object, offset, i32);
            }
        }

        @Override
        public void writeVolatileFloat(long address, float f) {
            if ((address & 3L) == 0L) {
                super.writeVolatileFloat(address, f);
            } else {
                this.writeVolatileInt(address, Float.floatToRawIntBits(f));
            }
        }

        @Override
        public int addInt(long address, int increment) {
            if ((address & 3L) == 0L) {
                return super.addInt(address, increment);
            }
            throw new IllegalArgumentException("mis-aligned");
        }

        @Override
        public boolean compareAndSwapInt(long address, int expected, int value) {
            if ((address & 3L) == 0L) {
                return super.compareAndSwapInt(address, expected, value);
            }
            throw new IllegalArgumentException("mis-aligned");
        }

        @Override
        public boolean compareAndSwapInt(@NotNull Object object, long offset, int expected, int value) {
            if ((offset & 3L) == 0L) {
                return super.compareAndSwapInt(object, offset, expected, value);
            }
            throw new IllegalArgumentException("mis-aligned");
        }

        @Override
        public void testAndSetInt(long address, long offset, int expected, int value) {
            if ((address & 0xFFFFFFFFFFFFFFFCL) == 0L) {
                if (UNSAFE.compareAndSwapInt(null, address, expected, value)) {
                    return;
                }
                int actual = UNSAFE.getIntVolatile(null, address);
                throw new IllegalStateException("Cannot change at " + offset + " expected " + expected + " was " + actual);
            }
            UNSAFE.loadFence();
            int actual = UNSAFE.getInt(address);
            if (actual == expected) {
                UNSAFE.putInt(address, value);
                UNSAFE.storeFence();
                return;
            }
            throw new IllegalStateException("Cannot perform thread safe operation at " + offset + " as mis-aligned");
        }

        @Override
        public void testAndSetInt(Object object, long offset, int expected, int value) {
            if ((offset & 0xFFFFFFFFFFFFFFFCL) == 0L) {
                if (UNSAFE.compareAndSwapInt(object, offset, expected, value)) {
                    return;
                }
                int actual = UNSAFE.getIntVolatile(object, offset);
                throw new IllegalStateException("Cannot change " + object.getClass().getSimpleName() + " at " + offset + " expected " + expected + " was " + actual);
            }
            UNSAFE.loadFence();
            int actual = UNSAFE.getInt(object, offset);
            if (actual == expected) {
                UNSAFE.putInt(object, offset, value);
                UNSAFE.storeFence();
                return;
            }
            throw new IllegalStateException("Cannot perform thread safe operation on " + object.getClass().getSimpleName() + " at " + offset + " as mis-aligned");
        }

        @Override
        public void writeDouble(long address, double d) {
            if ((address & 7L) == 0L) {
                super.writeDouble(address, d);
            } else {
                super.writeLong(address, Double.doubleToRawLongBits(d));
            }
        }

        @Override
        public double readDouble(long address) {
            if ((address & 7L) == 0L) {
                return super.readDouble(address);
            }
            return Double.longBitsToDouble(super.readLong(address));
        }

        @Override
        public void writeDouble(@NotNull Object object, long offset, double d) {
            if ((offset & 7L) == 0L) {
                super.writeDouble(object, offset, d);
            } else {
                super.writeLong(object, offset, Double.doubleToRawLongBits(d));
            }
        }

        @Override
        public double readDouble(@NotNull Object object, long offset) {
            if ((offset & 7L) == 0L) {
                return super.readDouble(object, offset);
            }
            return Double.longBitsToDouble(super.readLong(object, offset));
        }

        @Override
        public void writeOrderedLong(long address, long i) {
            if ((address & 7L) == 0L) {
                super.writeOrderedLong(address, i);
            } else {
                this.writeVolatileLong(address, i);
            }
        }

        @Override
        public long readVolatileLong(long address) {
            if ((address & 7L) == 0L) {
                return super.readVolatileLong(address);
            }
            UNSAFE.loadFence();
            return this.readLong(address);
        }

        @Override
        public void writeOrderedLong(@NotNull Object object, long offset, long i) {
            if ((offset & 7L) == 0L) {
                super.writeOrderedLong(object, offset, i);
            } else {
                this.writeVolatileLong(object, offset, i);
            }
        }

        @Override
        public long readVolatileLong(@NotNull Object object, long offset) {
            if ((offset & 7L) == 0L) {
                return super.readVolatileLong(object, offset);
            }
            UNSAFE.loadFence();
            return this.readLong(object, offset);
        }

        @Override
        public double readVolatileDouble(long address) {
            if ((address & 7L) == 0L) {
                return super.readVolatileDouble(address);
            }
            UNSAFE.loadFence();
            return this.readDouble(address);
        }

        @Override
        public void writeVolatileLong(@NotNull Object object, long offset, long i64) {
            if ((offset & 7L) == 0L) {
                super.writeVolatileLong(object, offset, i64);
            } else {
                this.writeLong(object, offset, i64);
                UNSAFE.storeFence();
            }
        }

        @Override
        public void writeVolatileLong(long address, long i64) {
            if ((address & 7L) == 0L) {
                super.writeVolatileLong(address, i64);
            } else {
                this.writeLong(address, i64);
                UNSAFE.storeFence();
            }
        }

        @Override
        public void writeVolatileDouble(long address, double d) {
            if ((address & 7L) == 0L) {
                super.writeVolatileDouble(address, d);
            } else {
                this.writeLong(address, Double.doubleToRawLongBits(d));
            }
        }

        @Override
        public long addLong(long address, long increment) {
            if ((address & 7L) == 0L) {
                return super.addLong(address, increment);
            }
            throw new IllegalArgumentException("mis-aligned");
        }

        @Override
        public boolean compareAndSwapLong(@NotNull Object object, long offset, long expected, long value) {
            if ((offset & 7L) == 0L) {
                return super.compareAndSwapLong(object, offset, expected, value);
            }
            throw new IllegalArgumentException("mis-aligned");
        }

        @Override
        public boolean compareAndSwapLong(long address, long expected, long value) {
            if ((address & 7L) == 0L) {
                return super.compareAndSwapLong(address, expected, value);
            }
            throw new IllegalArgumentException("mis-aligned");
        }
    }
}

