/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.io.File;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.impl.ChronicleHashResourceReleaser;
import net.openhft.chronicle.hash.impl.MemoryResource;
import net.openhft.chronicle.hash.impl.util.CanonicalRandomAccessFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistedChronicleHashResourceReleaser
extends ChronicleHashResourceReleaser {
    private static final Logger LOG = LoggerFactory.getLogger(PersistedChronicleHashResourceReleaser.class);
    private final File file;

    public PersistedChronicleHashResourceReleaser(File file) {
        this.file = file;
    }

    @Override
    public synchronized void run() {
        if (this.memoryResources == null) {
            return;
        }
        try {
            Throwable thrown = this.doRelease();
            if (thrown != null) {
                try {
                    LOG.error("Error on releasing memory or RAF of the Chronicle Map at file=" + this.file, thrown);
                }
                catch (Throwable t) {
                    thrown.addSuppressed(t);
                    thrown.printStackTrace();
                }
            }
        }
        finally {
            this.memoryResources = null;
        }
    }

    @Override
    Throwable doRelease() {
        Throwable thrown = null;
        for (MemoryResource mapping : this.memoryResources) {
            try {
                OS.unmap((long)mapping.address, (long)mapping.size);
            }
            catch (Throwable t) {
                if (thrown == null) {
                    thrown = t;
                    continue;
                }
                thrown.addSuppressed(t);
            }
        }
        try {
            CanonicalRandomAccessFiles.release(this.file);
        }
        catch (Throwable t) {
            if (thrown == null) {
                thrown = t;
            }
            thrown.addSuppressed(t);
        }
        return thrown;
    }
}

