/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.hash;

import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.ChronicleHashClosedException;

public abstract class ThreadLocalState {
    private static final Memory MEMORY = OS.memory();
    private static final long CONTEXT_LOCK_OFFSET;
    private static final int CONTEXT_UNLOCKED = 0;
    private static final int CONTEXT_LOCKED_LOCALLY = 1;
    private static final int CONTEXT_CLOSED = 2;
    private volatile int contextLock = 0;
    public boolean iterationContextLockedInThisThread;

    public boolean lockContextLocally(ChronicleHash<?, ?, ?, ?> hash) {
        if (hash.isOpen() && MEMORY.compareAndSwapInt((Object)this, CONTEXT_LOCK_OFFSET, 0, 1)) {
            return true;
        }
        if (this.contextLock == 1) {
            return false;
        }
        if (!hash.isOpen()) {
            throw new ChronicleHashClosedException(hash);
        }
        throw new AssertionError((Object)("Unknown context lock state: " + this.contextLock));
    }

    public void unlockContextLocally() {
        MEMORY.loadFence();
        MEMORY.writeOrderedInt((Object)this, CONTEXT_LOCK_OFFSET, 0);
    }

    public void closeContext(ChronicleHash<?, ?, ?, ?> hash) {
        if (this.tryCloseContext()) {
            return;
        }
        if (this.owner() == Thread.currentThread()) {
            throw new IllegalStateException(hash.toIdentityString() + ": Attempt to close a Chronicle Hash in the context " + "of not yet finished query or iteration");
        }
        long timeoutMillis = TimeUnit.SECONDS.toMillis(60L) * 2L;
        long lastTime = System.currentTimeMillis();
        do {
            if (this.tryCloseContext()) {
                return;
            }
            Thread.yield();
            long now = System.currentTimeMillis();
            if (now == lastTime) continue;
            lastTime = now;
            --timeoutMillis;
        } while (timeoutMillis >= 0L);
        throw new RuntimeException(hash.toIdentityString() + ": Failed to close a context, belonging to the thread\n" + this.owner() + ", in the state: " + (Object)((Object)this.owner().getState()) + "\n" + "Possible reasons:\n" + "- The context owner thread exited before closing this context. Ensure that you\n" + "always close opened Chronicle Map's contexts, the best way to do this is to use\n" + "try-with-resources blocks." + "- The context owner thread runs some context operation (e. g. a query) for\n" + "unexpectedly long time (at least " + 60 + " seconds).\n" + "You should either redesign your logic to spend less time in Chronicle Map\n" + "contexts (recommended) or synchronize map.close() with queries externally,\n" + "so that close() is called only after all query operations finished.\n" + "- Iteration over a large Chronicle Map takes more than " + 60 + " seconds.\n" + "In this case you should synchronize map.close() with iterations over the map\n" + "externally, so that close() is called only after all iterations are finished.\n" + "- This is a dead lock involving the context owner thread and this thread (from\n" + "which map.close() method is called. Make sure you always close Chronicle Map\n" + "contexts, preferably using try-with-resources blocks.");
    }

    private boolean tryCloseContext() {
        return MEMORY.compareAndSwapInt((Object)this, CONTEXT_LOCK_OFFSET, 0, 2);
    }

    public abstract Thread owner();

    static {
        try {
            Field contextLockField = ThreadLocalState.class.getDeclaredField("contextLock");
            contextLockField.setAccessible(true);
            CONTEXT_LOCK_OFFSET = MEMORY.getFieldOffset(contextLockField);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }
}

