/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.impl.WireStore;
import org.jetbrains.annotations.NotNull;

public interface RollingChronicleQueue
extends ChronicleQueue {
    public static final long MINUS_1_40BIT = RollingChronicleQueue.toSequenceNumber(-1L);

    public long epoch();

    @NotNull
    public WireStore storeForCycle(long var1, long var3);

    public void release(@NotNull WireStore var1);

    public long cycle();

    public static long toSequenceNumber(long index) {
        long l = index & 0xFFFFFFFFFFL;
        return l == MINUS_1_40BIT ? -1L : l;
    }

    public static long toCycle(long index) {
        int result = (int)(index >> 40);
        if (result > 0x1000000) {
            throw new IllegalStateException("cycle value is too large, it must fit into 24bits, either use a larger rollType of increase the roll offset.");
        }
        if (result < 0) {
            throw new IllegalStateException("Invalid cycle=" + result + ", cycles can not be negative" + ".");
        }
        return result;
    }

    public static long index(long cycle, long sequenceNumber) {
        return (cycle << 40) + (sequenceNumber & 0xFFFFFFFFFFL);
    }
}

