/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.queue.Excerpt;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.RollingResourcesCache;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.WireStorePool;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerptFactory;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleChronicleQueue
implements RollingChronicleQueue {
    public static final int TIMEOUT = 10000;
    public static final String MESSAGE = "Timed out waiting for the header record to be ready in ";
    private static final String SUFFIX = ".cq4";
    @NotNull
    private final RollCycle cycle;
    @NotNull
    private final RollingResourcesCache dateCache;
    @NotNull
    private final WireStorePool pool;
    private final long epoch;
    private final boolean isBuffered;
    private final SingleChronicleQueueExcerptFactory excerptFactory;
    private final File path;
    private final WireType wireType;
    private final long blockSize;
    private final RollCycle rollCycle;
    private final Consumer<BytesRingBufferStats> onRingBufferStats;
    private final EventLoop eventLoop;
    private final long bufferCapacity;

    SingleChronicleQueue(@NotNull SingleChronicleQueueBuilder builder) {
        this.cycle = builder.rollCycle();
        this.dateCache = new RollingResourcesCache(this.cycle, name -> new File(builder.path(), name + SUFFIX));
        this.pool = WireStorePool.withSupplier(this::acquireStore);
        this.epoch = builder.epoch();
        this.isBuffered = builder.buffered();
        this.excerptFactory = builder.excertpFactory();
        this.path = builder.path();
        this.wireType = builder.wireType();
        this.blockSize = builder.blockSize();
        this.rollCycle = builder.rollCycle();
        this.eventLoop = builder.eventLoop();
        this.bufferCapacity = builder.bufferCapacity();
        this.onRingBufferStats = builder.onRingBufferStats();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    @NotNull
    public File path() {
        return this.path;
    }

    @Override
    public long epoch() {
        return this.epoch;
    }

    @NotNull
    public RollCycle rollCycle() {
        return this.cycle;
    }

    public boolean buffered() {
        return this.isBuffered;
    }

    @Nullable
    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    @Override
    @NotNull
    public Excerpt createExcerpt() {
        return this.excerptFactory.createExcerpt(this);
    }

    @Override
    @NotNull
    public ExcerptAppender createAppender() {
        return this.excerptFactory.createAppender(this);
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer() throws IOException {
        return this.excerptFactory.createTailer(this);
    }

    @Override
    @NotNull
    public final WireStore storeForCycle(long cycle, long epoch) {
        return this.pool.acquire(cycle, epoch);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public final void release(@NotNull WireStore store) {
        this.pool.release(store);
    }

    @Override
    public final long cycle() {
        return this.cycle.current(this.epoch);
    }

    @Override
    public long firstIndex() {
        long cycle = this.firstCycle();
        if (cycle == -1L) {
            return -1L;
        }
        WireStore store = this.acquireStore(cycle, this.epoch());
        return RollingChronicleQueue.index(store.cycle(), store.firstSequenceNumber());
    }

    private long firstCycle() {
        long firstCycle = -1L;
        String basePath = this.path.getAbsolutePath();
        File[] files = this.path.listFiles();
        if (files != null && files.length > 0) {
            long firstDate = Long.MAX_VALUE;
            for (int i = files.length - 1; i >= 0; --i) {
                try {
                    String name = files[i].getAbsolutePath();
                    if (!name.endsWith(SUFFIX)) continue;
                    name = name.substring(basePath.length() + 1);
                    long date = this.dateCache.parseCount(name = name.substring(0, name.indexOf(46)));
                    if (firstDate <= date) continue;
                    firstDate = date;
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            firstCycle = firstDate;
        }
        if (firstCycle == Long.MAX_VALUE) {
            return -1L;
        }
        return firstCycle;
    }

    @Override
    public long lastIndex() {
        long lastCycle = this.lastCycle();
        if (lastCycle == -1L) {
            return -1L;
        }
        return RollingChronicleQueue.index(lastCycle, this.acquireStore(lastCycle, this.epoch()).sequenceNumber());
    }

    private long lastCycle() {
        String basePath = this.path.getAbsolutePath();
        File[] files = this.path.listFiles();
        if (files != null && files.length > 0) {
            long lastDate = Long.MIN_VALUE;
            for (int i = files.length - 1; i >= 0; --i) {
                try {
                    String name = files[i].getAbsolutePath();
                    if (!name.endsWith(SUFFIX)) continue;
                    name = name.substring(basePath.length() + 1);
                    long date = this.dateCache.parseCount(name = name.substring(0, name.indexOf(46)));
                    if (lastDate >= date) continue;
                    lastDate = date;
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return lastDate;
        }
        return -1L;
    }

    public Consumer<BytesRingBufferStats> onRingBufferStats() {
        return this.onRingBufferStats;
    }

    public long blockSize() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    @NotNull
    public WireType wireType() {
        return this.wireType;
    }

    public long bufferCapacity() {
        return this.bufferCapacity;
    }

    private MappedBytes mappedBytes(File cycleFile) throws FileNotFoundException {
        long chunkSize = OS.pageAlign((long)this.blockSize);
        long overlapSize = OS.pageAlign((long)(this.blockSize / 4L));
        return MappedBytes.mappedBytes((File)cycleFile, (long)chunkSize, (long)overlapSize);
    }

    @NotNull
    private WireStore acquireStore(long cycle, long epoch) {
        RollingResourcesCache.Resource dateValue = this.dateCache.resourceFor(cycle);
        try {
            MappedBytes mappedBytes;
            File parentFile = dateValue.path.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            if ((mappedBytes = this.mappedBytes(dateValue.path)).compareAndSwapInt(0L, 0, -1073741824)) {
                SingleChronicleQueueStore wireStore = new SingleChronicleQueueStore(this.rollCycle, this.wireType, mappedBytes, epoch);
                Bytes bytes = (Bytes)mappedBytes.bytesForWrite().writePosition(4L);
                ((Wire)this.wireType.apply((Object)bytes)).getValueOut().typedMarshallable((WriteMarshallable)wireStore);
                wireStore.cycle(cycle);
                wireStore.writePosition(bytes.writePosition());
                mappedBytes.writeOrderedInt(0L, 0x40000000 | Wires.toIntU30((long)(bytes.writePosition() - 4L), (String)"Delegate too large=%,d"));
                return wireStore;
            }
            long end = System.currentTimeMillis() + 10000L;
            while ((mappedBytes.readVolatileInt(0L) & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                if (System.currentTimeMillis() > end) {
                    throw new IllegalStateException(MESSAGE + dateValue.path);
                }
                Jvm.pause((long)1L);
            }
            mappedBytes.readPosition(0L).writePosition(mappedBytes.capacity());
            int len = Wires.lengthOf((long)mappedBytes.readVolatileInt());
            mappedBytes.readLimit(mappedBytes.readPosition() + (long)len);
            return (WireStore)((Wire)this.wireType.apply((Object)mappedBytes)).getValueIn().typedMarshallable();
        }
        catch (FileNotFoundException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(SingleChronicleQueueStore.class, "WireStore");
    }
}

