/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.ExecutorService;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.threads.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum QueueFileShrinkManager {

    public static final String THREAD_NAME = "queue-file-shrink-daemon";
    static boolean RUN_SYNCHRONOUSLY = false;
    private static final Logger LOG = LoggerFactory.getLogger(QueueFileShrinkManager.class);
    private static final boolean DISABLE_QUEUE_FILE_SHRINKING = OS.isWindows() || Boolean.getBoolean("chronicle.queue.disableFileShrinking");
    private static final ExecutorService executor = Threads.acquireExecutorService((String)"queue-file-shrink-daemon", (int)1, (boolean)true);

    public static void scheduleShrinking(File queueFile, long writePos) {
        if (DISABLE_QUEUE_FILE_SHRINKING) {
            return;
        }
        Runnable task = () -> {
            while (true) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Shrinking {} to {}", (Object)queueFile, (Object)writePos);
                    }
                    RandomAccessFile raf = new RandomAccessFile(queueFile, "rw");
                    raf.setLength(writePos);
                    raf.close();
                }
                catch (IOException ex) {
                    if (ex.getMessage().contains("The requested operation cannot be performed on a file with a user-mapped section open")) continue;
                    LOG.warn("Failed to shrink file " + queueFile, (Throwable)ex);
                }
                break;
            }
        };
        if (RUN_SYNCHRONOUSLY) {
            task.run();
        } else {
            executor.submit(task);
        }
    }
}

