/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.ticker;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeTime {
    public static final boolean LOADED;
    private static final Logger LOGGER;
    private static double ticks_per_nanosecond;

    private static void calibrate(int ms) {
        long ticks1 = NativeTime.cpuid_rdtsc();
        long nanos1 = System.nanoTime();
        long end = nanos1 + (long)ms * 1000000L;
        while (System.nanoTime() < end) {
        }
        long ticks2 = NativeTime.cpuid_rdtsc();
        long nanos2 = System.nanoTime();
        ticks_per_nanosecond = (double)(ticks2 - ticks1) / (double)(nanos2 - nanos1);
    }

    public static double ticksPerNanosecond() {
        return ticks_per_nanosecond;
    }

    public static native long rdtsc();

    public static native long cpuid_rdtsc();

    public static native long rdtscp();

    public static native long clocknanos();

    static {
        LOGGER = LoggerFactory.getLogger(NativeTime.class);
        ticks_per_nanosecond = 1.0;
        boolean loaded = false;
        try {
            try {
                CodeSource src = NativeTime.class.getProtectionDomain().getCodeSource();
                if (src != null) {
                    String destDir = System.getProperty("java.io.tmpdir");
                    String osname = System.getProperty("os.name").toLowerCase();
                    String arch = System.getProperty("os.arch").toLowerCase();
                    String pattern = osname + File.separator + arch;
                    String jarFile = src.getLocation().getFile();
                    JarFile jar = new JarFile(jarFile);
                    Enumeration<JarEntry> enumEntries = jar.entries();
                    while (enumEntries.hasMoreElements()) {
                        File parent;
                        JarEntry file = enumEntries.nextElement();
                        if (!file.getName().contains(pattern)) continue;
                        File f = new File(destDir + File.separator + file.getName());
                        if (!f.exists() && (parent = f.getParentFile()) != null) {
                            parent.mkdirs();
                            f = new File(destDir + File.separator + file.getName());
                        }
                        if (file.isDirectory()) continue;
                        System.out.println("Unpacking " + file.getName() + " to " + f.toString());
                        InputStream is = jar.getInputStream(file);
                        FileOutputStream fos = new FileOutputStream(f);
                        while (is.available() > 0) {
                            fos.write(is.read());
                        }
                        fos.close();
                        is.close();
                    }
                    jar.close();
                    String libpath = System.getProperty("java.library.path");
                    libpath = libpath + File.pathSeparator + destDir + File.separator + pattern;
                    try {
                        System.setProperty("java.library.path", libpath);
                        Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
                        fieldSysPath.setAccessible(true);
                        fieldSysPath.set(null, null);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (NoSuchFieldException noSuchFieldException) {}
                }
            }
            catch (FileNotFoundException src) {
            }
            catch (IOException src) {
                // empty catch block
            }
            try {
                URL url = NativeTime.class.getClassLoader().getResource("libnativetime.so");
                if (url != null) {
                    System.load(url.getFile());
                    loaded = true;
                }
            }
            catch (Exception url) {
                // empty catch block
            }
            if (!loaded) {
                System.loadLibrary("nativetime");
            }
            NativeTime.calibrate(10);
            Thread t = new Thread(() -> NativeTime.calibrate(1000));
            t.setDaemon(true);
            t.start();
            loaded = true;
        }
        catch (UnsatisfiedLinkError ule) {
            LOGGER.debug("Unable to find libticker in [" + System.getProperty("java.library.path") + "] " + ule);
            loaded = false;
        }
        LOADED = loaded;
    }
}

