/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.values.BytecodeGen;
import net.openhft.chronicle.values.CodeTemplate;
import net.openhft.chronicle.values.CompilerUtils;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.Generators;
import net.openhft.chronicle.values.ImplGenerationFailedException;
import net.openhft.chronicle.values.Utils;

public class ValueModel {
    public static final String $$NATIVE = "$$Native";
    public static final String $$HEAP = "$$Heap";
    private static ClassValue<Object> classValueModel = new ClassValue<Object>(){

        @Override
        protected Object computeValue(Class<?> valueType) {
            try {
                return CodeTemplate.createValueModel(valueType);
            }
            catch (Exception e) {
                return e;
            }
        }
    };
    final Class<?> valueType;
    private final Map<FieldModel, FieldData> fieldData = new HashMap<FieldModel, FieldData>();
    private final List<FieldModel> orderedFields;
    private final int sizeInBytes;
    private volatile Class nativeClass;
    private volatile Class heapClass;

    public static ValueModel acquire(Class<?> valueType) {
        if (valueType.isInterface()) {
            if (CodeTemplate.NON_MODEL_TYPES.contains(valueType)) {
                throw ValueModel.notValueInterfaceOfImpl(valueType);
            }
            Object valueModelOrException = classValueModel.get(valueType);
            if (valueModelOrException instanceof ValueModel) {
                return (ValueModel)valueModelOrException;
            }
            throw new IllegalArgumentException((Exception)valueModelOrException);
        }
        return ValueModel.doSomethingForInterfaceOr(valueType, ValueModel::acquire, () -> {
            throw ValueModel.notValueInterfaceOfImpl(valueType);
        });
    }

    private static IllegalArgumentException notValueInterfaceOfImpl(Class<?> valueType) {
        return new IllegalArgumentException(valueType + " is not an interface nor " + "a generated class native or heap class");
    }

    private static <T> T doSomethingForInterfaceOr(Class<?> valueType, Function<Class, T> actionForInterface, Supplier<T> ifNotFound) {
        String typeName = valueType.getName();
        if (typeName.endsWith($$NATIVE) || typeName.endsWith($$HEAP)) {
            Type[] superInterfaces;
            for (Type superInterface : superInterfaces = valueType.getGenericInterfaces()) {
                Class rawInterface = ValueModel.rawInterface(superInterface);
                int firstDollarIndex = typeName.lastIndexOf(36) - 1;
                if (!rawInterface.getName().equals(typeName.substring(0, firstDollarIndex))) continue;
                return actionForInterface.apply(rawInterface);
            }
        }
        return ifNotFound.get();
    }

    static boolean isValueInterfaceOrImplClass(Class<?> valueType) {
        if (valueType.isInterface()) {
            if (CodeTemplate.NON_MODEL_TYPES.contains(valueType)) {
                return false;
            }
            Object valueModelOrException = classValueModel.get(valueType);
            return valueModelOrException instanceof ValueModel;
        }
        return ValueModel.doSomethingForInterfaceOr(valueType, ValueModel::isValueInterfaceOrImplClass, () -> false);
    }

    static Class rawInterface(Type superInterface) {
        if (superInterface instanceof Class) {
            return (Class)superInterface;
        }
        if (superInterface instanceof ParameterizedType) {
            return (Class)((ParameterizedType)superInterface).getRawType();
        }
        throw new AssertionError((Object)"Super interface should be a raw interface ora parameterized interface");
    }

    ValueModel(Class<?> valueType, Stream<FieldModel> fields) {
        this.valueType = valueType;
        this.orderedFields = new ArrayList<FieldModel>();
        this.sizeInBytes = this.arrangeFields(fields);
    }

    private int arrangeFields(Stream<FieldModel> fields) {
        TreeMap fieldGroups = fields.collect(Collectors.groupingBy(f -> f.groupOrder, TreeMap::new, Collectors.toList()));
        int watermark = 0;
        HashMap<Integer, FieldModel> fieldEnds = new HashMap<Integer, FieldModel>();
        for (Map.Entry e : fieldGroups.entrySet()) {
            List groupFields = (List)e.getValue();
            groupFields.sort(Comparator.comparing(FieldModel::maxAlignmentInBytes).thenComparing(FieldModel::sizeInBits).reversed());
            TreeSet<BitRange> holes = new TreeSet<BitRange>(Comparator.comparing(BitRange::size).reversed());
            block1: for (FieldModel field : groupFields) {
                int fieldOffsetAlignment = field.offsetAlignmentInBits();
                int fieldDontCrossAlignment = field.dontCrossAlignmentInBits();
                int fieldSize = field.sizeInBits();
                for (BitRange hole : holes) {
                    int fieldStartInHole = Utils.roundUp(hole.from, fieldOffsetAlignment);
                    int fieldEndInHole = fieldStartInHole + fieldSize;
                    if (fieldEndInHole >= hole.to || !ValueModel.dontCross(fieldStartInHole, fieldSize, fieldDontCrossAlignment)) continue;
                    this.fieldData.put(field, new FieldData(fieldStartInHole, fieldSize));
                    this.orderedFields.add(field);
                    fieldEnds.put(fieldEndInHole, field);
                    holes.remove(hole);
                    if (hole.from != fieldStartInHole) {
                        holes.add(new BitRange(hole.from, fieldStartInHole));
                    }
                    if (fieldEndInHole == hole.to) continue block1;
                    holes.add(new BitRange(fieldEndInHole, hole.to));
                    continue block1;
                }
                int fieldStart = Utils.roundUp(watermark, fieldOffsetAlignment);
                if (!ValueModel.dontCross(fieldStart, fieldSize, fieldDontCrossAlignment)) {
                    assert (fieldDontCrossAlignment != 0);
                    fieldStart = Utils.roundUp(watermark, fieldDontCrossAlignment);
                    assert (ValueModel.dontCross(fieldStart, fieldSize, fieldDontCrossAlignment));
                }
                this.fieldData.put(field, new FieldData(fieldStart, fieldSize));
                this.orderedFields.add(field);
                int fieldEnd = fieldStart + fieldSize;
                fieldEnds.put(fieldEnd, field);
                if (fieldStart > watermark) {
                    holes.add(new BitRange(watermark, fieldStart));
                }
                watermark = fieldEnd;
            }
            for (BitRange hole : holes) {
                if (hole.from == 0) continue;
                FieldModel fieldToExtend = (FieldModel)fieldEnds.remove(hole.from);
                assert (fieldToExtend != null);
                this.fieldData.get((Object)fieldToExtend).bitExtent += hole.size();
            }
        }
        int byteRoundedWatermark = Utils.roundUp(watermark, 8);
        if (byteRoundedWatermark != watermark) {
            FieldModel lastField = (FieldModel)fieldEnds.remove(watermark);
            assert (lastField != null);
            this.fieldData.get((Object)lastField).bitExtent += byteRoundedWatermark - watermark;
        }
        return byteRoundedWatermark / 8;
    }

    private static boolean dontCross(int from, int size, int alignment) {
        return alignment == 0 || from / alignment == (from + size - 1) / alignment;
    }

    public Stream<FieldModel> fields() {
        return this.orderedFields.stream();
    }

    Class firstPrimitiveFieldType() {
        Class firstFieldType = this.orderedFields.get((int)0).type;
        if (firstFieldType.isPrimitive()) {
            return firstFieldType;
        }
        return ValueModel.acquire(firstFieldType).firstPrimitiveFieldType();
    }

    public int recommendedOffsetAlignment() {
        return Math.max(this.fields().mapToInt(FieldModel::maxAlignmentInBytes).max().getAsInt(), 1);
    }

    public int sizeInBytes() {
        return this.sizeInBytes;
    }

    int fieldBitOffset(FieldModel field) {
        return this.fieldData.get((Object)field).bitOffset;
    }

    int fieldBitExtent(FieldModel field) {
        return this.fieldData.get((Object)field).bitExtent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class nativeClass() {
        Class c = this.nativeClass;
        if (c != null) {
            return c;
        }
        ValueModel valueModel = this;
        synchronized (valueModel) {
            c = this.nativeClass;
            if (c != null) {
                return c;
            }
            this.nativeClass = c = this.createNativeClass();
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class heapClass() {
        Class c = this.heapClass;
        if (c != null) {
            return c;
        }
        ValueModel valueModel = this;
        synchronized (valueModel) {
            c = this.heapClass;
            if (c != null) {
                return c;
            }
            this.heapClass = c = this.createHeapClass();
            return c;
        }
    }

    private Class createNativeClass() {
        return this.createClass(this.simpleName() + $$NATIVE, Generators::generateNativeClass);
    }

    private Class createHeapClass() {
        return this.createClass(this.simpleName() + $$HEAP, Generators::generateHeapClass);
    }

    String simpleName() {
        return ValueModel.simpleName(this.valueType);
    }

    static String simpleName(Class<?> type) {
        String name = type.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private Class createClass(String className, BiFunction<ValueModel, String, String> generateClass) {
        String classNameWithPackage = this.valueType.getPackage().getName() + "." + className;
        ClassLoader cl = BytecodeGen.getClassLoader(this.valueType);
        try {
            return cl.loadClass(classNameWithPackage);
        }
        catch (ClassNotFoundException ignored) {
            String javaCode = generateClass.apply(this, className);
            try {
                return CompilerUtils.CACHED_COMPILER.loadFromJava(this.valueType, cl, classNameWithPackage, javaCode);
            }
            catch (ClassNotFoundException e) {
                throw new ImplGenerationFailedException(e);
            }
        }
    }

    private static class BitRange {
        int from;
        int to;

        BitRange(int from, int to) {
            this.from = from;
            this.to = to;
        }

        int size() {
            return this.to - this.from;
        }
    }

    private static class FieldData {
        int bitOffset;
        int bitExtent;

        private FieldData(int bitOffset, int bitExtent) {
            this.bitOffset = bitOffset;
            this.bitExtent = bitExtent;
        }
    }
}

