/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.nio.BufferUnderflowException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.EscapingStopCharTester;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.StringInterner;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.util.BooleanConsumer;
import net.openhft.chronicle.util.ByteConsumer;
import net.openhft.chronicle.util.FloatConsumer;
import net.openhft.chronicle.util.ShortConsumer;
import net.openhft.chronicle.wire.IntTextReference;
import net.openhft.chronicle.wire.LongArrayTextReference;
import net.openhft.chronicle.wire.LongTextReference;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;

public class TextWire
implements Wire {
    public static final String FIELD_SEP = "";
    private static final String END_FIELD = "\n";
    final Bytes<?> bytes;
    final ValueOut valueOut = new TextValueOut();
    final ValueIn valueIn = new TextValueIn();
    String sep = "";

    public TextWire(Bytes<?> bytes) {
        this.bytes = bytes;
    }

    public static String asText(Wire wire) {
        TextWire tw = new TextWire((Bytes<?>)NativeBytes.nativeBytes());
        wire.copyTo(tw);
        tw.flip();
        wire.flip();
        return tw.toString();
    }

    @Override
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    public WireOut addPadding(int paddingToAdd) {
        for (int i = 0; i < paddingToAdd; ++i) {
            this.bytes.append((this.bytes.position() & 0x3FL) == 0L ? (char)'\n' : ' ');
        }
        return this;
    }

    @Override
    public void copyTo(WireOut wire) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueOut write() {
        ((Bytes)this.bytes.append((CharSequence)this.sep)).append((CharSequence)"\"\": ");
        this.sep = FIELD_SEP;
        return this.valueOut;
    }

    @Override
    public ValueOut writeValue() {
        return this.valueOut;
    }

    @Override
    public ValueOut write(WireKey key) {
        CharSequence name = key.name();
        if (name == null) {
            name = Integer.toString(key.code());
        }
        ((Bytes)((Bytes)this.bytes.append((CharSequence)this.sep)).append(this.quotes(name))).append((CharSequence)":");
        this.sep = " ";
        return this.valueOut;
    }

    @Override
    public ValueIn read() {
        this.readField(Wires.acquireStringBuilder());
        return this.valueIn;
    }

    private void consumeWhiteSpace() {
        while (this.bytes.remaining() > 0L && Character.isWhitespace(this.bytes.readUnsignedByte(this.bytes.position()))) {
            this.bytes.skip(1L);
        }
    }

    private StringBuilder readField(StringBuilder sb) {
        this.consumeWhiteSpace();
        try {
            int ch = this.peekCode();
            if (ch == 34) {
                this.bytes.skip(1L);
                this.bytes.parseUTF(sb, EscapingStopCharTester.escaping(c -> c == 34));
                this.consumeWhiteSpace();
                ch = this.readCode();
                if (ch != 58) {
                    throw new UnsupportedOperationException("Expected a : at " + this.bytes.toDebugString());
                }
            } else {
                if (ch < 0) {
                    sb.setLength(0);
                    return sb;
                }
                this.bytes.parseUTF(sb, EscapingStopCharTester.escaping(c -> c < 32 || c == 58));
            }
            this.unescape(sb);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        this.consumeWhiteSpace();
        return sb;
    }

    @Override
    public ValueIn read(WireKey key) {
        long position = this.bytes.position();
        StringBuilder sb = this.readField(Wires.acquireStringBuilder());
        if (sb.length() == 0 || StringInterner.isEqual((CharSequence)sb, (CharSequence)key.name())) {
            return this.valueIn;
        }
        this.bytes.position(position);
        throw new UnsupportedOperationException("Unordered fields not supported yet. key=" + key.name());
    }

    @Override
    public ValueIn read(StringBuilder name) {
        this.consumeWhiteSpace();
        this.readField(name);
        return this.valueIn;
    }

    private int peekCode() {
        if (this.bytes.remaining() < 1L) {
            return -1;
        }
        long pos = this.bytes.position();
        return this.bytes.readUnsignedByte(pos);
    }

    private int readCode() {
        if (this.bytes.remaining() < 1L) {
            return -1;
        }
        return this.bytes.readUnsignedByte();
    }

    @Override
    public boolean hasNextSequenceItem() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMapping() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasDocument() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flip() {
        this.bytes.flip();
    }

    @Override
    public void clear() {
        this.bytes.clear();
    }

    public String toString() {
        return this.bytes.toString();
    }

    CharSequence quotes(CharSequence s) {
        if (!this.needsQuotes(s)) {
            return s;
        }
        StringBuilder sb2 = Wires.acquireAnotherStringBuilder(s);
        sb2.append('\"');
        block4: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': 
                case '\\': {
                    sb2.append('\\').append(ch);
                    continue block4;
                }
                case '\n': {
                    sb2.append("\\n");
                    continue block4;
                }
                default: {
                    sb2.append(ch);
                }
            }
        }
        sb2.append('\"');
        return sb2;
    }

    boolean needsQuotes(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            if ("\" ,\n\\".indexOf(s.charAt(i)) < 0) continue;
            return true;
        }
        return s.length() == 0;
    }

    @Override
    public Wire writeComment(CharSequence s) {
        ((Bytes)((Bytes)((Bytes)this.bytes.append((CharSequence)this.sep)).append((CharSequence)"# ")).append(s)).append((CharSequence)END_FIELD);
        this.sep = FIELD_SEP;
        return this;
    }

    @Override
    public Wire readComment(StringBuilder s) {
        throw new UnsupportedOperationException();
    }

    private void unescape(StringBuilder sb) {
        for (int i = 0; i < sb.length(); ++i) {
            char ch2 = sb.charAt(i);
            if (ch2 != '\\') continue;
            sb.deleteCharAt(i);
            char ch3 = sb.charAt(i);
            switch (ch3) {
                case 'n': {
                    sb.setCharAt(i, '\n');
                }
            }
        }
    }

    class TextValueIn
    implements ValueIn {
        TextValueIn() {
        }

        @Override
        public boolean hasNext() {
            return TextWire.this.bytes.remaining() > 0L;
        }

        @Override
        public WireIn expectText(CharSequence s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public WireIn uuid(Consumer<UUID> uuid) {
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            uuid.accept(UUID.fromString(sb.toString()));
            return TextWire.this;
        }

        public WireIn bytes(Bytes toBytes) {
            return this.bytes(arg_0 -> ((Bytes)toBytes).write(arg_0));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public WireIn bytes(Consumer<byte[]> bytesConsumer) {
            StringBuilder sb = Wires.acquireStringBuilder();
            if (TextWire.this.peekCode() == 33) {
                TextWire.this.bytes.parseUTF(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = sb.toString();
                if (!str.equals("!!binary")) throw new IORuntimeException("Unsupported type " + str);
                sb.setLength(0);
                TextWire.this.bytes.parseUTF(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                byte[] decode = Base64.getDecoder().decode(sb.toString());
                bytesConsumer.accept(decode);
                return TextWire.this;
            } else {
                this.text(sb);
                bytesConsumer.accept(sb.toString().getBytes());
            }
            return TextWire.this;
        }

        @Override
        public byte[] bytes() {
            StringBuilder sb = Wires.acquireStringBuilder();
            if (TextWire.this.peekCode() == 33) {
                TextWire.this.bytes.parseUTF(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = sb.toString();
                if (str.equals("!!binary")) {
                    sb.setLength(0);
                    TextWire.this.bytes.parseUTF(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                    byte[] decode = Base64.getDecoder().decode(sb.toString());
                    return decode;
                }
                throw new IORuntimeException("Unsupported type " + str);
            }
            this.text(sb);
            return sb.toString().getBytes();
        }

        @Override
        public WireIn wireIn() {
            return TextWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long readLength() {
            long start = TextWire.this.bytes.position();
            try {
                TextWire.this.consumeWhiteSpace();
                int code = TextWire.this.readCode();
                switch (code) {
                    case 123: {
                        int count = 1;
                        while (true) {
                            byte b;
                            if ((b = TextWire.this.bytes.readByte()) == 123) {
                                ++count;
                                continue;
                            }
                            if (b != 125 || --count != 0) continue;
                            long l = TextWire.this.bytes.position() - start;
                            return l;
                        }
                    }
                    case 91: {
                        int countSeq = 1;
                        while (true) {
                            byte b;
                            if ((b = TextWire.this.bytes.readByte()) == 91) {
                                ++countSeq;
                                continue;
                            }
                            if (b != 93 || --countSeq != 0) continue;
                            long l = TextWire.this.bytes.position() - start;
                            return l;
                        }
                    }
                }
                this.bytes();
                long l = TextWire.this.bytes.position() - start;
                return l;
            }
            finally {
                TextWire.this.bytes.position(start);
            }
        }

        @Override
        public WireIn int64(LongValue value, Consumer<LongValue> setter) {
            if (!(value instanceof LongTextReference)) {
                value = new LongTextReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore(TextWire.this.bytes, TextWire.this.bytes.position(), length);
            TextWire.this.bytes.skip(length);
            return TextWire.this;
        }

        @Override
        public WireIn int64array(LongArrayValues values, Consumer<LongArrayValues> setter) {
            if (!(values instanceof LongTextReference)) {
                values = new LongArrayTextReference();
                setter.accept(values);
            }
            Byteable b = (Byteable)values;
            long length = LongArrayTextReference.peakLength(TextWire.this.bytes, TextWire.this.bytes.position());
            b.bytesStore(TextWire.this.bytes, TextWire.this.bytes.position(), length);
            TextWire.this.bytes.skip(length);
            return TextWire.this;
        }

        @Override
        public WireIn int32(IntValue value, Consumer<IntValue> setter) {
            if (!(value instanceof IntTextReference)) {
                value = new IntTextReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore(TextWire.this.bytes, TextWire.this.bytes.position(), length);
            TextWire.this.bytes.skip(length);
            return TextWire.this;
        }

        @Override
        public WireIn sequence(Consumer<ValueIn> reader) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WireIn marshallable(ReadMarshallable object) {
            TextWire.this.consumeWhiteSpace();
            int code = TextWire.this.peekCode();
            if (code != 123) {
                throw new IORuntimeException("Unsupported type " + (char)code);
            }
            long len = this.readLength() - 1L;
            long limit = TextWire.this.bytes.limit();
            long position = TextWire.this.bytes.position();
            try {
                long newLimit = position - 1L + len;
                TextWire.this.bytes.limit(newLimit);
                TextWire.this.bytes.skip(1L);
                TextWire.this.consumeWhiteSpace();
                object.readMarshallable(TextWire.this);
            }
            finally {
                TextWire.this.bytes.limit(limit);
            }
            TextWire.this.consumeWhiteSpace();
            code = TextWire.this.readCode();
            if (code != 125) {
                throw new IORuntimeException("Unterminated { while reading marshallable " + object + "bytes=" + Bytes.toDebugString(TextWire.this.bytes));
            }
            return TextWire.this;
        }

        @Override
        public long int64() {
            return TextWire.this.bytes.parseLong();
        }

        @Override
        public double float64() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public float float32() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public boolean isNull() {
            long pos = TextWire.this.bytes.position();
            for (byte b : "!!null".getBytes()) {
                if (TextWire.this.bytes.readByte(pos++) == b) continue;
                return false;
            }
            TextWire.this.bytes.skipTo((StopCharTester)StopCharTesters.COMMA_STOP);
            return true;
        }

        @Override
        public byte int8() {
            long l = this.int64();
            if (l > 127L || l < -128L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Byte.MAX_VALUE/MIN_VALUE");
            }
            return (byte)l;
        }

        @Override
        public short int16() {
            long l = this.int64();
            if (l > 32767L || l < -32768L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Short.MAX_VALUE/MIN_VALUE");
            }
            return (short)l;
        }

        @Override
        public int int32() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/MIN_VALUE");
            }
            return (int)l;
        }

        @Override
        public Wire type(StringBuilder s) {
            int code = TextWire.this.readCode();
            if (code != 33) {
                throw new UnsupportedOperationException(WireType.stringForCode(code));
            }
            TextWire.this.bytes.parseUTF(s, (StopCharTester)StopCharTesters.SPACE_STOP);
            return TextWire.this;
        }

        @Override
        public Wire text(StringBuilder s) {
            int ch = TextWire.this.peekCode();
            StringBuilder sb = s;
            if (ch == 123) {
                long len = this.readLength();
                sb.append(Bytes.toDebugString(TextWire.this.bytes, (long)TextWire.this.bytes.position(), (long)len));
                TextWire.this.bytes.skip(len);
                TextWire.this.bytes.skipTo((StopCharTester)StopCharTesters.COMMA_STOP);
                return TextWire.this;
            }
            if (ch == 34) {
                TextWire.this.bytes.skip(1L);
                TextWire.this.bytes.parseUTF(sb, EscapingStopCharTester.escaping(c -> c == 34));
                TextWire.this.consumeWhiteSpace();
            } else {
                TextWire.this.bytes.parseUTF(sb, EscapingStopCharTester.escaping((StopCharTester)StopCharTesters.COMMA_STOP));
            }
            TextWire.this.unescape(sb);
            return TextWire.this;
        }

        @Override
        public WireIn text(Consumer<String> s) {
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            s.accept(sb.toString());
            return TextWire.this;
        }

        @Override
        public String text() {
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            return sb.toString();
        }

        @Override
        public Wire bool(BooleanConsumer flag) {
            StringBuilder sb = Wires.acquireStringBuilder();
            TextWire.this.bytes.parseUTF(sb, (StopCharTester)StopCharTesters.COMMA_STOP);
            if (StringInterner.isEqual((CharSequence)sb, (CharSequence)"true")) {
                flag.accept(true);
            } else if (StringInterner.isEqual((CharSequence)sb, (CharSequence)"false")) {
                flag.accept(false);
            } else if (StringInterner.isEqual((CharSequence)sb, (CharSequence)"!!null")) {
                flag.accept(null);
            } else {
                throw new UnsupportedOperationException();
            }
            return TextWire.this;
        }

        @Override
        public boolean bool() {
            StringBuilder sb = Wires.acquireStringBuilder();
            TextWire.this.bytes.parseUTF(sb, (StopCharTester)StopCharTesters.COMMA_STOP);
            if (StringInterner.isEqual((CharSequence)sb, (CharSequence)"true")) {
                return true;
            }
            if (StringInterner.isEqual((CharSequence)sb, (CharSequence)"false")) {
                return false;
            }
            if (StringInterner.isEqual((CharSequence)sb, (CharSequence)"!!null")) {
                throw new NullPointerException("value is null");
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public Wire int8(ByteConsumer i) {
            i.accept((byte)TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        public Wire uint8(ShortConsumer i) {
            i.accept((short)TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        public Wire int16(ShortConsumer i) {
            i.accept((short)TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        public Wire uint16(IntConsumer i) {
            i.accept((int)TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        public Wire uint32(LongConsumer i) {
            i.accept(TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        public Wire int32(IntConsumer i) {
            i.accept((int)TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        public Wire float32(FloatConsumer v) {
            v.accept((float)TextWire.this.bytes.parseDouble());
            return TextWire.this;
        }

        @Override
        public Wire float64(DoubleConsumer v) {
            v.accept(TextWire.this.bytes.parseDouble());
            return TextWire.this;
        }

        @Override
        public Wire int64(LongConsumer i) {
            i.accept(TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        public Wire time(Consumer<LocalTime> localTime) {
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            localTime.accept(LocalTime.parse(sb.toString()));
            return TextWire.this;
        }

        @Override
        public Wire zonedDateTime(Consumer<ZonedDateTime> zonedDateTime) {
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            zonedDateTime.accept(ZonedDateTime.parse(sb.toString()));
            return TextWire.this;
        }

        @Override
        public Wire date(Consumer<LocalDate> localDate) {
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            localDate.accept(LocalDate.parse(sb.toString()));
            return TextWire.this;
        }
    }

    class TextValueOut
    implements ValueOut {
        boolean nested = false;

        TextValueOut() {
        }

        @Override
        public boolean isNested() {
            return this.nested;
        }

        @Override
        public WireOut nested(boolean nested) {
            this.nested = nested;
            return TextWire.this;
        }

        @Override
        public Wire text(CharSequence s) {
            if (s != null && " ".equals(TextWire.this.sep) && this.startsWith(s, "//")) {
                TextWire.this.sep = TextWire.FIELD_SEP;
            }
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append(s == null ? "!!null" : TextWire.this.quotes(s));
            this.separator();
            return TextWire.this;
        }

        public void separator() {
            if (this.isNested()) {
                TextWire.this.sep = ", ";
            } else {
                TextWire.this.bytes.append((CharSequence)TextWire.END_FIELD);
                TextWire.this.sep = TextWire.FIELD_SEP;
            }
        }

        private boolean startsWith(CharSequence s, String starts) {
            if (s.length() < starts.length()) {
                return false;
            }
            for (int i = 0; i < starts.length(); ++i) {
                if (s.charAt(i) == starts.charAt(i)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Wire type(CharSequence typeName) {
            ((Bytes)((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append('!')).append(typeName);
            TextWire.this.sep = " ";
            return TextWire.this;
        }

        @Override
        public WireOut uuid(UUID uuid) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((CharSequence)uuid.toString());
            this.separator();
            return TextWire.this;
        }

        @Override
        public WireOut int64forBinding(long value) {
            TextWire.this.bytes.append((CharSequence)TextWire.this.sep);
            LongTextReference.write(TextWire.this.bytes, value);
            this.separator();
            return TextWire.this;
        }

        @Override
        public WireOut int32forBinding(int value) {
            TextWire.this.bytes.append((CharSequence)TextWire.this.sep);
            IntTextReference.write(TextWire.this.bytes, value);
            this.separator();
            return TextWire.this;
        }

        @Override
        public WireOut sequence(Consumer<ValueOut> writer) {
            boolean nested = this.isNested();
            this.nested(true);
            try {
                TextWire.this.bytes.append((CharSequence)TextWire.this.sep);
                TextWire.this.sep = TextWire.FIELD_SEP;
                TextWire.this.bytes.append((CharSequence)"[ ");
                writer.accept(this);
                TextWire.this.bytes.append((CharSequence)" ]");
                TextWire.this.sep = TextWire.FIELD_SEP;
            }
            finally {
                this.nested(nested);
            }
            return TextWire.this;
        }

        @Override
        public WireOut marshallable(WriteMarshallable object) {
            TextWire.this.bytes.append((CharSequence)TextWire.this.sep);
            TextWire.this.bytes.append((CharSequence)"{ ");
            TextWire.this.sep = TextWire.FIELD_SEP;
            boolean nested = this.isNested();
            try {
                this.nested(true);
                object.writeMarshallable(TextWire.this);
            }
            finally {
                this.nested(nested);
            }
            TextWire.this.bytes.append(' ');
            TextWire.this.bytes.append('}');
            TextWire.this.sep = nested ? ", " : TextWire.END_FIELD;
            return TextWire.this;
        }

        @Override
        public Wire bool(Boolean flag) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((CharSequence)(flag == null ? "!!null" : (flag != false ? "true" : "false")));
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire int8(byte i8) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((long)i8);
            this.separator();
            return TextWire.this;
        }

        @Override
        public WireOut bytes(Bytes fromBytes) {
            if (this.isText(fromBytes)) {
                return this.text((CharSequence)fromBytes);
            }
            int length = Maths.toInt32((long)fromBytes.remaining());
            byte[] byteArray = new byte[length];
            fromBytes.read(byteArray);
            return this.bytes(byteArray);
        }

        private boolean isText(Bytes fromBytes) {
            for (long i = fromBytes.position(); i < fromBytes.readLimit(); ++i) {
                int ch = fromBytes.readUnsignedByte(i);
                if ((ch >= 32 || ch == 9) && ch < 127) continue;
                return false;
            }
            return true;
        }

        @Override
        public ValueOut writeLength(long remaining) {
            throw new UnsupportedOperationException();
        }

        @Override
        public WireOut bytes(byte[] byteArray) {
            ((Bytes)((Bytes)((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((CharSequence)"!!binary ")).append((CharSequence)Base64.getEncoder().encodeToString(byteArray))).append((CharSequence)TextWire.END_FIELD);
            TextWire.this.sep = TextWire.FIELD_SEP;
            return TextWire.this;
        }

        @Override
        public Wire uint8checked(int u8) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((long)u8);
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire int16(short i16) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((long)i16);
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire uint16checked(int u16) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((long)u16);
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire utf8(int codepoint) {
            StringBuilder sb = Wires.acquireStringBuilder();
            sb.appendCodePoint(codepoint);
            this.text(sb);
            TextWire.this.sep = TextWire.FIELD_SEP;
            return TextWire.this;
        }

        @Override
        public Wire int32(int i32) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((long)i32);
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire uint32checked(long u32) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append(u32);
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire float32(float f) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append(f);
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire float64(double d) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append(d);
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire int64(long i64) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append(i64);
            this.separator();
            return TextWire.this;
        }

        @Override
        public WireOut int64array(long capacity) {
            LongArrayTextReference.write(TextWire.this.bytes, capacity);
            return TextWire.this;
        }

        @Override
        public Wire time(LocalTime localTime) {
            TextWire.this.bytes.append((CharSequence)localTime.toString());
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire zonedDateTime(ZonedDateTime zonedDateTime) {
            TextWire.this.bytes.append((CharSequence)zonedDateTime.toString());
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire date(LocalDate localDate) {
            TextWire.this.bytes.append((CharSequence)localDate.toString());
            this.separator();
            return TextWire.this;
        }
    }
}

