/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Wires
extends Enum<Wires> {
    public static final int NOT_READY = Integer.MIN_VALUE;
    public static final int META_DATA = 0x40000000;
    public static final int UNKNOWN_LENGTH = 0;
    public static final int LENGTH_MASK = 0x3FFFFFFF;
    static final StringBuilderPool SBP;
    static final StringBuilderPool ASBP;
    private static Consumer<WireIn> emptyMetaDataConsumer;
    private static final /* synthetic */ Wires[] $VALUES;

    public static Wires[] values() {
        return (Wires[])$VALUES.clone();
    }

    public static Wires valueOf(String name) {
        return Enum.valueOf(Wires.class, name);
    }

    public static StringBuilder acquireStringBuilder() {
        return SBP.acquireStringBuilder();
    }

    public static StringBuilder acquireAnotherStringBuilder(CharSequence cs) {
        StringBuilder sb = ASBP.acquireStringBuilder();
        assert (sb != cs);
        return sb;
    }

    public static void writeData(WireOut wireOut, boolean metaData, Consumer<WireOut> writer) {
        Bytes bytes = wireOut.bytes();
        long position = bytes.position();
        int metaDataBit = metaData ? 0x40000000 : 0;
        bytes.writeInt(metaDataBit | Integer.MIN_VALUE | 0);
        writer.accept(wireOut);
        int length = metaDataBit | BinaryWire.toIntU30(bytes.position() - position - 4L, "Document length %,d out of 30-bit int range.");
        bytes.writeOrderedInt(position, length);
    }

    public static boolean readData(@NotNull WireIn wireIn, @Nullable Consumer<WireIn> metaDataConsumer, @Nullable Consumer<WireIn> dataConsumer) {
        Bytes<?> bytes = wireIn.bytes();
        boolean read = false;
        while (bytes.remaining() >= 4L) {
            long position = bytes.position();
            int header = bytes.readVolatileInt(position);
            if (!Wires.isKnownLength(header)) {
                return read;
            }
            bytes.skip(4L);
            int len = Wires.lengthOf(header);
            if (Wires.isData(header)) {
                if (dataConsumer == null) {
                    return false;
                }
                wireIn.bytes().withLength((long)len, b -> dataConsumer.accept(wireIn));
                return true;
            }
            if (metaDataConsumer == null) {
                wireIn.bytes().skip((long)len);
            } else {
                wireIn.bytes().withLength((long)len, b -> metaDataConsumer.accept(wireIn));
            }
            if (dataConsumer == null) {
                return true;
            }
            read = true;
        }
        return read;
    }

    public static String fromSizePrefixedBlobs(Bytes bytes) {
        long position = bytes.position();
        return Wires.fromSizePrefixedBlobs(bytes, position, bytes.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String fromSizePrefixedBlobs(Bytes bytes, long position, long length) {
        StringBuilder sb = new StringBuilder();
        long limit0 = bytes.limit();
        long position0 = bytes.position();
        try {
            bytes.position(position);
            bytes.limit(position + length);
            while (bytes.remaining() >= 4L) {
                long header = bytes.readUnsignedInt();
                int len = Wires.lengthOf(header);
                String type = Wires.isData(header) ? (Wires.isReady(header) ? "!!data" : "!!not-ready-data!") : (Wires.isReady(header) ? "!!meta-data" : "!!not-ready-meta-data!");
                sb.append("--- ").append(type).append("\n");
                for (int i = 0; i < len; ++i) {
                    sb.append((char)bytes.readUnsignedByte());
                }
                if (sb.charAt(sb.length() - 1) == '\n') continue;
                sb.append('\n');
            }
            String string = sb.toString();
            return string;
        }
        finally {
            bytes.limit(limit0);
            bytes.position(position0);
        }
    }

    public static int lengthOf(long len) {
        return (int)(len & 0x3FFFFFFFL);
    }

    public static boolean isReady(long len) {
        return (len & Integer.MIN_VALUE) == 0L;
    }

    public static boolean isData(long len) {
        return (len & 0x40000000L) == 0L;
    }

    public static boolean isKnownLength(long len) {
        return (len & Integer.MAX_VALUE) != 0L;
    }

    static {
        $VALUES = new Wires[0];
        SBP = new StringBuilderPool();
        ASBP = new StringBuilderPool();
        emptyMetaDataConsumer = new Consumer<WireIn>(){

            @Override
            public void accept(WireIn wireIn) {
            }
        };
    }
}

