/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Quotes;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextIntReference;
import net.openhft.chronicle.wire.TextLongArrayReference;
import net.openhft.chronicle.wire.TextLongReference;
import net.openhft.chronicle.wire.TextStopCharTesters;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.WriteValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xerial.snappy.Snappy;

public class JSONWire
extends TextWire {
    static final BytesStore COMMA = BytesStore.from((CharSequence)",");

    public JSONWire(Bytes bytes, boolean use8bit) {
        super(bytes, use8bit);
    }

    public JSONWire(Bytes bytes) {
        this(bytes, false);
    }

    @NotNull
    public static JSONWire from(@NotNull String text) {
        return new JSONWire(Bytes.from((CharSequence)text));
    }

    public static String asText(@NotNull Wire wire) {
        long pos = wire.bytes().readPosition();
        JSONWire tw = new JSONWire((Bytes)NativeBytes.nativeBytes());
        wire.copyTo(tw);
        wire.bytes().readPosition(pos);
        return tw.toString();
    }

    public static <ACS extends Appendable & CharSequence> void unescape(@NotNull ACS sb) {
        int end = 0;
        int length = ((CharSequence)sb).length();
        for (int i = 0; i < length; ++i) {
            int ch = ((CharSequence)sb).charAt(i);
            if (ch == 92 && i < length - 1) {
                char ch3 = ((CharSequence)sb).charAt(++i);
                switch (ch3) {
                    case 'n': {
                        ch = 10;
                        break;
                    }
                    case 't': {
                        ch = 9;
                        break;
                    }
                    default: {
                        ch = ch3;
                    }
                }
            }
            AppendableUtil.setCharAt(sb, (int)end++, (char)ch);
        }
        if (length != ((CharSequence)sb).length()) {
            throw new IllegalStateException("Length changed from " + length + " to " + ((CharSequence)sb).length() + " for " + sb);
        }
        AppendableUtil.setLength(sb, (int)end);
    }

    @Override
    @NotNull
    protected TextWire.TextValueOut createValueOut() {
        return new JSONValueOut();
    }

    @Override
    @NotNull
    protected TextWire.TextValueIn createValueIn() {
        return new JSONValueIn();
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    private StopCharsTester getEscapingEndOfText() {
        StopCharsTester escaping = (StopCharsTester)ESCAPED_END_OF_TEXT.get();
        escaping.isStopChar(32, 32);
        return escaping;
    }

    private StopCharTester getEscapingQuotes() {
        StopCharTester sct = (StopCharTester)ESCAPED_QUOTES.get();
        sct.isStopChar(32);
        return sct;
    }

    @Override
    void consumeWhiteSpace() {
        block0: while (true) {
            int codePoint;
            if ((codePoint = this.peekCode()) == 35) {
                while (true) {
                    if (this.readCode() < 32) continue block0;
                }
            }
            if (!Character.isWhitespace(codePoint) && codePoint != 44) break;
            this.bytes.readSkip(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean peekStringIgnoreCase(@NotNull String source) {
        if (source.isEmpty()) {
            return true;
        }
        if (this.bytes.readRemaining() < 1L) {
            return false;
        }
        long pos = this.bytes.readPosition();
        try {
            for (int i = 0; i < source.length(); ++i) {
                if (Character.toLowerCase(source.charAt(i)) == Character.toLowerCase(this.bytes.readByte())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.bytes.readPosition(pos);
        }
        return true;
    }

    private int readCode() {
        if (this.bytes.readRemaining() < 1L) {
            return -1;
        }
        return this.bytes.readUnsignedByte();
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        long position = this.bytes.readPosition();
        StringBuilder sb = this.readField(WireInternal.acquireStringBuilder());
        if (sb.length() == 0 || StringUtils.isEqual((CharSequence)sb, (CharSequence)key.name())) {
            return this.valueIn;
        }
        this.bytes.readPosition(position);
        throw new UnsupportedOperationException("Unordered fields not supported yet. key=" + key.name() + ", was=" + sb + ", data='" + sb + "'");
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.consumeWhiteSpace();
        this.readField(name);
        return this.valueIn;
    }

    @Override
    public boolean hasMore() {
        this.consumeWhiteSpace();
        return this.bytes.readRemaining() > 0L;
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        return this.valueOut.write(key);
    }

    @Override
    @NotNull
    public Wire writeComment(@NotNull CharSequence s) {
        this.valueOut.writeComment(s);
        return this;
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        for (int i = 0; i < paddingToAdd; ++i) {
            this.bytes.appendUtf8((this.bytes.writePosition() & 0x3FL) == 0L ? 10 : 32);
        }
        return this;
    }

    void escaped(@NotNull CharSequence s) {
        if (this.needsQuotes(s) == Quotes.NONE) {
            this.bytes.appendUtf8(s);
            return;
        }
        this.doEscape(s);
    }

    private void doEscape(@NotNull CharSequence s) {
        block4: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': 
                case '\\': {
                    ((Bytes)this.bytes.appendUtf8(92)).appendUtf8((int)ch);
                    continue block4;
                }
                case '\n': {
                    this.bytes.appendUtf8((CharSequence)"\\n");
                    continue block4;
                }
                default: {
                    this.bytes.appendUtf8((int)ch);
                }
            }
        }
    }

    @Override
    public void parseWord(StringBuilder sb) {
        this.parseUntil(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
    }

    @Override
    public void parseUntil(StringBuilder sb, StopCharTester testers) {
        if (this.use8bit) {
            this.bytes.parse8bit((Appendable)sb, testers);
        } else {
            this.bytes.parseUtf8((Appendable)sb, testers);
        }
    }

    @Override
    public void parseUntil(StringBuilder sb, StopCharsTester testers) {
        sb.setLength(0);
        if (this.use8bit) {
            AppendableUtil.read8bitAndAppend((StreamingDataInput)this.bytes, (StringBuilder)sb, (StopCharsTester)testers);
        } else {
            try {
                AppendableUtil.readUTFAndAppend((StreamingDataInput)this.bytes, (Appendable)sb, (StopCharsTester)testers);
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public void append(CharSequence cs) {
        if (this.use8bit) {
            this.bytes.append8bit(cs);
        } else {
            this.bytes.appendUtf8(cs);
        }
    }

    public void append(CharSequence cs, int offset) {
        if (this.use8bit) {
            this.bytes.append8bit(cs, offset, cs.length());
        } else {
            this.bytes.appendUtf8(cs, offset, cs.length() - offset);
        }
    }

    class JSONValueIn
    extends TextWire.TextValueIn {
        JSONValueIn() {
            super(JSONWire.this);
        }

        @Override
        public String text() {
            return StringUtils.toString((Object)this.textTo(WireInternal.acquireStringBuilder()));
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder sb) {
            return this.textTo0((Appendable & CharSequence)sb);
        }

        @Override
        @Nullable
        public Bytes textTo(@NotNull Bytes bytes) {
            return this.textTo0(bytes);
        }

        @Nullable
        <ACS extends Appendable & CharSequence> ACS textTo0(@NotNull ACS a) {
            JSONWire.this.consumeWhiteSpace();
            int ch = JSONWire.this.peekCode();
            if (ch == 123) {
                long len = this.readLength();
                try {
                    a.append(Bytes.toString((Bytes)JSONWire.this.bytes, (long)JSONWire.this.bytes.readPosition(), (long)len));
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                JSONWire.this.bytes.readSkip(len);
                JSONWire.this.bytes.skipTo((StopCharTester)StopCharTesters.COMMA_STOP);
                return a;
            }
            if (ch == 34) {
                JSONWire.this.bytes.readSkip(1L);
                if (JSONWire.this.use8bit) {
                    JSONWire.this.bytes.parse8bit(a, JSONWire.this.getEscapingQuotes());
                } else {
                    JSONWire.this.bytes.parseUtf8(a, JSONWire.this.getEscapingQuotes());
                }
                JSONWire.unescape(a);
                int code = JSONWire.this.peekCode();
                if (code == 34) {
                    JSONWire.this.readCode();
                }
            } else if (ch == 33) {
                JSONWire.this.bytes.readSkip(1L);
                ch = JSONWire.this.peekCode();
                if (ch == 33) {
                    JSONWire.this.bytes.readSkip(1L);
                    StringBuilder sb = WireInternal.acquireStringBuilder();
                    JSONWire.this.parseWord(sb);
                    if (StringUtils.isEqual((CharSequence)sb, (CharSequence)"null")) {
                        this.textTo(sb);
                        return null;
                    }
                    if (StringUtils.isEqual((CharSequence)sb, (CharSequence)"snappy")) {
                        this.textTo(sb);
                        try {
                            byte[] decodedBytes = Base64.getDecoder().decode(sb.toString().getBytes());
                            String csq = Snappy.uncompressString((byte[])decodedBytes);
                            return (ACS)WireInternal.acquireStringBuilder().append(csq);
                        }
                        catch (IOException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                } else {
                    StringBuilder sb = WireInternal.acquireStringBuilder();
                    this.textTo(sb);
                }
            } else {
                if (JSONWire.this.bytes.readRemaining() > 0L) {
                    if (a instanceof Bytes || JSONWire.this.use8bit) {
                        JSONWire.this.bytes.parse8bit(a, JSONWire.this.getEscapingEndOfText());
                    } else {
                        JSONWire.this.bytes.parseUtf8(a, JSONWire.this.getEscapingEndOfText());
                    }
                } else {
                    AppendableUtil.setLength(a, (int)0);
                }
                while (((CharSequence)a).length() > 0 && Character.isWhitespace(((CharSequence)a).charAt(((CharSequence)a).length() - 1))) {
                    AppendableUtil.setLength(a, (int)(((CharSequence)a).length() - 1));
                }
            }
            int prev = this.rewindAndRead();
            if (prev == 58) {
                JSONWire.this.bytes.readSkip(-1L);
            }
            return a;
        }

        private int rewindAndRead() {
            return JSONWire.this.bytes.readPosition() > 0L ? JSONWire.this.bytes.readUnsignedByte(JSONWire.this.bytes.readPosition() - 1L) : -1;
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull Bytes toBytes) {
            return this.bytes((WireIn wi) -> toBytes.write(wi.bytes()));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadMarshallable bytesConsumer) {
            JSONWire.this.consumeWhiteSpace();
            StringBuilder sb = WireInternal.acquireStringBuilder();
            if (JSONWire.this.peekCode() == 33) {
                JSONWire.this.parseWord(sb);
                String str = WireInternal.INTERNER.intern((CharSequence)sb);
                if (str.equals("!!binary")) {
                    AppendableUtil.setLength((Appendable)sb, (int)0);
                    JSONWire.this.parseWord(sb);
                    byte[] decode = Base64.getDecoder().decode(sb.toString());
                    bytesConsumer.readMarshallable(new JSONWire(Bytes.wrapForRead((byte[])decode)));
                    return JSONWire.this;
                } else {
                    if (!str.equals("!!null")) throw new IORuntimeException("Unsupported type=" + str);
                    bytesConsumer.readMarshallable(null);
                    JSONWire.this.parseWord(sb);
                }
                return JSONWire.this;
            } else {
                this.textTo(sb);
                bytesConsumer.readMarshallable(new JSONWire(Bytes.wrapForRead((byte[])sb.toString().getBytes())));
            }
            return JSONWire.this;
        }

        @Override
        @Nullable
        public byte[] bytes() {
            JSONWire.this.consumeWhiteSpace();
            StringBuilder sb = WireInternal.acquireStringBuilder();
            if (JSONWire.this.peekCode() == 33) {
                JSONWire.this.parseWord(sb);
                String str = WireInternal.INTERNER.intern((CharSequence)sb);
                if (str.equals("!!binary")) {
                    AppendableUtil.setLength((Appendable)sb, (int)0);
                    JSONWire.this.parseWord(sb);
                    byte[] decode = Base64.getDecoder().decode(WireInternal.INTERNER.intern((CharSequence)sb));
                    return decode;
                }
                if (str.equals("!!null")) {
                    JSONWire.this.parseWord(sb);
                    return null;
                }
                if (str.equals("!!seqmap")) {
                    sb.append(JSONWire.this.bytes.toString());
                    return WireInternal.INTERNER.intern((CharSequence)sb).getBytes();
                }
                throw new IllegalStateException("unsupported type=" + str);
            }
            this.textTo(sb);
            return sb.toString().getBytes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long readLength() {
            JSONWire.this.consumeWhiteSpace();
            long start = JSONWire.this.bytes.readPosition();
            try {
                JSONWire.this.consumeWhiteSpace();
                int code = JSONWire.this.readCode();
                switch (code) {
                    case 123: {
                        int count = 1;
                        while (true) {
                            byte b;
                            if ((b = JSONWire.this.bytes.readByte()) == 123) {
                                ++count;
                                continue;
                            }
                            if (b == 125) {
                                if (--count != 0) continue;
                                long l = JSONWire.this.bytes.readPosition() - start;
                                return l;
                            }
                            if (b > 0) continue;
                            long l = JSONWire.this.bytes.readPosition() - start - 1L;
                            return l;
                        }
                    }
                    case 45: {
                        while (true) {
                            byte b;
                            if ((b = JSONWire.this.bytes.readByte()) >= 32) continue;
                            long l = JSONWire.this.bytes.readLimit() - start - 1L;
                            return l;
                        }
                    }
                }
                this.bytes();
                long l = JSONWire.this.bytes.readPosition() - start;
                return l;
            }
            finally {
                JSONWire.this.bytes.readPosition(start);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long readLengthMarshallable() {
            long start = JSONWire.this.bytes.readPosition();
            try {
                JSONWire.this.consumeWhiteSpace();
                int code = JSONWire.this.readCode();
                switch (code) {
                    case 123: {
                        int count = 1;
                        while (true) {
                            byte b;
                            if ((b = JSONWire.this.bytes.readByte()) == 123) {
                                ++count;
                                continue;
                            }
                            if (b == 125) {
                                if (--count != 0) continue;
                                long l = JSONWire.this.bytes.readPosition() - start;
                                return l;
                            }
                            if (b != 0) continue;
                            long l = JSONWire.this.bytes.readPosition() - start - 1L;
                            return l;
                        }
                    }
                }
                this.bytes();
                long l = JSONWire.this.bytes.readPosition() - start;
                return l;
            }
            finally {
                JSONWire.this.bytes.readPosition(start);
            }
        }

        @Override
        public boolean hasNextSequenceItem() {
            JSONWire.this.consumeWhiteSpace();
            int ch = JSONWire.this.peekCode();
            if (ch == 44) {
                JSONWire.this.bytes.readSkip(1L);
                return true;
            }
            return ch > 0 && ch != 93;
        }

        @Override
        @NotNull
        public WireIn int64(@Nullable LongValue value) {
            JSONWire.this.consumeWhiteSpace();
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)JSONWire.this.bytes, JSONWire.this.bytes.readPosition(), length);
            JSONWire.this.bytes.readSkip(length);
            JSONWire.this.consumeWhiteSpace();
            if (JSONWire.this.peekCode() == 44) {
                JSONWire.this.bytes.readSkip(1L);
            }
            return JSONWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(@NotNull Function<WireIn, T> marshallableReader) {
            JSONWire.this.consumeWhiteSpace();
            int code = JSONWire.this.peekCode();
            if (code != 123) {
                throw new IORuntimeException("Unsupported type " + (char)code);
            }
            long len = this.readLengthMarshallable();
            long limit = JSONWire.this.bytes.readLimit();
            long position = JSONWire.this.bytes.readPosition();
            try {
                long newLimit = position - 1L + len;
                JSONWire.this.bytes.readLimit(newLimit);
                JSONWire.this.bytes.readSkip(1L);
                JSONWire.this.consumeWhiteSpace();
                T t = marshallableReader.apply(JSONWire.this);
                return t;
            }
            finally {
                JSONWire.this.bytes.readLimit(limit);
                JSONWire.this.consumeWhiteSpace();
                code = JSONWire.this.readCode();
                if (code != 125) {
                    throw new IORuntimeException("Unterminated { while reading marshallable bytes=" + Bytes.toString((Bytes)JSONWire.this.bytes));
                }
            }
        }

        @Override
        @NotNull
        String stringForCode(int code) {
            return code < 0 ? "Unexpected end of input" : "'" + (char)code + "'";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn marshallable(@NotNull ReadMarshallable object) {
            JSONWire.this.consumeWhiteSpace();
            int code = JSONWire.this.peekCode();
            if (code == 33) {
                this.typePrefix();
            } else if (code != 123) {
                throw new IORuntimeException("Unsupported type " + this.stringForCode(code));
            }
            long len = this.readLengthMarshallable();
            long limit = JSONWire.this.bytes.readLimit();
            long position = JSONWire.this.bytes.readPosition();
            long newLimit = position - 1L + len;
            try {
                JSONWire.this.bytes.readLimit(newLimit);
                JSONWire.this.bytes.readSkip(1L);
                JSONWire.this.consumeWhiteSpace();
                object.readMarshallable(JSONWire.this);
            }
            finally {
                JSONWire.this.bytes.readLimit(limit);
                JSONWire.this.bytes.readPosition(newLimit);
            }
            JSONWire.this.consumeWhiteSpace();
            code = JSONWire.this.readCode();
            if (code != 125) {
                throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (char)code + "', bytes=" + Bytes.toString((Bytes)JSONWire.this.bytes, (long)1024L));
            }
            return JSONWire.this;
        }

        @Override
        @Nullable
        public <T extends ReadMarshallable> T typedMarshallable() {
            try {
                JSONWire.this.consumeWhiteSpace();
                int code = JSONWire.this.peekCode();
                if (code < 0) {
                    throw new IllegalStateException("Cannot read nothing as a Marshallable " + JSONWire.this.bytes.toDebugString());
                }
                StringBuilder sb = WireInternal.acquireStringBuilder();
                if (code != 33) {
                    throw new ClassCastException("Cannot convert to Marshallable. " + JSONWire.this.bytes.toDebugString());
                }
                JSONWire.this.readCode();
                JSONWire.this.parseUntil(sb, TextStopCharTesters.END_OF_TYPE);
                if (StringUtils.isEqual((CharSequence)sb, (CharSequence)"!null")) {
                    this.text();
                    return null;
                }
                if (StringUtils.isEqual((CharSequence)sb, (CharSequence)"!binary")) {
                    this.bytesStore();
                    return null;
                }
                Class clazz = ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb);
                if (!ReadMarshallable.class.isAssignableFrom(clazz)) {
                    throw new ClassCastException("Cannot convert " + sb + " to Marshallable.");
                }
                ReadMarshallable m = (ReadMarshallable)ObjectUtils.newInstance((Class)clazz);
                this.marshallable(m);
                return (T)((ReadMarshallable)ReadResolvable.readResolve((Object)m));
            }
            catch (Exception e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        @Override
        @Nullable
        public <K, V> Map<K, V> map(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap) {
            JSONWire.this.consumeWhiteSpace();
            usingMap.clear();
            StringBuilder sb = WireInternal.acquireStringBuilder();
            if (JSONWire.this.peekCode() == 33) {
                JSONWire.this.parseUntil(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = WireInternal.INTERNER.intern((CharSequence)sb);
                if ("!!null".contentEquals(sb)) {
                    this.text();
                    return null;
                }
                if ("!!seqmap".contentEquals(sb)) {
                    JSONWire.this.consumeWhiteSpace();
                    int start = JSONWire.this.readCode();
                    if (start != 91) {
                        throw new IORuntimeException("Unsupported start of sequence : " + (char)start);
                    }
                    do {
                        this.marshallable(r -> {
                            Object k = r.read(() -> "key").object(kClazz);
                            Object v = r.read(() -> "value").object(vClass);
                            usingMap.put(k, v);
                        });
                    } while (this.hasNextSequenceItem());
                    return usingMap;
                }
                throw new IORuntimeException("Unsupported type :" + str);
            }
            return usingMap;
        }

        @Override
        public boolean bool() {
            JSONWire.this.consumeWhiteSpace();
            StringBuilder sb = WireInternal.acquireStringBuilder();
            if (this.textTo(sb) == null) {
                throw new NullPointerException("value is null");
            }
            return StringUtils.isEqual((CharSequence)sb, (CharSequence)"true");
        }

        @Override
        public byte int8() {
            long l = this.int64();
            if (l > 127L || l < -128L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Byte.MAX_VALUE/MIN_VALUE");
            }
            return (byte)l;
        }

        @Override
        public short int16() {
            long l = this.int64();
            if (l > 32767L || l < -32768L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Short.MAX_VALUE/MIN_VALUE");
            }
            return (short)l;
        }

        @Override
        public int int32() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/MIN_VALUE");
            }
            return (int)l;
        }

        @Override
        public int uint16() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < 0L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer" + ".MAX_VALUE/ZERO");
            }
            return (int)l;
        }

        @Override
        public long int64() {
            JSONWire.this.consumeWhiteSpace();
            return JSONWire.this.bytes.parseLong();
        }

        @Override
        public double float64() {
            JSONWire.this.consumeWhiteSpace();
            return JSONWire.this.bytes.parseDouble();
        }

        @Override
        public float float32() {
            double d = this.float64();
            if ((double)((float)d) != d) {
                throw new IllegalStateException("value=" + d + " can not be represented as a float");
            }
            return (float)d;
        }

        @Override
        public boolean isNull() {
            JSONWire.this.consumeWhiteSpace();
            if (JSONWire.this.peekStringIgnoreCase("!!null \"\"")) {
                JSONWire.this.bytes.readSkip((long)"!!null \"\"".length());
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public <E> E object(@Nullable E using, @NotNull Class<E> clazz) {
            return (E)ObjectUtils.convertTo(clazz, (Object)this.object0(using, clazz));
        }
    }

    class JSONValueOut
    extends TextWire.TextValueOut {
        @NotNull
        BytesStore sep;
        boolean leaf;

        JSONValueOut() {
            super(JSONWire.this);
            this.sep = Bytes.empty();
            this.leaf = false;
        }

        @Override
        void prependSeparator() {
            JSONWire.this.append((CharSequence)this.sep);
            if (this.sep.endsWith('\n')) {
                this.indent();
            }
            this.sep = Bytes.empty();
        }

        @Override
        @NotNull
        public ValueOut leaf() {
            this.leaf = true;
            return this;
        }

        @Override
        @NotNull
        public WireOut wireOut() {
            return JSONWire.this;
        }

        private void indent() {
        }

        @Override
        public void elementSeparator() {
            this.sep = COMMA;
        }

        @Override
        @NotNull
        public WireOut bool(@Nullable Boolean flag) {
            this.prependSeparator();
            JSONWire.this.append(flag == null ? "!" + "!null \"\"" : (flag != false ? "true" : "false"));
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable CharSequence s) {
            this.prependSeparator();
            if (s == null) {
                JSONWire.this.append("!!null \"\"");
            } else {
                JSONWire.this.bytes.appendUtf8(34);
                JSONWire.this.escaped(s);
                JSONWire.this.bytes.appendUtf8(34);
            }
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            this.prependSeparator();
            JSONWire.this.bytes.appendUtf8((int)i8);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(@Nullable BytesStore fromBytes) {
            if (this.isText(fromBytes)) {
                return this.text(fromBytes);
            }
            int length = Maths.toInt32((long)fromBytes.readRemaining());
            byte[] byteArray = new byte[length];
            fromBytes.copyTo(byteArray);
            return this.bytes(byteArray);
        }

        @Override
        @NotNull
        public WireOut rawBytes(@NotNull byte[] value) {
            this.prependSeparator();
            JSONWire.this.bytes.write(value);
            this.elementSeparator();
            return JSONWire.this;
        }

        private boolean isText(@Nullable BytesStore fromBytes) {
            if (fromBytes == null) {
                return true;
            }
            for (long i = fromBytes.readPosition(); i < fromBytes.readLimit(); ++i) {
                int ch = fromBytes.readUnsignedByte(i);
                if ((ch >= 32 || ch == 9) && ch < 127) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public ValueOut writeLength(long remaining) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut bytes(byte[] byteArray) {
            this.prependSeparator();
            JSONWire.this.append("!!binary ");
            JSONWire.this.append(Base64.getEncoder().encodeToString(byteArray));
            JSONWire.this.append((CharSequence)TextWire.END_FIELD);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            this.prependSeparator();
            JSONWire.this.bytes.appendUtf8(u8);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            this.prependSeparator();
            JSONWire.this.bytes.appendUtf8((int)i16);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            this.prependSeparator();
            JSONWire.this.bytes.appendUtf8(u16);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut utf8(int codepoint) {
            this.prependSeparator();
            StringBuilder sb = WireInternal.acquireStringBuilder();
            sb.appendCodePoint(codepoint);
            this.text(sb);
            this.sep = Bytes.empty();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            this.prependSeparator();
            JSONWire.this.bytes.appendUtf8(i32);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            this.prependSeparator();
            JSONWire.this.bytes.append(u32);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            this.prependSeparator();
            JSONWire.this.bytes.append(i64);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity) {
            TextLongArrayReference.write(JSONWire.this.bytes, capacity);
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity, @NotNull LongArrayValues values) {
            long pos = JSONWire.this.bytes.writePosition();
            TextLongArrayReference.write(JSONWire.this.bytes, capacity);
            ((Byteable)values).bytesStore((BytesStore)JSONWire.this.bytes, pos, JSONWire.this.bytes.writePosition() - pos);
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            this.prependSeparator();
            JSONWire.this.bytes.append(f);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            this.prependSeparator();
            JSONWire.this.bytes.append(d);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut time(@NotNull LocalTime localTime) {
            this.prependSeparator();
            JSONWire.this.append(localTime.toString());
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut zonedDateTime(@NotNull ZonedDateTime zonedDateTime) {
            this.prependSeparator();
            JSONWire.this.append(zonedDateTime.toString());
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut date(@NotNull LocalDate localDate) {
            this.prependSeparator();
            JSONWire.this.append(localDate.toString());
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public ValueOut typePrefix(@NotNull CharSequence typeName) {
            this.prependSeparator();
            JSONWire.this.bytes.appendUtf8(33);
            JSONWire.this.append(typeName);
            this.sep = TextWire.SPACE;
            return this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes> typeTranslator, Class type) {
            this.prependSeparator();
            JSONWire.this.append((CharSequence)TextWire.TYPE);
            typeTranslator.accept(type, JSONWire.this.bytes);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull CharSequence type) {
            this.prependSeparator();
            JSONWire.this.append((CharSequence)TextWire.TYPE);
            this.text(type);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut uuid(@NotNull UUID uuid) {
            this.prependSeparator();
            JSONWire.this.append((CharSequence)this.sep);
            JSONWire.this.append(uuid.toString());
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value) {
            this.prependSeparator();
            TextIntReference.write(JSONWire.this.bytes, value);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value, IntValue intValue) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value) {
            this.prependSeparator();
            TextLongReference.write(JSONWire.this.bytes, value);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value, LongValue longValue) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut sequence(@NotNull WriteValue writer) {
            this.pushState();
            JSONWire.this.bytes.appendUtf8(91);
            this.sep = TextWire.NEW_LINE;
            long pos = JSONWire.this.bytes.readPosition();
            writer.writeValue(this);
            if (JSONWire.this.bytes.writePosition() > pos + 1L) {
                JSONWire.this.bytes.appendUtf8(10);
            }
            this.popState();
            this.indent();
            JSONWire.this.bytes.appendUtf8(93);
            this.sep = TextWire.END_FIELD;
            return JSONWire.this;
        }

        @Override
        public WireOut array(@NotNull WriteValue writer, Class arrayType) {
            if (arrayType == String[].class) {
                JSONWire.this.append("!String[] ");
            } else {
                JSONWire.this.bytes.appendUtf8(33);
                JSONWire.this.append(arrayType.getName());
                JSONWire.this.bytes.appendUtf8(32);
            }
            return this.sequence(writer);
        }

        private void popState() {
            this.leaf = false;
        }

        private void pushState() {
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull WriteMarshallable object) {
            if (!this.leaf) {
                this.pushState();
            }
            this.prependSeparator();
            JSONWire.this.bytes.appendUtf8(123);
            this.sep = this.leaf ? TextWire.SPACE : TextWire.END_FIELD;
            object.writeMarshallable(JSONWire.this);
            if (!this.leaf) {
                this.popState();
            } else {
                this.leaf = false;
            }
            if (this.sep.startsWith(',')) {
                JSONWire.this.append((CharSequence)this.sep, 1);
            } else {
                this.prependSeparator();
            }
            JSONWire.this.bytes.appendUtf8(125);
            this.sep = COMMA;
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut map(@NotNull Map map) {
            this.typePrefix("!seqmap");
            JSONWire.this.bytes.appendUtf8(32);
            JSONWire.this.bytes.appendUtf8(91);
            this.pushState();
            this.sep = TextWire.END_FIELD;
            map.forEach((k, v) -> {
                this.prependSeparator();
                JSONWire.this.append("{ key: ");
                this.leaf();
                this.object2(k);
                this.sep = COMMA;
                this.prependSeparator();
                JSONWire.this.append("  value: ");
                this.leaf();
                this.object2(v);
                JSONWire.this.bytes.appendUtf8(32);
                JSONWire.this.bytes.appendUtf8(125);
                this.sep = COMMA;
            });
            this.popState();
            this.sep = TextWire.END_FIELD;
            this.prependSeparator();
            JSONWire.this.bytes.appendUtf8(93);
            this.sep = TextWire.END_FIELD;
            return JSONWire.this;
        }

        private void object2(Object v) {
            if (v instanceof CharSequence) {
                this.text((CharSequence)v);
            } else if (v instanceof WriteMarshallable) {
                this.typedMarshallable((WriteMarshallable)v);
            } else if (v == null) {
                JSONWire.this.append("!!null \"\"");
            } else {
                this.text(String.valueOf(v));
            }
        }

        @Override
        @NotNull
        public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> map) {
            this.typePrefix("!seqmap");
            map.forEach((k, v) -> this.sequence(w -> w.marshallable(m -> m.write(() -> "key").typedMarshallable((WriteMarshallable)k).write(() -> "value").typedMarshallable((WriteMarshallable)v))));
            return JSONWire.this;
        }

        @Override
        @NotNull
        public ValueOut write() {
            JSONWire.this.append((CharSequence)this.sep);
            JSONWire.this.bytes.appendUtf8(34);
            JSONWire.this.bytes.appendUtf8(34);
            JSONWire.this.bytes.appendUtf8(58);
            this.sep = Bytes.empty();
            return this;
        }

        @Override
        @NotNull
        public ValueOut write(@NotNull WireKey key) {
            CharSequence name = key.name();
            if (name == null) {
                name = Integer.toString(key.code());
            }
            this.prependSeparator();
            JSONWire.this.bytes.appendUtf8(34);
            JSONWire.this.escaped(name);
            JSONWire.this.bytes.appendUtf8(34);
            JSONWire.this.bytes.appendUtf8(58);
            return this;
        }

        @Override
        public void writeComment(@NotNull CharSequence s) {
        }
    }
}

