/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;

public class WireMarshaller<T> {
    static final ClassLocal<WireMarshaller> WIRE_MARSHALLER_CL = ClassLocal.withInitial(WireMarshaller::new);
    private final FieldAccess[] fields;
    private final boolean isLeaf;

    public WireMarshaller(Class<T> tClass) {
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        WireMarshaller.getAllField(tClass, map);
        this.fields = (FieldAccess[])map.values().stream().map(FieldAccess::create).toArray(FieldAccess[]::new);
        this.isLeaf = map.values().stream().map(Field::getType).noneMatch(c -> WireMarshaller.class.isAssignableFrom((Class<?>)c) || WireMarshaller.isCollection(c));
    }

    private static boolean isCollection(Class<?> c) {
        return c.isArray() || Collection.class.isAssignableFrom(c) || Map.class.isAssignableFrom(c);
    }

    public static void getAllField(Class clazz, Map<String, Field> map) {
        if (clazz != Object.class) {
            WireMarshaller.getAllField(clazz.getSuperclass(), map);
        }
        for (Field field : clazz.getDeclaredFields()) {
            if ((field.getModifiers() & 0x88) != 0) continue;
            field.setAccessible(true);
            map.put(field.getName(), field);
        }
    }

    public void writeMarshallable(T t, WireOut out) {
        for (FieldAccess field : this.fields) {
            field.write(t, out);
        }
    }

    public void readMarshallable(T t, WireIn in) {
        for (FieldAccess field : this.fields) {
            field.read(t, in);
        }
    }

    static class DoubleFieldAccess
    extends FieldAccess {
        public DoubleFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, ValueOut write) throws IllegalAccessException {
            write.float64(this.field.getDouble(o));
        }

        @Override
        protected void setValue(Object o, ValueIn read) throws IllegalAccessException {
            this.field.setDouble(o, read.float64());
        }
    }

    static class LongFieldAccess
    extends FieldAccess {
        public LongFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, ValueOut write) throws IllegalAccessException {
            write.int64(this.field.getLong(o));
        }

        @Override
        protected void setValue(Object o, ValueIn read) throws IllegalAccessException {
            this.field.setLong(o, read.int64());
        }
    }

    static class FloatFieldAccess
    extends FieldAccess {
        public FloatFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, ValueOut write) throws IllegalAccessException {
            write.float32(this.field.getFloat(o));
        }

        @Override
        protected void setValue(Object o, ValueIn read) throws IllegalAccessException {
            this.field.setFloat(o, read.float32());
        }
    }

    static class IntegerFieldAccess
    extends FieldAccess {
        public IntegerFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, ValueOut write) throws IllegalAccessException {
            write.int32(this.field.getInt(o));
        }

        @Override
        protected void setValue(Object o, ValueIn read) throws IllegalAccessException {
            this.field.setInt(o, read.int32());
        }
    }

    static class ShortFieldAccess
    extends FieldAccess {
        public ShortFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, ValueOut write) throws IllegalAccessException {
            write.int16(this.field.getShort(o));
        }

        @Override
        protected void setValue(Object o, ValueIn read) throws IllegalAccessException {
            this.field.setShort(o, read.int16());
        }
    }

    static class ByteFieldAccess
    extends FieldAccess {
        public ByteFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, ValueOut write) throws IllegalAccessException {
            write.int8(this.field.getByte(o));
        }

        @Override
        protected void setValue(Object o, ValueIn read) throws IllegalAccessException {
            this.field.setByte(o, read.int8());
        }
    }

    static class BooleanFieldAccess
    extends FieldAccess {
        public BooleanFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, ValueOut write) throws IllegalAccessException {
            write.bool(this.field.getBoolean(o));
        }

        @Override
        protected void setValue(Object o, ValueIn read) throws IllegalAccessException {
            this.field.setBoolean(o, read.bool());
        }
    }

    static class MapFieldAccess
    extends FieldAccess {
        final Supplier<Map> collectionSupplier;
        private final Class<?> type;
        private final Class keyType;
        private final Class valueType;

        public MapFieldAccess(Field field) {
            super(field);
            this.type = field.getType();
            this.collectionSupplier = this.type == Map.class ? LinkedHashMap::new : (this.type == SortedMap.class || this.type == NavigableMap.class ? TreeMap::new : this.newInstance());
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)genericType;
                Type[] actualTypeArguments = pType.getActualTypeArguments();
                this.keyType = MapFieldAccess.extractClass(actualTypeArguments[0]);
                this.valueType = MapFieldAccess.extractClass(actualTypeArguments[1]);
            } else {
                this.keyType = Object.class;
                this.valueType = Object.class;
            }
        }

        private Supplier<Map> newInstance() {
            try {
                return (Supplier)this.type.newInstance();
            }
            catch (InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void getValue(Object o, ValueOut write) throws IllegalAccessException {
            Map map = (Map)this.field.get(o);
            write.map(map);
        }

        @Override
        void read(Object o, WireIn in) {
            try {
                ValueIn read = in.read(this.key);
                Map map = (Map)this.field.get(o);
                if (map == null) {
                    map = this.collectionSupplier.get();
                    this.field.set(o, map);
                } else {
                    map.clear();
                }
                read.map(this.keyType, this.valueType, map);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, ValueIn read) throws IllegalAccessException {
            throw new UnsupportedOperationException();
        }
    }

    static class CollectionFieldAccess
    extends FieldAccess {
        final Supplier<Collection> collectionSupplier;
        private final Class componentType;
        private final Class<?> type;

        public CollectionFieldAccess(Field field) {
            super(field);
            this.type = field.getType();
            this.collectionSupplier = this.type == List.class || this.type == Collection.class ? ArrayList::new : (this.type == SortedSet.class || this.type == NavigableSet.class ? TreeSet::new : (this.type == Set.class ? LinkedHashSet::new : this.newInstance()));
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)genericType;
                Type type0 = pType.getActualTypeArguments()[0];
                this.componentType = CollectionFieldAccess.extractClass(type0);
                this.isLeaf = ((WireMarshaller)WIRE_MARSHALLER_CL.get(this.componentType)).isLeaf;
            } else {
                this.componentType = Object.class;
            }
        }

        private Supplier<Collection> newInstance() {
            try {
                return (Supplier)this.type.newInstance();
            }
            catch (InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void getValue(Object o, ValueOut write) throws IllegalAccessException {
            Collection c = (Collection)this.field.get(o);
            write.sequence(c, (coll, out) -> {
                if (coll instanceof RandomAccess) {
                    List list = (List)coll;
                    int len = list.size();
                    for (int i = 0; i < len; ++i) {
                        if (Boolean.TRUE.equals(this.isLeaf)) {
                            out.leaf();
                        }
                        out.object(this.componentType, list.get(i));
                    }
                } else {
                    for (Object element : coll) {
                        if (Boolean.TRUE.equals(this.isLeaf)) {
                            out.leaf();
                        }
                        out.object(this.componentType, element);
                    }
                }
            });
        }

        @Override
        void read(Object o, WireIn in) {
            try {
                ValueIn read = in.read(this.key);
                Collection coll = (Collection)this.field.get(o);
                if (coll == null) {
                    coll = this.collectionSupplier.get();
                    this.field.set(o, coll);
                } else {
                    coll.clear();
                }
                read.sequence(coll, (c, in2) -> {
                    while (in2.hasNextSequenceItem()) {
                        c.add(in2.object(this.componentType));
                    }
                });
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, ValueIn read) throws IllegalAccessException {
            throw new UnsupportedOperationException();
        }
    }

    static class ArrayFieldAccess
    extends FieldAccess {
        private final Class componentType;

        public ArrayFieldAccess(Field field) {
            super(field);
            this.componentType = field.getType().getComponentType();
        }

        @Override
        protected void getValue(Object o, ValueOut write) throws IllegalAccessException {
            write.sequence(o, (array, out) -> {
                int len = Array.getLength(array);
                for (int i = 0; i < len; ++i) {
                    out.object(this.componentType, Array.get(array, i));
                }
            });
        }

        @Override
        protected void setValue(Object o, ValueIn read) throws IllegalAccessException {
            read.sequence(o, (array, out) -> {
                int len = Array.getLength(array);
                for (int i = 0; i < len; ++i) {
                    Array.set(array, i, out.object(this.componentType));
                }
            });
        }
    }

    static class ObjectFieldAccess
    extends FieldAccess {
        private final Class type;

        public ObjectFieldAccess(Field field, Boolean isLeaf) {
            super(field, isLeaf);
            this.type = field.getType();
        }

        @Override
        protected void getValue(Object o, ValueOut write) throws IllegalAccessException {
            if (this.isLeaf != null) {
                write.leaf(this.isLeaf);
            }
            write.object(this.type, this.field.get(o));
        }

        @Override
        protected void setValue(Object o, ValueIn read) throws IllegalAccessException {
            this.field.set(o, read.object(this.field.getType()));
        }
    }

    static abstract class FieldAccess {
        final Field field;
        final WireKey key;
        Boolean isLeaf;

        FieldAccess(Field field) {
            this(field, null);
        }

        FieldAccess(Field field, Boolean isLeaf) {
            this.field = field;
            this.key = field::getName;
            this.isLeaf = isLeaf;
        }

        public static Object create(Field field) {
            Class<?> type = field.getType();
            if (type.isArray()) {
                return new ArrayFieldAccess(field);
            }
            if (Collection.class.isAssignableFrom(type)) {
                return new CollectionFieldAccess(field);
            }
            if (Map.class.isAssignableFrom(type)) {
                return new MapFieldAccess(field);
            }
            switch (type.getName()) {
                case "boolean": {
                    return new BooleanFieldAccess(field);
                }
                case "byte": {
                    return new ByteFieldAccess(field);
                }
                case "short": {
                    return new ShortFieldAccess(field);
                }
                case "int": {
                    return new IntegerFieldAccess(field);
                }
                case "float": {
                    return new FloatFieldAccess(field);
                }
                case "long": {
                    return new LongFieldAccess(field);
                }
                case "double": {
                    return new DoubleFieldAccess(field);
                }
            }
            Boolean isLeaf = null;
            if (WireMarshaller.class.isAssignableFrom(type)) {
                isLeaf = ((WireMarshaller)WIRE_MARSHALLER_CL.get(type)).isLeaf;
            } else if (WireMarshaller.isCollection(type)) {
                isLeaf = false;
            }
            return new ObjectFieldAccess(field, isLeaf);
        }

        static Class extractClass(Type type0) {
            if (type0 instanceof Class) {
                return (Class)type0;
            }
            if (type0 instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type0).getRawType();
            }
            return Object.class;
        }

        public String toString() {
            return "FieldAccess{field=" + this.field + ", isLeaf=" + this.isLeaf + '}';
        }

        void write(Object o, WireOut out) {
            try {
                ValueOut write = out.write(this.field.getName());
                this.getValue(o, write);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        protected abstract void getValue(Object var1, ValueOut var2) throws IllegalAccessException;

        void read(Object o, WireIn in) {
            try {
                ValueIn read = in.read(this.key);
                this.setValue(o, read);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        protected abstract void setValue(Object var1, ValueIn var2) throws IllegalAccessException;
    }
}

