package net.openhft.chronicle.wire;

import java.util.Objects;

/**
 * Created by skidder on 5/6/16.
 */

@FunctionalInterface
interface TriConsumer<T, U, V> {
    void accept(T t, U u, V v);

    default TriConsumer<T, U, V> andThen(TriConsumer<? super T, ? super U, ? super V> after) {
        Objects.requireNonNull(after);

        return (t, u, v) -> {
            accept(t, u, v);
            after.accept(t, u, v);
        };
    }
}
