/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.MethodWriterInvocationHandler;
import org.jetbrains.annotations.NotNull;

public class MethodWriterBuilder<T>
implements Supplier<T> {
    private final List<Class> interfaces = new ArrayList<Class>();
    @NotNull
    private final MethodWriterInvocationHandler handler;
    private ClassLoader classLoader;

    public MethodWriterBuilder(@NotNull Class<T> tClass, @NotNull MethodWriterInvocationHandler handler) {
        this.interfaces.add(Closeable.class);
        this.interfaces.add(tClass);
        this.classLoader = tClass.getClassLoader();
        this.handler = handler;
    }

    @NotNull
    public MethodWriterBuilder<T> classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> addInterface(Class additionalClass) {
        this.interfaces.add(additionalClass);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> recordHistory(boolean recordHistory) {
        this.handler.recordHistory(recordHistory);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> onClose(Closeable closeable) {
        this.handler.onClose(closeable);
        return this;
    }

    @NotNull
    public T build() {
        return this.get();
    }

    @Override
    @NotNull
    public T get() {
        Class[] interfacesArr = this.interfaces.toArray(new Class[this.interfaces.size()]);
        return (T)Proxy.newProxyInstance(this.classLoader, interfacesArr, (InvocationHandler)this.handler);
    }
}

