/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.MethodReader;
import net.openhft.chronicle.wire.MethodReaderInterceptor;
import net.openhft.chronicle.wire.WireParselet;
import org.jetbrains.annotations.NotNull;

public class MethodReaderBuilder {
    private final MarshallableIn in;
    private boolean ignoreDefaults;
    private WireParselet defaultParselet = MethodReaderBuilder.createDefaultParselet();
    private MethodReaderInterceptor methodReaderInterceptor;

    public MethodReaderBuilder(MarshallableIn in) {
        this.in = in;
    }

    @NotNull
    static WireParselet createDefaultParselet() {
        return (s, v, $) -> {
            MessageHistory history = MessageHistory.get();
            long sourceIndex = history.lastSourceIndex();
            v.skipValue();
            if (s.length() == 0) {
                MethodReader.LOGGER.warn(MethodReaderBuilder.errorMsg(s, history, sourceIndex));
            } else if (MethodReader.LOGGER.isDebugEnabled()) {
                MethodReader.LOGGER.debug(MethodReaderBuilder.errorMsg(s, history, sourceIndex));
            }
        };
    }

    @NotNull
    private static String errorMsg(CharSequence s, MessageHistory history, long sourceIndex) {
        return "Unknown method-name='" + s + "' from " + history.lastSourceId() + " at " + Long.toHexString(sourceIndex) + " ~ " + (int)sourceIndex;
    }

    public boolean ignoreDefaults() {
        return this.ignoreDefaults;
    }

    @NotNull
    public MethodReaderBuilder ignoreDefaults(boolean ignoreDefaults) {
        this.ignoreDefaults = ignoreDefaults;
        return this;
    }

    public WireParselet defaultParselet() {
        return this.defaultParselet;
    }

    public MethodReaderBuilder defaultParselet(WireParselet defaultParselet) {
        this.defaultParselet = defaultParselet;
        return this;
    }

    @NotNull
    public MethodReader build(Object ... impls) {
        return new MethodReader(this.in, this.ignoreDefaults, this.defaultParselet, this.methodReaderInterceptor, impls);
    }

    public MethodReaderBuilder methodReaderInterceptor(MethodReaderInterceptor methodReaderInterceptor) {
        this.methodReaderInterceptor = methodReaderInterceptor;
        return this;
    }
}

