/*
 * Decompiled with CFR 0.152.
 */
package net.plavcak.jenkins.plugins.scmskip;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.plavcak.jenkins.plugins.scmskip.SCMSkipMatcher;
import net.plavcak.jenkins.plugins.scmskip.SCMSkipTools;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class SCMSkipBuildStep
extends Builder
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(SCMSkipBuildStep.class.getName());
    private SCMSkipMatcher skipMatcher;
    private boolean deleteBuild;
    private String skipPattern;

    public SCMSkipBuildStep(boolean deleteBuild, String skipPattern) {
        this.deleteBuild = deleteBuild;
        this.skipPattern = skipPattern;
        if (this.skipPattern == null) {
            this.skipPattern = ".*\\[ci skip\\].*";
        }
        this.skipMatcher = new SCMSkipMatcher(this.getSkipPattern());
    }

    @DataBoundConstructor
    public SCMSkipBuildStep() {
        this(false, null);
    }

    public boolean isDeleteBuild() {
        return this.deleteBuild;
    }

    @DataBoundSetter
    public void setDeleteBuild(boolean deleteBuild) {
        this.deleteBuild = deleteBuild;
    }

    public String getSkipPattern() {
        if (this.skipPattern == null) {
            return this.getDescriptor().getSkipPattern();
        }
        return this.skipPattern;
    }

    @DataBoundSetter
    public void setSkipPattern(String skipPattern) {
        this.skipPattern = skipPattern;
        this.skipMatcher.setPattern(this.skipPattern);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException {
        if (SCMSkipTools.inspectChangeSet(run, this.skipMatcher, listener)) {
            SCMSkipTools.tagRunForDeletion(run, this.deleteBuild);
            try {
                SCMSkipTools.stopBuild(run);
                return;
            }
            catch (AbortException e) {
                throw e;
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) return;
                LOGGER.log(Level.FINE, "SCM Skip Build Step", e);
                return;
            }
        } else {
            SCMSkipTools.tagRunForDeletion(run, false);
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"scmSkip"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String skipPattern = ".*\\[ci skip\\].*";

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return false;
        }

        public String getDisplayName() {
            return "SCM Skip Step";
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            req.bindJSON((Object)this, json.getJSONObject("scmSkip"));
            this.save();
            return true;
        }

        public String getSkipPattern() {
            return this.skipPattern;
        }

        @DataBoundSetter
        public void setSkipPattern(String skipPattern) {
            this.skipPattern = skipPattern;
        }
    }
}

