/*
 * Decompiled with CFR 0.152.
 */
package net.plavcak.jenkins.plugins.scmskip;

import hudson.AbortException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import net.plavcak.jenkins.plugins.scmskip.SCMSkipMatcher;
import net.plavcak.jenkins.plugins.scmskip.SCMSkipTools;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class SCMSkipBuildWrapper
extends BuildWrapper {
    private static final Logger LOGGER = Logger.getLogger(SCMSkipBuildWrapper.class.getName());
    private SCMSkipMatcher skipMatcher;
    private boolean deleteBuild;
    private String skipPattern;

    @DataBoundConstructor
    public SCMSkipBuildWrapper(boolean deleteBuild, String skipPattern) {
        this.deleteBuild = deleteBuild;
        this.skipPattern = skipPattern;
        if (this.skipPattern == null) {
            this.skipPattern = ".*\\[ci skip\\].*";
        }
        this.skipMatcher = new SCMSkipMatcher(this.getSkipPattern());
    }

    public boolean isDeleteBuild() {
        return this.deleteBuild;
    }

    @DataBoundSetter
    public void setDeleteBuild(boolean deleteBuild) {
        this.deleteBuild = deleteBuild;
    }

    public String getSkipPattern() {
        if (this.skipPattern == null || this.skipPattern.isEmpty()) {
            return this.getDescriptor().getSkipPattern();
        }
        return this.skipPattern;
    }

    @DataBoundSetter
    public void setSkipPattern(String skipPattern) {
        this.skipPattern = skipPattern;
        this.skipMatcher.setPattern(this.skipPattern);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException {
        if (SCMSkipTools.inspectChangeSet((Run)build, this.skipMatcher, (TaskListener)listener)) {
            SCMSkipTools.tagRunForDeletion(build, this.deleteBuild);
            try {
                SCMSkipTools.stopBuild(build);
                return new BuildWrapper.Environment(){};
            }
            catch (AbortException e) {
                throw e;
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) return new /* invalid duplicate definition of identical inner class */;
                LOGGER.log(Level.FINE, "SCM Skip Build Wrapper", e);
                return new /* invalid duplicate definition of identical inner class */;
            }
        } else {
            SCMSkipTools.tagRunForDeletion(build, false);
        }
        return new /* invalid duplicate definition of identical inner class */;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private String skipPattern = ".*\\[ci skip\\].*";

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return "SCM Skip";
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            req.bindJSON((Object)this, json.getJSONObject("scmSkip"));
            this.save();
            return true;
        }

        public String getSkipPattern() {
            return this.skipPattern;
        }

        @DataBoundSetter
        public void setSkipPattern(String skipPattern) {
            this.skipPattern = skipPattern;
        }
    }
}

