/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import net.praqma.html.Html;
import net.praqma.jenkins.configrotator.AbstractConfiguration;
import net.praqma.jenkins.configrotator.ConfigurationRotatorBuildAction;
import net.praqma.jenkins.configrotator.ConfigurationRotatorReport;
import net.praqma.jenkins.configrotator.Feedable;
import net.praqma.util.xml.feed.Entry;
import net.praqma.util.xml.feed.Feed;
import net.praqma.util.xml.feed.FeedException;
import net.praqma.util.xml.feed.Person;

public abstract class AbstractConfigurationComponent
implements Serializable,
Feedable {
    protected boolean changedLast = false;
    protected boolean fixed = false;

    public AbstractConfigurationComponent(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean isChangedLast() {
        return this.changedLast;
    }

    public void setChangedLast(boolean b) {
        this.changedLast = b;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public abstract String getComponentName();

    public abstract String prettyPrint();

    @Override
    public File getFeedFile(File path) {
        return new File(path, ConfigurationRotatorReport.urlTtransform(this.getComponentName()) + ".xml");
    }

    public Feed getFeed(File feedFile, String url, Date updated) throws FeedException, IOException {
        String feedId = url + "feed/?component=" + ConfigurationRotatorReport.urlTtransform(this.getComponentName());
        String feedTitle = this.getComponentName();
        Feed feed = ConfigurationRotatorReport.getFeedFromFile(feedFile, feedTitle, feedId, updated);
        return feed;
    }

    @Override
    public Entry getFeedEntry(AbstractBuild<?, ?> build, Date updated) {
        ConfigurationRotatorBuildAction action = (ConfigurationRotatorBuildAction)build.getAction(ConfigurationRotatorBuildAction.class);
        AbstractConfiguration configuration = action.getConfigurationWithOutCast();
        List components = configuration.getList();
        String id = ((AbstractProject)build.getParent()).getDisplayName() + "#" + build.getNumber() + ", " + this.getFeedId();
        Entry entry = new Entry(this.getFeedName() + " in new " + action.getResult().toString() + " configuration", id, updated);
        int l = components.size() - 1;
        entry.summary = this.getFeedName() + " is " + action.getResult().toString() + " with " + l + " other component" + (l == 1 ? "" : "s");
        entry.author = new Person("Jenkins config-rotator job: " + ((AbstractProject)build.getParent()).getDisplayName() + ", build: #" + build.getNumber());
        entry.content = configuration.getDescription(build);
        Html.Break br1 = new Html.Break();
        Html.Anchor linkFeeds = new Html.Anchor(ConfigurationRotatorReport.FeedFrontpageUrl(), "Click here for a list of available feeds");
        Html.Break br2 = new Html.Break();
        Html.Anchor joblink = new Html.Anchor(ConfigurationRotatorReport.GenerateJobUrl(build), "Click here to go to the build that created this feed");
        entry.content = entry.content + configuration.toHtml() + br1 + linkFeeds + br2 + joblink;
        return entry;
    }

    protected String getBasicHtml(StringBuilder builder, Element ... elements) {
        builder.append("<tr>");
        for (Element e : elements) {
            if (e.highlight) {
                builder.append("<td style=\"font-weight:bold;color:#FF6633;padding-right:15px\">").append(e.element).append("</td>");
                continue;
            }
            builder.append("<td style=\"padding-right:15px\">").append(e.element).append("</td>");
        }
        builder.append("</tr>");
        return builder.toString();
    }

    public static class Element {
        public String element;
        public boolean highlight;

        public Element(String element, boolean highlight) {
            this.element = element;
            this.highlight = highlight;
        }
    }
}

