/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator;

import hudson.AbortException;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.scm.PollingResult;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.praqma.jenkins.configrotator.AbstractConfiguration;
import net.praqma.jenkins.configrotator.AbstractConfigurationComponent;
import net.praqma.jenkins.configrotator.AbstractTarget;
import net.praqma.jenkins.configrotator.ConfigurationRotator;
import net.praqma.jenkins.configrotator.ConfigurationRotatorBuildAction;
import net.praqma.jenkins.configrotator.ConfigurationRotatorException;
import net.praqma.jenkins.configrotator.ConfigurationRotatorSCMDescriptor;
import net.praqma.jenkins.configrotator.DiedBecauseAction;
import net.praqma.jenkins.configrotator.scm.ConfigRotatorChangeLogEntry;
import net.praqma.jenkins.configrotator.scm.ConfigRotatorChangeLogParser;
import net.praqma.jenkins.configrotator.scm.ConfigRotatorVersion;

public abstract class AbstractConfigurationRotatorSCM
implements Describable<AbstractConfigurationRotatorSCM>,
ExtensionPoint {
    private static final Logger logger = Logger.getLogger(AbstractConfigurationRotatorSCM.class.getName());
    protected AbstractConfiguration projectConfiguration;

    public abstract String getName();

    public void setConfiguration(AbstractConfiguration configuration) {
        this.projectConfiguration = configuration;
    }

    public AbstractConfiguration getConfiguration() {
        return this.projectConfiguration;
    }

    public abstract AbstractConfiguration nextConfiguration(TaskListener var1, AbstractConfiguration var2, FilePath var3) throws ConfigurationRotatorException;

    public abstract Poller getPoller(AbstractProject<?, ?> var1, Launcher var2, FilePath var3, TaskListener var4);

    public abstract Performer getPerform(AbstractBuild<?, ?> var1, Launcher var2, FilePath var3, BuildListener var4) throws IOException;

    public abstract void setConfigurationByAction(AbstractProject<?, ?> var1, ConfigurationRotatorBuildAction var2) throws IOException;

    public abstract boolean wasReconfigured(AbstractProject<?, ?> var1);

    public abstract ConfigRotatorChangeLogParser createChangeLogParser();

    public abstract <TT extends AbstractTarget> void setTargets(List<TT> var1);

    public abstract <TT extends AbstractTarget> List<TT> getTargets();

    public void printConfiguration(PrintStream out, AbstractConfiguration cfg) {
        if (cfg != null) {
            out.println("[ConfigRotator] The configuration is:");
            logger.fine("The configuration is:");
            for (Object c : cfg.getList()) {
                out.println(" * " + c);
                logger.fine(" * " + c);
            }
            out.println("");
            logger.fine("");
        } else {
            out.println("[ConfigRotator] The configuration is null");
            logger.fine("The configuration is null");
        }
    }

    public abstract ChangeLogWriter getChangeLogWriter(File var1, BuildListener var2, AbstractBuild<?, ?> var3);

    public Descriptor<AbstractConfigurationRotatorSCM> getDescriptor() {
        return (ConfigurationRotatorSCMDescriptor)Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public static DescriptorExtensionList<AbstractConfigurationRotatorSCM, ConfigurationRotatorSCMDescriptor<AbstractConfigurationRotatorSCM>> all() {
        return Jenkins.getInstance().getDescriptorList(AbstractConfigurationRotatorSCM.class);
    }

    public static List<ConfigurationRotatorSCMDescriptor<?>> getDescriptors() {
        ArrayList list = new ArrayList();
        for (ConfigurationRotatorSCMDescriptor d : AbstractConfigurationRotatorSCM.all()) {
            list.add(d);
        }
        return list;
    }

    public ConfigurationRotatorBuildAction getLastResult(AbstractProject<?, ?> project, Class<? extends AbstractConfigurationRotatorSCM> clazz) {
        for (AbstractBuild b = this.getLastBuildToBeConsidered(project); b != null; b = b.getPreviousBuild()) {
            ConfigurationRotatorBuildAction r = (ConfigurationRotatorBuildAction)b.getAction(ConfigurationRotatorBuildAction.class);
            if (r == null || !r.isDetermined() || clazz != null && !r.getClazz().equals(clazz)) continue;
            return r;
        }
        return null;
    }

    public DiedBecauseAction getLastDieAction(AbstractProject<?, ?> project) {
        return project.getLastBuild() != null ? (DiedBecauseAction)project.getLastBuild().getAction(DiedBecauseAction.class) : null;
    }

    public ConfigurationRotatorBuildAction getPreviousResult(AbstractBuild<?, ?> build, Class<? extends AbstractConfigurationRotatorSCM> clazz) {
        for (AbstractBuild b = build.getPreviousBuild(); b != null; b = b.getPreviousBuild()) {
            ConfigurationRotatorBuildAction r = (ConfigurationRotatorBuildAction)b.getAction(ConfigurationRotatorBuildAction.class);
            if (r == null || !r.isDetermined() || clazz != null && !r.getClazz().equals(clazz)) continue;
            return r;
        }
        return null;
    }

    public ArrayList<ConfigurationRotatorBuildAction> getLastResults(AbstractProject<?, ?> project, Class<? extends AbstractConfigurationRotatorSCM> clazz, int limit) {
        ArrayList<ConfigurationRotatorBuildAction> actions = new ArrayList<ConfigurationRotatorBuildAction>();
        for (AbstractBuild b = this.getLastBuildToBeConsidered(project); b != null; b = b.getPreviousBuild()) {
            ConfigurationRotatorBuildAction r = (ConfigurationRotatorBuildAction)b.getAction(ConfigurationRotatorBuildAction.class);
            if (r == null || !r.isDetermined() || clazz != null && !r.getClazz().equals(clazz)) continue;
            actions.add(r);
            if (actions.size() < limit) continue;
            return actions;
        }
        return actions;
    }

    private AbstractBuild<?, ?> getLastBuildToBeConsidered(AbstractProject<?, ?> project) {
        return (AbstractBuild)project.getLastCompletedBuild();
    }

    public File getFeedPath() {
        return new File(ConfigurationRotator.getFeedPath(), this.getClass().getSimpleName());
    }

    public String getFeedURL() {
        return "/config-rotator/" + this.getClass().getSimpleName();
    }

    public abstract class ChangeLogWriter<C extends AbstractConfigurationComponent, T extends AbstractConfiguration<C>> {
        protected File changeLogFile;
        protected BuildListener listener;
        protected AbstractBuild<?, ?> build;

        protected ChangeLogWriter(File changeLogFile, BuildListener listener, AbstractBuild<?, ?> build) {
            this.changeLogFile = changeLogFile;
            this.listener = listener;
            this.build = build;
        }

        public C getComponent(T configuration) throws ConfigurationRotatorException {
            if (configuration != null) {
                for (AbstractConfigurationComponent acc : ((AbstractConfiguration)configuration).getList()) {
                    if (!acc.isChangedLast()) continue;
                    return (C)acc;
                }
            }
            throw new ConfigurationRotatorException("No such component, " + configuration);
        }

        protected abstract List<ConfigRotatorChangeLogEntry> getChangeLogEntries(T var1, C var2) throws ConfigurationRotatorException;

        public List<ConfigRotatorChangeLogEntry> getChangeLogEntries(T configuration) throws ConfigurationRotatorException {
            return this.getChangeLogEntries(configuration, this.getComponent(configuration));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(List<ConfigRotatorChangeLogEntry> entries) {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(new FileWriter(this.changeLogFile));
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println("<changelog>");
                for (ConfigRotatorChangeLogEntry entry : entries) {
                    writer.println("<commit>");
                    writer.println(String.format("<user>%s</user>", entry.getUser()));
                    writer.println(String.format("<commitMessage>%s</commitMessage>", entry.getCommitMessage()));
                    writer.println("<versions>");
                    for (ConfigRotatorVersion v : entry.getVersions()) {
                        writer.println("<version>");
                        writer.println(String.format("<name>%s</name>", v.getName()));
                        writer.println(String.format("<file>%s</file>", v.getFile()));
                        writer.println(String.format("<user>%s</user>", v.getUser()));
                        writer.println("</version>");
                    }
                    writer.println("</versions>");
                    writer.print("</commit>");
                }
                writer.println("</changelog>");
            }
            catch (IOException e) {
                this.listener.getLogger().println("Unable to create change log. Trace written to log");
                logger.log(Level.WARNING, "Change log writing failed", e);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    public abstract class Performer<C> {
        protected AbstractBuild<?, ?> build;
        protected Launcher launcher;
        protected FilePath workspace;
        protected BuildListener listener;
        protected PrintStream out;

        public Performer(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener) {
            this.build = build;
            this.launcher = launcher;
            this.workspace = workspace;
            this.listener = listener;
            this.out = listener.getLogger();
        }

        public abstract C getInitialConfiguration() throws ConfigurationRotatorException, IOException;

        public abstract C getNextConfiguration(ConfigurationRotatorBuildAction var1) throws ConfigurationRotatorException;

        public abstract void checkConfiguration(C var1) throws ConfigurationRotatorException;

        public abstract void createWorkspace(C var1) throws ConfigurationRotatorException, IOException, InterruptedException;

        public Class getSCMClass() {
            return AbstractConfigurationRotatorSCM.this.getClass();
        }

        public abstract void print(C var1);

        public void save(C configuration) {
            AbstractConfigurationRotatorSCM.this.projectConfiguration = (AbstractConfiguration)configuration;
            ConfigurationRotatorBuildAction action1 = new ConfigurationRotatorBuildAction(this.build, this.getSCMClass(), (AbstractConfiguration)configuration);
            this.build.addAction((Action)action1);
        }
    }

    public class Poller<C extends AbstractConfiguration> {
        protected AbstractProject<?, ?> project;
        protected Launcher launcher;
        protected FilePath workspace;
        protected TaskListener listener;
        protected boolean canPollWhileBuilding = true;

        public Poller(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener) {
            this.project = project;
            this.launcher = launcher;
            this.workspace = workspace;
            this.listener = listener;
        }

        public Poller(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, boolean canPollWhileBuilding) {
            this.project = project;
            this.launcher = launcher;
            this.workspace = workspace;
            this.listener = listener;
            this.canPollWhileBuilding = canPollWhileBuilding;
        }

        public PollingResult poll(ConfigurationRotatorBuildAction action) throws AbortException {
            PrintStream out = this.listener.getLogger();
            logger.fine("[ConfigRotator] Polling started");
            if (!this.canPollWhileBuilding && this.project.isBuilding()) {
                return PollingResult.NO_CHANGES;
            }
            Object configuration = action.getConfiguration();
            if (configuration != null) {
                logger.fine("Resolving next configuration based on " + configuration);
                try {
                    AbstractConfiguration other = AbstractConfigurationRotatorSCM.this.nextConfiguration(this.listener, (AbstractConfiguration)configuration, this.workspace);
                    if (other != null) {
                        logger.fine("Found changes");
                        AbstractConfigurationRotatorSCM.this.printConfiguration(out, other);
                        return PollingResult.BUILD_NOW;
                    }
                    logger.fine("No changes!");
                    return PollingResult.NO_CHANGES;
                }
                catch (ConfigurationRotatorException e) {
                    logger.log(Level.WARNING, "Unable to poll", e);
                    throw new AbortException("[ConfigRotator] Unable to poll: " + e.getMessage());
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Polling caught unhandled exception. Message was", e);
                    throw new AbortException("[ConfigRotator] Polling caught unhandled exception! Message was: " + e.getMessage());
                }
            }
            logger.fine("No previous configuration, starting first build");
            return PollingResult.BUILD_NOW;
        }
    }
}

