/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.scm.SCM;
import java.io.IOException;
import javax.servlet.ServletException;
import net.praqma.jenkins.configrotator.AbstractConfiguration;
import net.praqma.jenkins.configrotator.AbstractConfigurationComponent;
import net.praqma.jenkins.configrotator.AbstractConfigurationRotatorSCM;
import net.praqma.jenkins.configrotator.ConfigurationRotator;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ConfigurationRotatorBuildAction
implements Action {
    private String description;
    private AbstractBuild<?, ?> build;
    private Class<? extends AbstractConfigurationRotatorSCM> clazz;
    private ConfigurationRotator.ResultType result = ConfigurationRotator.ResultType.UNDETERMINED;
    private AbstractConfiguration configuration;

    public ConfigurationRotatorBuildAction(AbstractBuild<?, ?> build, Class<? extends AbstractConfigurationRotatorSCM> clazz, AbstractConfiguration configuration) {
        this.build = build;
        this.clazz = clazz;
        this.configuration = configuration;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public void doReset(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        SCM scm = this.build.getProject().getScm();
        if (scm instanceof ConfigurationRotator) {
            ((ConfigurationRotator)scm).setConfigurationByAction(this.build.getProject(), this);
            rsp.sendRedirect("../../");
        } else {
            rsp.sendError(400, "Not a Configuration Rotator job");
        }
    }

    public void setResult(ConfigurationRotator.ResultType result) {
        this.result = result;
    }

    public boolean isDetermined() {
        return this.result.equals((Object)ConfigurationRotator.ResultType.COMPATIBLE) || this.result.equals((Object)ConfigurationRotator.ResultType.INCOMPATIBLE);
    }

    public boolean isCompatible() {
        return this.result.equals((Object)ConfigurationRotator.ResultType.COMPATIBLE);
    }

    public ConfigurationRotator.ResultType getResult() {
        return this.result;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "config-rotator";
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public <T extends AbstractConfiguration<? extends AbstractConfigurationComponent>> T getConfiguration() {
        return (T)this.configuration;
    }

    public AbstractConfiguration getConfigurationWithOutCast() {
        return this.configuration;
    }

    public String toString() {
        return "Build action: " + this.configuration;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

