/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.UnprotectedRootAction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jenkins.model.Jenkins;
import net.praqma.jenkins.configrotator.AbstractConfigurationRotatorSCM;
import net.praqma.jenkins.configrotator.ConfigurationRotatorSCMDescriptor;
import net.praqma.jenkins.configrotator.scm.clearcaseucm.ClearCaseUCMFeedAction;
import net.praqma.jenkins.configrotator.scm.git.GitFeedAction;
import net.praqma.util.xml.feed.AtomPublisher;
import net.praqma.util.xml.feed.Feed;
import net.praqma.util.xml.feed.FeedException;
import net.praqma.util.xml.feed.FeedPublisher;

@Extension
public class ConfigurationRotatorReport
extends Actionable
implements UnprotectedRootAction {
    public String getIconFileName() {
        return "/plugin/config-rotator/images/rotate.png";
    }

    public String getDisplayName() {
        return "Config Rotator";
    }

    public String getUrlName() {
        return "config-rotator";
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public DescriptorExtensionList<AbstractConfigurationRotatorSCM, ConfigurationRotatorSCMDescriptor<AbstractConfigurationRotatorSCM>> getSCMs() {
        return AbstractConfigurationRotatorSCM.all();
    }

    public synchronized List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new GitFeedAction());
        actions.add(new ClearCaseUCMFeedAction());
        return actions;
    }

    public String getUrl(ConfigurationRotatorSCMDescriptor<AbstractConfigurationRotatorSCM> scm) {
        return ConfigurationRotatorReport.getRootUrl() + this.getUrlName() + "/" + scm.getFeedComponentName();
    }

    public static Feed getFeedFromFile(File feedFile, String name, String feedId, Date feedUpdated) throws FeedException, IOException {
        if (feedFile.exists()) {
            return Feed.getFeed((FeedPublisher)new AtomPublisher(), (File)feedFile);
        }
        return new Feed(name, feedId, feedUpdated);
    }

    public static String urlTtransform(String url) {
        return url.replaceAll("[^a-zA-Z0-9]", "_");
    }

    public static String FeedFrontpageUrl() {
        return ConfigurationRotatorReport.getRootUrl() + "config-rotator" + "/";
    }

    public static String GenerateJobUrl(AbstractBuild<?, ?> build) {
        return ConfigurationRotatorReport.getRootUrl() + build.getUrl();
    }

    public static String getRootUrl() {
        if (Jenkins.getInstance() == null || Jenkins.getInstance().getRootUrl() == null) {
            return "http://localhost:8080/";
        }
        return Jenkins.getInstance().getRootUrl();
    }
}

