/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.jenkins.configrotator.AbstractConfiguration;
import net.praqma.jenkins.configrotator.AbstractConfigurationComponent;
import net.praqma.jenkins.configrotator.AbstractConfigurationRotatorSCM;
import net.praqma.jenkins.configrotator.ConfigurationRotator;
import net.praqma.jenkins.configrotator.ConfigurationRotatorBuildAction;
import net.praqma.jenkins.configrotator.ConfigurationRotatorReport;
import net.praqma.util.xml.feed.AtomPublisher;
import net.praqma.util.xml.feed.Entry;
import net.praqma.util.xml.feed.Feed;
import net.praqma.util.xml.feed.FeedException;
import net.praqma.util.xml.feed.FeedPublisher;

@Extension
public class ConfigurationRotatorRunListener
extends RunListener<Run> {
    private static Logger logger = Logger.getLogger(ConfigurationRotatorReport.class.getName());
    private TaskListener localListener;

    public ConfigurationRotatorRunListener() {
        super(Run.class);
    }

    public void onCompleted(Run run, TaskListener listener) {
        this.localListener = listener;
        AbstractBuild build = (AbstractBuild)run;
        if (build.getProject().getScm() instanceof ConfigurationRotator) {
            AbstractConfigurationRotatorSCM acscm = ((ConfigurationRotator)build.getProject().getScm()).getAcrs();
            ConfigurationRotatorBuildAction action = (ConfigurationRotatorBuildAction)build.getAction(ConfigurationRotatorBuildAction.class);
            if (action != null) {
                AbstractConfiguration configuration = action.getConfigurationWithOutCast();
                List components = configuration.getList();
                try {
                    for (AbstractConfigurationComponent component : components) {
                        File feedFile = component.getFeedFile(acscm.getFeedPath());
                        Date updated = new Date();
                        Feed feed = component.getFeed(feedFile, acscm.getFeedURL(), updated);
                        Entry e = component.getFeedEntry(build, updated);
                        feed.addEntry(e);
                        feed.updated = updated;
                        this.writeFeedToFile(feed, feedFile);
                    }
                }
                catch (Exception fe) {
                    logger.log(Level.SEVERE, "Feed error", fe);
                    this.localListener.getLogger().println("ConfigRotator RunListener caught excetption. Trace written to log.");
                }
            }
        }
    }

    private void writeFeedToFile(Feed feed, File feedFile) throws FeedException {
        FileWriter writer = null;
        try {
            if (!(feedFile.exists() || feedFile.getParentFile().exists() || feedFile.getParentFile().mkdirs())) {
                throw new IOException("ConfigRotator RunListener - writeFeedToFile: failed to make dirs");
            }
            writer = new FileWriter(feedFile);
            writer.write(feed.getXML((FeedPublisher)new AtomPublisher()));
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            if (writer != null) {
                try {
                    this.localListener.getLogger().println("ConfigRotator RunListener - writeFeedToFile: write failed caught IOException meaning feed may not have been written  Exception was: " + ex.getMessage());
                    ((Writer)writer).close();
                }
                catch (IOException ex1) {
                    this.localListener.getLogger().println("ConfigRotator RunListener - writeFeedToFile: write.close failed too caught IOException meaning feed may not have been written  Exception was: " + ex1.getMessage());
                }
            }
            this.localListener.getLogger().println("ConfigRotator RunListener - writeFeedToFile: writer  WAS NULL, caught IOException meaning feed may not have been written  Exception was: " + ex.getMessage());
        }
    }
}

