/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator.scm;

import hudson.model.User;
import hudson.scm.ChangeLogSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import net.praqma.jenkins.configrotator.scm.ConfigRotatorChangeLogSet;
import net.praqma.jenkins.configrotator.scm.ConfigRotatorVersion;

public class ConfigRotatorChangeLogEntry
extends ChangeLogSet.Entry
implements Serializable {
    protected ConfigRotatorChangeLogSet parent;
    private String commitMessage;
    private String user;
    private ArrayList<ConfigRotatorVersion> versions;

    public ConfigRotatorChangeLogEntry() {
        this.versions = new ArrayList();
    }

    public ConfigRotatorChangeLogEntry(String commitMessage, String user, ArrayList<ConfigRotatorVersion> versions) {
        this.commitMessage = commitMessage;
        this.user = user;
        this.versions = versions;
    }

    public String getMsg() {
        return this.commitMessage;
    }

    public Collection<String> getAffectedPaths() {
        ArrayList<String> strings = new ArrayList<String>();
        for (ConfigRotatorVersion ccv : this.getVersions()) {
            strings.add(ccv.getFile());
        }
        return strings;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public ArrayList<ConfigRotatorVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(ArrayList<ConfigRotatorVersion> versions) {
        this.versions = versions;
    }

    public void addVersion(ConfigRotatorVersion version) {
        this.versions.add(version);
    }

    public String getUser() {
        return this.user;
    }

    public User getAuthor() {
        if (this.user == null) {
            return User.getUnknown();
        }
        User u = User.get((String)this.user);
        return u;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public <T extends ConfigRotatorChangeLogSet> void setParent(T t) {
        this.parent = t;
    }

    public <T extends ConfigRotatorChangeLogSet> T getParent(Class<T> type) {
        return (T)((Object)this.parent);
    }

    public String toString() {
        return this.user + " - " + this.commitMessage;
    }
}

