/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator.scm.clearcaseucm;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.clearcase.PVob;
import net.praqma.clearcase.exceptions.UCMEntityNotInitializedException;
import net.praqma.clearcase.ucm.entities.Baseline;
import net.praqma.clearcase.ucm.entities.Component;
import net.praqma.clearcase.ucm.entities.Project;
import net.praqma.clearcase.ucm.entities.UCMEntity;
import net.praqma.clearcase.ucm.view.SnapshotView;
import net.praqma.jenkins.configrotator.AbstractConfiguration;
import net.praqma.jenkins.configrotator.AbstractConfigurationRotatorSCM;
import net.praqma.jenkins.configrotator.AbstractTarget;
import net.praqma.jenkins.configrotator.ConfigurationRotatorBuildAction;
import net.praqma.jenkins.configrotator.ConfigurationRotatorException;
import net.praqma.jenkins.configrotator.ConfigurationRotatorSCMDescriptor;
import net.praqma.jenkins.configrotator.DiedBecauseAction;
import net.praqma.jenkins.configrotator.scm.ConfigRotatorChangeLogEntry;
import net.praqma.jenkins.configrotator.scm.ConfigRotatorChangeLogParser;
import net.praqma.jenkins.configrotator.scm.clearcaseucm.ClearCaseGetBaseLineCompare;
import net.praqma.jenkins.configrotator.scm.clearcaseucm.ClearCaseUCMConfiguration;
import net.praqma.jenkins.configrotator.scm.clearcaseucm.ClearCaseUCMConfigurationComponent;
import net.praqma.jenkins.configrotator.scm.clearcaseucm.ClearCaseUCMTarget;
import net.praqma.jenkins.configrotator.scm.clearcaseucm.DetermineProject;
import net.praqma.jenkins.configrotator.scm.clearcaseucm.NextBaseline;
import net.praqma.jenkins.configrotator.scm.clearcaseucm.PrepareWorkspace;
import net.praqma.jenkins.configrotator.scm.clearcaseucm.RemoteUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ClearCaseUCM
extends AbstractConfigurationRotatorSCM
implements Serializable {
    private static final Logger logger = Logger.getLogger(ClearCaseUCM.class.getName());
    public List<ClearCaseUCMTarget> targets;
    private PVob pvob;

    public ClearCaseUCM(PVob pvob) {
        this.pvob = pvob;
    }

    @DataBoundConstructor
    public ClearCaseUCM(String pvobName) {
        this.pvob = new PVob(pvobName);
    }

    public String getPvobName() {
        return this.pvob.toString();
    }

    @Override
    public String getName() {
        return "ClearCase UCM";
    }

    @Override
    public ConfigRotatorChangeLogParser createChangeLogParser() {
        return new ConfigRotatorChangeLogParser();
    }

    public List<ClearCaseUCMTarget> getCompareTargets(AbstractProject<?, ?> project) {
        ConfigurationRotatorBuildAction action = this.getLastResult(project, ClearCaseUCM.class);
        DiedBecauseAction diedAction = this.getLastDieAction(project);
        if (action != null && action.getConfiguration() == null) {
            throw new AssertionError((Object)"The configuration is NOT allowed to be null at this point.");
        }
        List<? extends AbstractTarget> list = action != null ? this.getConfigurationAsTargets((ClearCaseUCMConfiguration)action.getConfiguration()) : diedAction.getTargets();
        return list;
    }

    @Override
    public boolean wasReconfigured(AbstractProject<?, ?> project) {
        logger.finest("Checking reconfiguration");
        ConfigurationRotatorBuildAction action = this.getLastResult(project, ClearCaseUCM.class);
        DiedBecauseAction diedAction = this.getLastDieAction(project);
        if (diedAction == null && action == null) {
            return true;
        }
        List<ClearCaseUCMTarget> list = this.getCompareTargets(project);
        if (this.targets.size() != list.size()) {
            logger.fine("Size was not equal");
            return true;
        }
        for (int i = 0; i < this.targets.size(); ++i) {
            if (this.targets.get(i).equals(list.get(i))) continue;
            return true;
        }
        logger.finest("UCM was not reconfigured");
        return false;
    }

    @Override
    public AbstractConfigurationRotatorSCM.Poller getPoller(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener) {
        return new AbstractConfigurationRotatorSCM.Poller(project, launcher, workspace, listener, false);
    }

    @Override
    public AbstractConfigurationRotatorSCM.Performer<ClearCaseUCMConfiguration> getPerform(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener) throws IOException {
        return new UCMPerformer(build, launcher, workspace, listener);
    }

    public void reconfigure(FilePath workspace, TaskListener listener) throws IOException {
        logger.fine("Getting configuration");
        PrintStream out = listener.getLogger();
        ClearCaseUCMConfiguration inputconfiguration = null;
        try {
            inputconfiguration = ClearCaseUCMConfiguration.getConfigurationFromTargets(this.getTargets(), workspace, listener);
        }
        catch (ConfigurationRotatorException e) {
            if (e.getCause() != null && e.getCause() instanceof UCMEntityNotInitializedException) {
                throw new AbortException(String.format("Reconfigure failed. UCM Entity could not be loaded.%n%s", e.getCause().getMessage()));
            }
            throw new AbortException(String.format("Reconfigure failed.%n%s", "[ConfigRotator] Unable to parse configuration: " + e.getMessage()));
        }
        this.projectConfiguration = inputconfiguration;
    }

    @Override
    public void printConfiguration(PrintStream out, AbstractConfiguration cfg) {
        out.println("[ConfigRotator] The configuration is:");
        logger.fine("[ConfigRotator] The configuration is:");
        if (cfg instanceof ClearCaseUCMConfiguration) {
            ClearCaseUCMConfiguration config = (ClearCaseUCMConfiguration)cfg;
            for (ClearCaseUCMConfigurationComponent c : config.getList()) {
                out.println(" * " + c.getBaseline().getComponent() + ", " + c.getBaseline().getStream() + ", " + c.getBaseline().getNormalizedName());
                logger.fine(" * " + c.getBaseline().getComponent() + ", " + c.getBaseline().getStream() + ", " + c.getBaseline().getNormalizedName());
            }
            out.println("");
            logger.fine("");
        }
    }

    public void simpleCheckOfConfiguration(AbstractConfiguration cfg) throws ConfigurationRotatorException {
        if (cfg instanceof ClearCaseUCMConfiguration) {
            ClearCaseUCMConfiguration config = (ClearCaseUCMConfiguration)cfg;
            HashSet<Component> ccucmcfgset = new HashSet<Component>();
            for (ClearCaseUCMConfigurationComponent c : config.getList()) {
                Component currentClearCaseComponent = c.getBaseline().getComponent();
                if (!ccucmcfgset.contains(currentClearCaseComponent)) {
                    ccucmcfgset.add(currentClearCaseComponent);
                    continue;
                }
                String errorMessage = "[ConfigRotator] Simple check of configuration failed because component used more than once in configuration. Component is: \n";
                errorMessage = errorMessage + " * " + c.getBaseline().getComponent() + ", " + c.getBaseline().getStream() + ", " + c.getBaseline().getNormalizedName();
                throw new ConfigurationRotatorException(errorMessage);
            }
        } else {
            throw new ConfigurationRotatorException("simpleCheckOfconfiguration failed " + cfg);
        }
    }

    @Override
    public AbstractConfiguration nextConfiguration(TaskListener listener, AbstractConfiguration configuration, FilePath workspace) throws ConfigurationRotatorException {
        Baseline oldest = null;
        ClearCaseUCMConfigurationComponent chosen = null;
        ClearCaseUCMConfiguration nconfig = (ClearCaseUCMConfiguration)configuration.clone();
        for (ClearCaseUCMConfigurationComponent config : nconfig.getList()) {
            if (config.isFixed()) continue;
            try {
                Baseline current = (Baseline)workspace.act((FilePath.FileCallable)new NextBaseline(config.getBaseline().getStream(), config.getBaseline().getComponent(), config.getPlevel(), config.getBaseline()));
                current = (Baseline)RemoteUtil.loadEntity(workspace, (UCMEntity)current, true);
                if (oldest == null || current.getDate().before(oldest.getDate())) {
                    oldest = current;
                    chosen = config;
                }
                config.setChangedLast(false);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "[ConfigRotator] No baselines found. Exception message follows", e);
            }
        }
        if (chosen == null || oldest == null) {
            listener.getLogger().println("[ConfigRotator] No new baselines");
            return null;
        }
        listener.getLogger().println("[ConfigRotator] There was a new baseline: " + oldest);
        chosen.setBaseline(oldest);
        chosen.setChangedLast(true);
        return nconfig;
    }

    public SnapshotView createView(TaskListener listener, AbstractBuild<?, ?> build, ClearCaseUCMConfiguration configuration, FilePath workspace, PVob pvob) throws IOException, InterruptedException {
        logger.fine("Getting project");
        Project project = (Project)workspace.act((FilePath.FileCallable)new DetermineProject(Arrays.asList("jenkins", "Jenkins", "hudson", "Hudson"), pvob));
        ArrayList<Baseline> selectedBaselines = new ArrayList<Baseline>();
        logger.fine("Selected baselines:");
        for (ClearCaseUCMConfigurationComponent config : configuration.getList()) {
            logger.fine(String.format("Component: %s", config));
            selectedBaselines.add(config.getBaseline());
        }
        String crProjectName = "cr-" + build.getProject().getDisplayName().replaceAll("\\s", "_");
        return (SnapshotView)workspace.act((FilePath.FileCallable)new PrepareWorkspace(project, selectedBaselines, crProjectName, listener));
    }

    @Override
    public <TT extends AbstractTarget> void setTargets(List<TT> targets) {
        this.targets = targets;
    }

    public List<ClearCaseUCMTarget> getTargets() {
        if (this.projectConfiguration != null) {
            return this.getConfigurationAsTargets((ClearCaseUCMConfiguration)this.projectConfiguration);
        }
        return this.targets;
    }

    private List<ClearCaseUCMTarget> getConfigurationAsTargets(ClearCaseUCMConfiguration config) {
        ArrayList<ClearCaseUCMTarget> list = new ArrayList<ClearCaseUCMTarget>();
        if (config.getList() != null && config.getList().size() > 0) {
            for (ClearCaseUCMConfigurationComponent c : config.getList()) {
                if (c != null) {
                    list.add(new ClearCaseUCMTarget(c.getBaseline().getNormalizedName(), c.getPlevel(), c.isFixed()));
                    continue;
                }
                return this.targets;
            }
            return list;
        }
        return this.targets;
    }

    @Override
    public void setConfigurationByAction(AbstractProject<?, ?> project, ConfigurationRotatorBuildAction action) throws IOException {
        ClearCaseUCMConfiguration c = (ClearCaseUCMConfiguration)action.getConfiguration();
        if (c == null) {
            throw new AbortException("[ConfigRotator] Not a valid configuration");
        }
        this.projectConfiguration = c;
        project.save();
    }

    @Override
    public AbstractConfigurationRotatorSCM.ChangeLogWriter getChangeLogWriter(File changeLogFile, BuildListener listener, AbstractBuild<?, ?> build) {
        return new UCMChangeLogWriter(changeLogFile, listener, build);
    }

    @Extension
    public static final class DescriptorImpl
    extends ConfigurationRotatorSCMDescriptor<ClearCaseUCM> {
        public String getDisplayName() {
            return "ClearCase UCM Components";
        }

        @Override
        public String getFeedComponentName() {
            return ClearCaseUCM.class.getSimpleName();
        }

        @Override
        public AbstractConfigurationRotatorSCM newInstance(StaplerRequest req, JSONObject formData, AbstractConfigurationRotatorSCM i) throws Descriptor.FormException {
            List<ClearCaseUCMTarget> targets;
            ClearCaseUCM instance;
            block2: {
                instance = (ClearCaseUCM)i;
                targets = new ArrayList();
                try {
                    JSONArray obj = formData.getJSONObject("acrs").getJSONArray("targets");
                    targets = req.bindJSONToList(ClearCaseUCMTarget.class, (Object)obj);
                }
                catch (JSONException jasonEx) {
                    ClearCaseUCMTarget target;
                    JSONObject obj = formData.getJSONObject("acrs").getJSONObject("targets");
                    if (obj == null || (target = (ClearCaseUCMTarget)req.bindJSON(ClearCaseUCMTarget.class, obj)) == null || target.getBaselineName() == null || target.getBaselineName().equals("")) break block2;
                    targets.add(target);
                }
            }
            instance.targets = targets;
            this.save();
            return instance;
        }

        public List<ClearCaseUCMTarget> getTargets(ClearCaseUCM instance) {
            if (instance == null) {
                return new ArrayList<ClearCaseUCMTarget>();
            }
            return instance.getTargets();
        }

        public Project.PromotionLevel[] getPromotionLevels() {
            return Project.PromotionLevel.values();
        }
    }

    public class UCMChangeLogWriter
    extends AbstractConfigurationRotatorSCM.ChangeLogWriter<ClearCaseUCMConfigurationComponent, ClearCaseUCMConfiguration> {
        public UCMChangeLogWriter(File changeLogFile, BuildListener listener, AbstractBuild<?, ?> build) {
            super(changeLogFile, listener, build);
        }

        @Override
        protected List<ConfigRotatorChangeLogEntry> getChangeLogEntries(ClearCaseUCMConfiguration configuration, ClearCaseUCMConfigurationComponent component) throws ConfigurationRotatorException {
            try {
                return (List)this.build.getWorkspace().act((FilePath.FileCallable)new ClearCaseGetBaseLineCompare(this.listener, configuration, component));
            }
            catch (Exception e) {
                throw new ConfigurationRotatorException(e);
            }
        }
    }

    public class UCMPerformer
    extends AbstractConfigurationRotatorSCM.Performer<ClearCaseUCMConfiguration> {
        public UCMPerformer(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener) {
            super(build, launcher, workspace, listener);
        }

        @Override
        public ClearCaseUCMConfiguration getInitialConfiguration() throws IOException, ConfigurationRotatorException {
            return ClearCaseUCMConfiguration.getConfigurationFromTargets(ClearCaseUCM.this.getTargets(), this.workspace, (TaskListener)this.listener);
        }

        @Override
        public ClearCaseUCMConfiguration getNextConfiguration(ConfigurationRotatorBuildAction action) throws ConfigurationRotatorException {
            ClearCaseUCMConfiguration oldconfiguration = (ClearCaseUCMConfiguration)action.getConfiguration();
            return (ClearCaseUCMConfiguration)ClearCaseUCM.this.nextConfiguration((TaskListener)this.listener, oldconfiguration, this.workspace);
        }

        @Override
        public void checkConfiguration(ClearCaseUCMConfiguration configuration) throws ConfigurationRotatorException {
            ClearCaseUCM.this.simpleCheckOfConfiguration(configuration);
        }

        @Override
        public void createWorkspace(ClearCaseUCMConfiguration configuration) throws ConfigurationRotatorException {
            try {
                this.out.println("[ConfigRotator] Creating view");
                logger.fine("Creating view");
                SnapshotView view = ClearCaseUCM.this.createView((TaskListener)this.listener, this.build, configuration, this.workspace, ClearCaseUCM.this.pvob);
                logger.fine(String.format("Created view %s", view));
                configuration.setView(view);
            }
            catch (Exception e) {
                this.out.println("[ConfigRotator] Unable to create view");
                ConfigurationRotatorException ex = new ConfigurationRotatorException("Unable to create view", e);
                logger.log(Level.SEVERE, "Unable to create view in createWorkspace()", ex);
                throw ex;
            }
        }

        @Override
        public void print(ClearCaseUCMConfiguration configuration) {
            ClearCaseUCM.this.printConfiguration(this.out, configuration);
        }
    }
}

