/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator.scm.clearcaseucm;

import net.praqma.clearcase.exceptions.ClearCaseException;
import net.praqma.clearcase.ucm.entities.Baseline;
import net.praqma.clearcase.ucm.entities.Project;
import net.praqma.jenkins.configrotator.AbstractConfigurationComponent;

public class ClearCaseUCMConfigurationComponent
extends AbstractConfigurationComponent {
    private Baseline baseline;
    private Project.PromotionLevel plevel;

    public ClearCaseUCMConfigurationComponent(Baseline baseline, Project.PromotionLevel plevel, boolean fixed) {
        super(fixed);
        this.baseline = baseline;
        this.plevel = plevel;
    }

    public ClearCaseUCMConfigurationComponent(String baseline, String plevel, boolean fixed) throws ClearCaseException {
        super(fixed);
        this.baseline = Baseline.get((String)baseline).load();
        this.plevel = Project.PromotionLevel.valueOf((String)plevel);
    }

    public ClearCaseUCMConfigurationComponent clone() {
        ClearCaseUCMConfigurationComponent cc = new ClearCaseUCMConfigurationComponent(this.baseline, this.plevel, this.fixed);
        return cc;
    }

    public void setBaseline(Baseline baseline) {
        this.baseline = baseline;
    }

    public Baseline getBaseline() {
        return this.baseline;
    }

    public Project.PromotionLevel getPlevel() {
        return this.plevel;
    }

    public String toString() {
        return this.baseline.getNormalizedName() + "@" + this.plevel + "(" + this.fixed + "/" + this.changedLast + ")";
    }

    @Override
    public String prettyPrint() {
        return this.baseline.getNormalizedName() + "@" + this.plevel;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ClearCaseUCMConfigurationComponent) {
            ClearCaseUCMConfigurationComponent o = (ClearCaseUCMConfigurationComponent)other;
            return o.baseline.equals((Object)this.baseline) && o.plevel.equals((Object)this.plevel) && o.isFixed() == this.fixed;
        }
        return false;
    }

    @Override
    public String getComponentName() {
        return this.baseline.getComponent().getNormalizedName();
    }

    @Override
    public String getFeedName() {
        return this.baseline.getComponent().getNormalizedName();
    }

    @Override
    public String getFeedId() {
        return this.baseline.getComponent().getNormalizedName();
    }

    @Override
    public String toHtml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<tr>");
        builder.append("<td style=\"padding:5px 10px;\">").append(this.baseline.getComponent().getNormalizedName()).append("</td>");
        builder.append("<td style=\"padding:5px 10px;\">").append(this.baseline.getStream().getNormalizedName()).append("</td>");
        if (this.isChangedLast()) {
            builder.append("<td style=\"font-weight:bold;color:#FF6633;padding:5px 10px;\">").append(this.baseline.getNormalizedName()).append("</td>");
        } else {
            builder.append("<td style=\"padding:5px 10px;\">").append(this.baseline.getNormalizedName()).append("</td>");
        }
        builder.append("<td style=\"padding:5px 10px;\">").append(this.plevel.toString()).append("</td>");
        builder.append("<td style=\"padding:5px 10px;\">").append(this.fixed).append("</td>").append("</tr>");
        return builder.toString();
    }
}

