/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator.scm.clearcaseucm;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.clearcase.ConfigSpec;
import net.praqma.clearcase.Rebase;
import net.praqma.clearcase.exceptions.ClearCaseException;
import net.praqma.clearcase.exceptions.RebaseException;
import net.praqma.clearcase.exceptions.UnableToInitializeEntityException;
import net.praqma.clearcase.interfaces.StreamContainable;
import net.praqma.clearcase.ucm.entities.Baseline;
import net.praqma.clearcase.ucm.entities.Project;
import net.praqma.clearcase.ucm.entities.Stream;
import net.praqma.clearcase.ucm.view.GetView;
import net.praqma.clearcase.ucm.view.SnapshotView;
import net.praqma.clearcase.ucm.view.UpdateView;

public class PrepareWorkspace
implements FilePath.FileCallable<SnapshotView> {
    private final Project project;
    private static final Logger log = Logger.getLogger(PrepareWorkspace.class.getName());
    private final TaskListener listener;
    private final String jenkinsProjectName;
    private final List<Baseline> baselines;

    public PrepareWorkspace(Project project, List<Baseline> baselines, String jenkinsProjectName, TaskListener listener) {
        this.project = project;
        this.jenkinsProjectName = jenkinsProjectName;
        this.listener = listener;
        this.baselines = baselines;
    }

    public SnapshotView invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        Stream devStream;
        String viewtag = this.jenkinsProjectName + "-" + System.getenv("COMPUTERNAME");
        PrintStream out = this.listener.getLogger();
        out.println(String.format("%sResulting viewtag is: %s", "[ConfigRotator] ", viewtag));
        SnapshotView view = null;
        File viewroot = new File(workspace, "view");
        String streamName = viewtag + "@" + this.project.getPVob();
        try {
            devStream = Stream.get((String)streamName);
        }
        catch (UnableToInitializeEntityException e) {
            throw new IOException("No entity", e);
        }
        if (devStream.exists()) {
            out.println("[ConfigRotator] Stream exists");
            try {
                view = new GetView(viewroot, viewtag).createIfAbsent().setStream(devStream).get();
            }
            catch (ClearCaseException e) {
                throw new IOException("Could not get view", e);
            }
            try {
                Rebase rb = new Rebase(devStream);
                out.println("[ConfigRotator] Rebasing stream to " + devStream.getNormalizedName());
                rb.setViewTag(viewtag).addBaselines(this.baselines).dropFromStream().rebase(true, true);
            }
            catch (RebaseException e) {
                throw new IOException("Failed to rebase the current stream " + devStream, e);
            }
            catch (ClearCaseException reb) {
                throw new IOException("Could not load " + devStream, reb);
            }
            try {
                out.println("[ConfigRotator] View root: " + new File(workspace, "view"));
                out.println("[ConfigRotator] View tag : " + viewtag);
                new ConfigSpec(viewroot).addLoadRule(this.baselines).generate().appy();
                new UpdateView(view).swipe().overwrite().update();
            }
            catch (ClearCaseException e) {
                throw new IOException("Unable to create view", e);
            }
        }
        out.println("[ConfigRotator] Creating a new environment");
        try {
            out.println("[ConfigRotator] Creating new stream");
            devStream = Stream.create((StreamContainable)this.project.getIntegrationStream(), (String)streamName, (boolean)true, this.baselines);
        }
        catch (ClearCaseException e1) {
            throw new IOException("Unable to create stream " + streamName, e1);
        }
        try {
            view = new GetView(viewroot, viewtag).setStream(devStream).createIfAbsent().get();
            new UpdateView(view).setLoadRules(new SnapshotView.LoadRules2(view, SnapshotView.Components.ALL)).generate().update();
        }
        catch (ClearCaseException e) {
            log.log(Level.WARNING, "Failed to update view, exception to follow", e);
            throw new IOException("Unable to create view", e);
        }
        return view;
    }
}

