/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.configrotator.scm.git;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.praqma.jenkins.configrotator.AbstractConfiguration;
import net.praqma.jenkins.configrotator.AbstractConfigurationRotatorSCM;
import net.praqma.jenkins.configrotator.AbstractTarget;
import net.praqma.jenkins.configrotator.ConfigurationRotatorBuildAction;
import net.praqma.jenkins.configrotator.ConfigurationRotatorException;
import net.praqma.jenkins.configrotator.ConfigurationRotatorSCMDescriptor;
import net.praqma.jenkins.configrotator.scm.ConfigRotatorChangeLogEntry;
import net.praqma.jenkins.configrotator.scm.ConfigRotatorChangeLogParser;
import net.praqma.jenkins.configrotator.scm.git.GitConfiguration;
import net.praqma.jenkins.configrotator.scm.git.GitConfigurationComponent;
import net.praqma.jenkins.configrotator.scm.git.GitTarget;
import net.praqma.jenkins.configrotator.scm.git.ResolveChangeLog;
import net.praqma.jenkins.configrotator.scm.git.ResolveNextCommit;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.eclipse.jgit.revwalk.RevCommit;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class Git
extends AbstractConfigurationRotatorSCM
implements Serializable {
    private static Logger logger = Logger.getLogger(Git.class.getName());
    private List<GitTarget> targets = new ArrayList<GitTarget>();

    @DataBoundConstructor
    public Git() {
    }

    @Override
    public String getName() {
        return "Git repository";
    }

    @Override
    public AbstractConfigurationRotatorSCM.Poller getPoller(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener) {
        return new AbstractConfigurationRotatorSCM.Poller(project, launcher, workspace, listener);
    }

    @Override
    public AbstractConfigurationRotatorSCM.Performer getPerform(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener) throws IOException {
        return new GitPerformer(build, launcher, workspace, listener);
    }

    @Override
    public void setConfigurationByAction(AbstractProject<?, ?> project, ConfigurationRotatorBuildAction action) throws IOException {
        GitConfiguration c = (GitConfiguration)action.getConfiguration();
        if (c == null) {
            throw new AbortException("[ConfigRotator] Not a valid configuration");
        }
        this.projectConfiguration = c;
        project.save();
    }

    @Override
    public boolean wasReconfigured(AbstractProject<?, ?> project) {
        ConfigurationRotatorBuildAction action = this.getLastResult(project, Git.class);
        if (action == null) {
            return true;
        }
        GitConfiguration configuration = (GitConfiguration)action.getConfiguration();
        if (configuration == null) {
            logger.fine("Configuration was null");
            return true;
        }
        if (this.targets.size() != configuration.getList().size()) {
            logger.fine("Size was not equal");
            return true;
        }
        for (int i = 0; i < this.targets.size(); ++i) {
            GitTarget t = this.targets.get(i);
            GitConfigurationComponent c = (GitConfigurationComponent)configuration.getList().get(i);
            if (t.getBranch().equals(c.getBranch()) && t.getRepository().equals(c.getRepository()) && t.getCommitId().equals(c.getCommitId())) continue;
            logger.finer("Configuration was not equal");
            return true;
        }
        return false;
    }

    @Override
    public ConfigRotatorChangeLogParser createChangeLogParser() {
        return new ConfigRotatorChangeLogParser();
    }

    @Override
    public AbstractConfigurationRotatorSCM.ChangeLogWriter getChangeLogWriter(File changeLogFile, BuildListener listener, AbstractBuild<?, ?> build) {
        return new GitChangeLogWriter(changeLogFile, listener, build);
    }

    @Override
    public AbstractConfiguration nextConfiguration(TaskListener listener, AbstractConfiguration configuration, FilePath workspace) throws ConfigurationRotatorException {
        logger.fine("Getting next Git configuration: " + configuration);
        RevCommit oldest = null;
        GitConfigurationComponent chosen = null;
        GitConfiguration nconfig = (GitConfiguration)configuration.clone();
        for (GitConfigurationComponent config : nconfig.getList()) {
            if (config.isFixed()) continue;
            try {
                logger.fine("Config: " + config);
                RevCommit commit = (RevCommit)workspace.act((FilePath.FileCallable)new ResolveNextCommit(config.getName(), config.getCommitId()));
                if (commit == null) continue;
                logger.fine("Current commit: " + commit.getName());
                logger.fine("Current commit: " + commit.getCommitTime());
                if (oldest != null) {
                    logger.fine("Oldest  commit: " + oldest.getName());
                    logger.fine("Oldest  commit: " + oldest.getCommitTime());
                }
                if (oldest == null || commit.getCommitTime() < oldest.getCommitTime()) {
                    oldest = commit;
                    chosen = config;
                }
                config.setChangedLast(false);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "No commit found", e);
            }
        }
        logger.fine("Configuration component: " + chosen);
        logger.fine("Oldest valid commit: " + oldest);
        if (chosen == null || oldest == null) {
            listener.getLogger().println("[ConfigRotator] No new commits");
            logger.fine("No new commits");
            return null;
        }
        logger.fine("There was a new commit: " + oldest);
        listener.getLogger().println("[ConfigRotator] Next commit: " + chosen);
        chosen.setCommitId(oldest.getName());
        chosen.setChangedLast(true);
        return nconfig;
    }

    private List<GitTarget> getConfigurationAsTargets(GitConfiguration config) {
        ArrayList<GitTarget> list = new ArrayList<GitTarget>();
        if (config.getList() != null && config.getList().size() > 0) {
            for (GitConfigurationComponent c : config.getList()) {
                if (c != null) {
                    list.add(new GitTarget(c.getName(), c.getRepository(), c.getBranch(), c.getCommitId(), c.isFixed()));
                    continue;
                }
                return this.targets;
            }
            return list;
        }
        return this.targets;
    }

    @Override
    public <TT extends AbstractTarget> void setTargets(List<TT> targets) {
        this.targets = targets;
    }

    public List<GitTarget> getTargets() {
        if (this.projectConfiguration != null) {
            return this.getConfigurationAsTargets((GitConfiguration)this.projectConfiguration);
        }
        return this.targets;
    }

    @Extension
    public static final class DescriptorImpl
    extends ConfigurationRotatorSCMDescriptor<Git> {
        public String getDisplayName() {
            return "Git Repositories";
        }

        @Override
        public String getFeedComponentName() {
            return Git.class.getSimpleName();
        }

        public FormValidation doTest() throws IOException, ServletException {
            return FormValidation.ok();
        }

        @Override
        public AbstractConfigurationRotatorSCM newInstance(StaplerRequest req, JSONObject formData, AbstractConfigurationRotatorSCM i) throws Descriptor.FormException {
            List<GitTarget> targets;
            Git instance;
            block2: {
                instance = (Git)i;
                targets = new ArrayList();
                try {
                    JSONArray obj = formData.getJSONObject("acrs").getJSONArray("targets");
                    targets = req.bindJSONToList(GitTarget.class, (Object)obj);
                }
                catch (JSONException jasonEx) {
                    GitTarget target;
                    JSONObject obj = formData.getJSONObject("acrs").getJSONObject("targets");
                    if (obj == null || (target = (GitTarget)req.bindJSON(GitTarget.class, obj)) == null || target.getRepository() == null || target.getRepository().equals("")) break block2;
                    targets.add(target);
                }
            }
            instance.targets = targets;
            this.save();
            return instance;
        }

        public List<GitTarget> getTargets(Git instance) {
            if (instance == null) {
                return new ArrayList<GitTarget>();
            }
            return instance.getTargets();
        }
    }

    public class GitChangeLogWriter
    extends AbstractConfigurationRotatorSCM.ChangeLogWriter<GitConfigurationComponent, GitConfiguration> {
        public GitChangeLogWriter(File changeLogFile, BuildListener listener, AbstractBuild<?, ?> build) {
            super(changeLogFile, listener, build);
        }

        @Override
        protected List<ConfigRotatorChangeLogEntry> getChangeLogEntries(GitConfiguration configuration, GitConfigurationComponent configurationComponent) throws ConfigurationRotatorException {
            logger.fine("Change log entry, " + configurationComponent);
            try {
                ConfigRotatorChangeLogEntry entry = (ConfigRotatorChangeLogEntry)this.build.getWorkspace().act((FilePath.FileCallable)new ResolveChangeLog(configurationComponent.getName(), configurationComponent.getCommitId()));
                logger.fine("ENTRY: " + entry);
                return Collections.singletonList(entry);
            }
            catch (Exception e) {
                throw new ConfigurationRotatorException("Unable to resolve changelog " + configurationComponent.getCommitId(), e);
            }
        }
    }

    public class GitPerformer
    extends AbstractConfigurationRotatorSCM.Performer<GitConfiguration> {
        public GitPerformer(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener) {
            super(build, launcher, workspace, listener);
        }

        @Override
        public GitConfiguration getInitialConfiguration() throws ConfigurationRotatorException {
            return new GitConfiguration(Git.this.getTargets(), this.workspace, (TaskListener)this.listener);
        }

        @Override
        public GitConfiguration getNextConfiguration(ConfigurationRotatorBuildAction action) throws ConfigurationRotatorException {
            GitConfiguration oldconfiguration = (GitConfiguration)action.getConfiguration();
            return (GitConfiguration)Git.this.nextConfiguration((TaskListener)this.listener, oldconfiguration, this.workspace);
        }

        @Override
        public void checkConfiguration(GitConfiguration configuration) {
        }

        @Override
        public void createWorkspace(GitConfiguration configuration) throws IOException, InterruptedException {
            configuration.checkout(this.workspace, (TaskListener)this.listener);
        }

        @Override
        public void print(GitConfiguration configuration) {
        }
    }
}

