/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.drmemory;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Logger;
import net.praqma.jenkins.plugin.drmemory.DrMemoryBuildAction;
import net.praqma.jenkins.plugin.drmemory.DrMemoryRemoteBuilder;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class DrMemoryBuilder
extends Builder {
    private static final Logger logger = Logger.getLogger(DrMemoryBuilder.class.getName());
    private String executable;
    private String arguments;
    private String logPath;
    private String finalLogPath;

    @DataBoundConstructor
    public DrMemoryBuilder(String executable, String arguments, String logPath) {
        this.executable = executable;
        this.arguments = arguments;
        this.logPath = logPath;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        PrintStream out = listener.getLogger();
        DrMemoryBuildAction dba = new DrMemoryBuildAction(build, this);
        build.getActions().add(dba);
        try {
            this.finalLogPath = this.logPath = this.logPath + (this.logPath.endsWith("/") ? "" : (this.logPath.endsWith("\\") ? "" : "/"));
            this.finalLogPath = this.finalLogPath + build.getNumber();
            build.getWorkspace().act((FilePath.FileCallable)new DrMemoryRemoteBuilder(this.executable, this.arguments, this.finalLogPath, listener));
            return true;
        }
        catch (IOException e) {
            out.println("Unable to execute Dr. Memory: " + e.getMessage());
            return false;
        }
    }

    public String getExecutable() {
        return this.executable;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public String getFinalLogPath() {
        return this.finalLogPath;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DrMemoryBuilder newInstance(StaplerRequest req, JSONObject data) {
            DrMemoryBuilder instance = (DrMemoryBuilder)((Object)req.bindJSON(DrMemoryBuilder.class, data));
            this.save();
            return instance;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Execute with Dr. Memory";
        }
    }
}

