/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.reloaded;

import hudson.matrix.Combination;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Hudson;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.security.Permission;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.praqma.jenkins.plugin.reloaded.RebuildAction;
import net.sf.json.JSONException;
import org.jfree.util.Log;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixReloadedAction
implements Action {
    private AbstractBuild<?, ?> build;
    private String checked = null;
    private static final Logger logger = Logger.getLogger(MatrixReloadedAction.class.getName());

    public MatrixReloadedAction() {
    }

    public MatrixReloadedAction(String checked) {
        this.checked = checked;
    }

    public String getDisplayName() {
        return "Matrix Reloaded";
    }

    public String getIconFileName() {
        return "plugin/matrix-reloaded/images/matrix_small.png";
    }

    public String getUrlName() {
        return "matrix-reloaded";
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public String getPrefix() {
        return "MRP::";
    }

    public String getChecked() {
        return this.checked;
    }

    public Permission getPermission() {
        return MatrixProject.BUILD;
    }

    public boolean combinationExists(AbstractBuild<?, ?> build, Combination c) {
        MatrixProject mp = null;
        if (build instanceof MatrixBuild) {
            mp = (MatrixProject)build.getProject();
        } else if (build instanceof MatrixRun) {
            mp = (MatrixProject)((MatrixRun)build).getParentBuild().getProject();
        } else {
            Log.warn((Object)"Unable to determine matrix project");
            return false;
        }
        MatrixConfiguration mc = mp.getItem(c);
        return mc != null && mc.isActiveConfiguration();
    }

    public RebuildAction getRebuildAction(Map<String, String[]> formData) {
        logger.info("[MRP] The MATRIX RELOADED FORM has been submitted");
        RebuildAction raction = new RebuildAction();
        Set<String> keys = formData.keySet();
        for (String key : keys) {
            if (key.equals("MRP::NUMBER")) {
                String value = formData.get(key)[0];
                try {
                    raction.setBaseBuildNumber(Integer.parseInt(value));
                    logger.info("[MRP] Build number is " + raction.getBaseBuildNumber());
                }
                catch (NumberFormatException w) {}
                continue;
            }
            if (key.startsWith("MRP::")) {
                String[] vs = key.split("::", 2);
                try {
                    if (vs.length > 1) {
                        logger.info("[MRP] adding " + key);
                        raction.addConfiguration(Combination.fromString((String)vs[1]), true);
                    }
                }
                catch (JSONException e) {
                    // empty catch block
                }
            }
            if (!key.startsWith("forceDownstream")) continue;
            raction.setRebuildDownstream(true);
        }
        return raction;
    }

    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException, InterruptedException {
        BuildType type;
        Hudson.getInstance().checkPermission(this.getPermission());
        AbstractBuild mbuild = (AbstractBuild)req.findAncestorObject(AbstractBuild.class);
        if (req.findAncestor(MatrixRun.class) != null) {
            type = BuildType.MATRIXRUN;
            this.build = ((MatrixRun)mbuild).getParentBuild();
        } else if (req.findAncestor(MatrixBuild.class) != null) {
            type = BuildType.MATRIXBUILD;
            this.build = mbuild;
        } else {
            type = BuildType.UNKNOWN;
        }
        Map map = req.getParameterMap();
        RebuildAction raction = this.getRebuildAction(map);
        ParametersAction pactions = (ParametersAction)this.build.getAction(ParametersAction.class);
        Hudson.getInstance().getQueue().schedule((Queue.Task)this.build.getProject(), 0, new Action[]{pactions, raction, new CauseAction((Cause)new Cause.UserCause())});
        if (type.equals((Object)BuildType.MATRIXRUN)) {
            rsp.sendRedirect("../../../");
        } else {
            rsp.sendRedirect("../../");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BuildType {
        MATRIXBUILD,
        MATRIXRUN,
        UNKNOWN;

    }
}

