/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.memorymap;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.praqma.jenkins.memorymap.MemoryMapRecorder;
import net.praqma.jenkins.memorymap.result.MemoryMapConfigMemory;
import net.praqma.jenkins.memorymap.result.MemoryMapConfigMemoryItem;
import net.praqma.jenkins.memorymap.util.HexUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class MemoryMapBuildAction
implements Action {
    private MemoryMapConfigMemory memoryMapConfig;
    private AbstractBuild<?, ?> build;
    private MemoryMapRecorder recorder;

    public MemoryMapBuildAction(AbstractBuild<?, ?> build, MemoryMapConfigMemory memoryMapConfig) {
        this.build = build;
        this.memoryMapConfig = memoryMapConfig;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "Memory map";
    }

    public String getUrlName() {
        return null;
    }

    public boolean validateThreshold(int threshold, String ... valuenames) {
        return this.sumOfValues(valuenames) <= threshold;
    }

    public boolean validateThreshold(int threshold, List<String> valuenames) {
        return this.sumOfValues(valuenames) <= threshold;
    }

    public int sumOfValues(String ... valuenames) {
        int sum = 0;
        return sum;
    }

    public int sumOfValues(List<String> values) {
        int sum = 0;
        return sum;
    }

    public MemoryMapBuildAction getPreviousAction(AbstractBuild<?, ?> base) {
        MemoryMapBuildAction action = null;
        AbstractBuild start = base;
        do {
            if ((start = (AbstractBuild)start.getPreviousCompletedBuild()) != null) continue;
            return null;
        } while ((action = (MemoryMapBuildAction)start.getAction(MemoryMapBuildAction.class)) == null);
        return action;
    }

    public MemoryMapBuildAction getPreviousAction() {
        MemoryMapBuildAction action = null;
        AbstractBuild start = this.build;
        do {
            if ((start = (AbstractBuild)start.getPreviousCompletedBuild()) != null) continue;
            return null;
        } while ((action = (MemoryMapBuildAction)start.getAction(MemoryMapBuildAction.class)) == null || !action.isValidConfigurationWithData());
        return action;
    }

    public void doDrawMemoryMapUsageGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        DataSetBuilder dataset = new DataSetBuilder();
        String members = req.getParameter("categories");
        String graphTitle = req.getParameter("title");
        int w = Integer.parseInt(req.getParameter("width"));
        int h = Integer.parseInt(req.getParameter("height"));
        List<String> memberList = Arrays.asList(members.split(","));
        ArrayList<ValueMarker> markers = new ArrayList<ValueMarker>();
        double max = Double.MIN_VALUE;
        HashSet<String> drawnMarker = new HashSet<String>();
        for (MemoryMapBuildAction membuild = this; membuild != null; membuild = membuild.getPreviousAction()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(membuild.build);
            MemoryMapConfigMemory result = membuild.getMemoryMapConfig();
            for (MemoryMapConfigMemoryItem res : result) {
                if (!memberList.contains(res.getName())) continue;
                double value = HexUtils.kiloWordCount(res.getUsed(), this.getRecorder().getWordSize());
                double byteValue = HexUtils.kiloByteCount(res.getUsed(), this.getRecorder().getWordSize());
                double maxx = HexUtils.kiloWordCount(res.getLength(), this.getRecorder().getWordSize());
                if (this.getRecorder().getShowBytesOnGraph().booleanValue()) {
                    maxx = HexUtils.kiloByteCount(res.getLength(), this.getRecorder().getWordSize());
                }
                if (this.getRecorder().getShowBytesOnGraph().booleanValue()) {
                    dataset.add((Number)byteValue, (Comparable)((Object)res.getName()), (Comparable)label);
                } else {
                    dataset.add((Number)value, (Comparable)((Object)res.getName()), (Comparable)label);
                }
                if (drawnMarker.add(res.getName())) {
                    ValueMarker vm = new ValueMarker(maxx, (Paint)Color.BLACK, (Stroke)new BasicStroke(1.2f, 2, 0, 1.0f, new float[]{6.0f, 6.0f}, 0.0f));
                    vm.setLabel(String.format("%s(max)", res.getName()));
                    vm.setLabelOffset(new RectangleInsets(5.0, 50.0, -20.0, 5.0));
                    vm.setLabelAnchor(RectangleAnchor.TOP_LEFT);
                    vm.setPaint((Paint)Color.BLACK);
                    vm.setOutlinePaint((Paint)Color.BLACK);
                    vm.setAlpha(1.0f);
                    markers.add(vm);
                }
                if (!(maxx > max)) continue;
                max = maxx;
            }
        }
        JFreeChart chart = this.createPairedBarCharts(graphTitle, this.getRecorder().getShowBytesOnGraph() != false ? "kBytes" : "kWords", max * 1.1, 0.0, dataset.build(), markers);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.getLegend().setPosition(RectangleEdge.BOTTOM);
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)chart, (int)w, (int)h);
    }

    protected JFreeChart createStackedCharts(String title, String yaxis, int max, int min, CategoryDataset dataset, List<ValueMarker> markers) {
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        NumberAxis rangeAxis = new NumberAxis(yaxis);
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperBound((double)max);
        rangeAxis.setLowerBound((double)min);
        StackedAreaRenderer2 renderer = new StackedAreaRenderer2();
        CategoryPlot plot = new CategoryPlot(dataset, (CategoryAxis)domainAxis, (ValueAxis)rangeAxis, (CategoryItemRenderer)renderer);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        for (ValueMarker mkr : markers) {
            plot.addRangeMarker((Marker)mkr);
        }
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.setTitle(title);
        return chart;
    }

    protected JFreeChart createPairedBarCharts(String title, String yaxis, double max, double min, CategoryDataset dataset, List<ValueMarker> markers) {
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        NumberAxis rangeAxis = new NumberAxis(yaxis);
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperBound(max);
        rangeAxis.setLowerBound(min);
        BarRenderer renderer = new BarRenderer();
        CategoryPlot plot = new CategoryPlot(dataset, (CategoryAxis)domainAxis, (ValueAxis)rangeAxis, (CategoryItemRenderer)renderer);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        for (ValueMarker mkr : markers) {
            plot.addRangeMarker((Marker)mkr);
        }
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.setTitle(title);
        return chart;
    }

    protected JFreeChart createChart(CategoryDataset dataset, String title, String yaxis, int max, int min) {
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)title, null, (String)yaxis, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.BOTTOM);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperBound((double)max);
        rangeAxis.setLowerBound((double)min);
        StackedAreaRenderer renderer = (StackedAreaRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(2.0f));
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public MemoryMapRecorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(MemoryMapRecorder recorder) {
        this.recorder = recorder;
    }

    public MemoryMapConfigMemory getMemoryMapConfig() {
        return this.memoryMapConfig;
    }

    public void setMemoryMapConfig(MemoryMapConfigMemory memoryMapConfig) {
        this.memoryMapConfig = memoryMapConfig;
    }

    public boolean isValidConfigurationWithData() {
        return this.memoryMapConfig != null && this.memoryMapConfig.size() >= 1;
    }
}

