/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.memorymap;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.ProminentProjectAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.praqma.jenkins.memorymap.MemoryMapBuildAction;
import net.praqma.jenkins.memorymap.graph.MemoryMapGraphConfiguration;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class MemoryMapProjectAction
extends Actionable
implements ProminentProjectAction {
    public static final String ICON_NAME = "/plugin/memory-map/images/64x64/memory.png";
    private AbstractProject<?, ?> project;

    public MemoryMapProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getDisplayName() {
        return "Memory Map Publisher";
    }

    public String getSearchUrl() {
        return "Memory map";
    }

    public String getIconFileName() {
        return ICON_NAME;
    }

    public String getUrlName() {
        return "memory-map";
    }

    public MemoryMapBuildAction getLatestActionInProject() {
        if (this.project.getLastCompletedBuild() != null) {
            return (MemoryMapBuildAction)((AbstractBuild)this.project.getLastCompletedBuild()).getAction(MemoryMapBuildAction.class);
        }
        return null;
    }

    public MemoryMapBuildAction getLastApplicableMemoryMapResult() {
        for (AbstractBuild build = (AbstractBuild)this.project.getLastCompletedBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            MemoryMapBuildAction mmba = (MemoryMapBuildAction)build.getAction(MemoryMapBuildAction.class);
            if (mmba == null || !mmba.isValidConfigurationWithData()) continue;
            return mmba;
        }
        return null;
    }

    public void doDrawMemoryMapUsageGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.getLastApplicableMemoryMapResult() != null) {
            this.getLastApplicableMemoryMapResult().doDrawMemoryMapUsageGraph(req, rsp);
        }
    }

    public List<String> getGraphTitles() {
        ArrayList<String> titles = new ArrayList<String>();
        MemoryMapBuildAction mmba = this.getLastApplicableMemoryMapResult();
        if (mmba != null) {
            List<MemoryMapGraphConfiguration> configs = mmba.getRecorder().getGraphConfiguration();
            for (MemoryMapGraphConfiguration conf : configs) {
                titles.add(conf.getGraphCaption());
            }
        }
        return titles;
    }

    public String getAssociatedProgramMemoryAreas(String graphTitle) {
        MemoryMapBuildAction mmba = this.getLastApplicableMemoryMapResult();
        String res = null;
        List<MemoryMapGraphConfiguration> configs = mmba.getRecorder().getGraphConfiguration();
        for (MemoryMapGraphConfiguration conf : configs) {
            if (!conf.getGraphCaption().equals(graphTitle)) continue;
            res = conf.getGraphDataList();
        }
        return res;
    }
}

