/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.memorymap;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import net.praqma.jenkins.memorymap.MemoryMapBuildAction;
import net.praqma.jenkins.memorymap.MemoryMapProjectAction;
import net.praqma.jenkins.memorymap.graph.MemoryMapGraphConfiguration;
import net.praqma.jenkins.memorymap.parser.AbstractMemoryMapParser;
import net.praqma.jenkins.memorymap.parser.MemoryMapConfigFileParserDelegate;
import net.praqma.jenkins.memorymap.parser.MemoryMapMapParserDelegate;
import net.praqma.jenkins.memorymap.parser.MemoryMapParserDescriptor;
import net.praqma.jenkins.memorymap.result.MemoryMapConfigMemory;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class MemoryMapRecorder
extends Recorder {
    private String mapFile;
    private Integer wordSize;
    private String configurationFile;
    private boolean showBytesOnGraph;
    private AbstractMemoryMapParser chosenParser;
    private List<MemoryMapGraphConfiguration> graphConfiguration;

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    @DataBoundConstructor
    public MemoryMapRecorder(AbstractMemoryMapParser chosenParser, String configurationFile, boolean showBytesOnGraph, String wordSize) {
        this.chosenParser = chosenParser;
        this.configurationFile = configurationFile;
        this.showBytesOnGraph = showBytesOnGraph;
        this.wordSize = StringUtils.isBlank((String)wordSize) ? 16 : Integer.parseInt(wordSize);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean failed = false;
        PrintStream out = listener.getLogger();
        MemoryMapConfigMemory config = null;
        String version = Hudson.getInstance().getPlugin("memory-map").getWrapper().getVersion();
        out.println("Memory Map Plugin version " + version);
        try {
            this.chosenParser.setConfigurationFile(this.configurationFile);
            config = (MemoryMapConfigMemory)build.getWorkspace().act((FilePath.FileCallable)new MemoryMapConfigFileParserDelegate(this.graphConfiguration, this.chosenParser));
            config = (MemoryMapConfigMemory)build.getWorkspace().act((FilePath.FileCallable)new MemoryMapMapParserDelegate(this.chosenParser, config));
        }
        catch (IOException ex) {
            ex.printStackTrace(out);
            failed = true;
        }
        out.println("Printing configuration");
        if (config != null) {
            out.println("== Configuration start ==");
            out.println();
            out.println(config.toString());
            out.println("== Configuration end ==");
        }
        MemoryMapBuildAction mmba = new MemoryMapBuildAction(build, config);
        mmba.setRecorder(this);
        mmba.setMemoryMapConfig(config);
        if (failed) {
            build.setResult(Result.FAILURE);
            return false;
        }
        build.getActions().add(mmba);
        return true;
    }

    public String getMapFile() {
        return this.mapFile;
    }

    public void setMapFile(String mapFile) {
        this.mapFile = mapFile;
    }

    public AbstractMemoryMapParser getChosenParser() {
        return this.chosenParser;
    }

    public void setChosenParser(AbstractMemoryMapParser chosenParser) {
        this.chosenParser = chosenParser;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(String configurationFile) {
        this.configurationFile = configurationFile;
    }

    public List<MemoryMapGraphConfiguration> getGraphConfiguration() {
        return this.graphConfiguration;
    }

    public void setGraphConfiguration(List<MemoryMapGraphConfiguration> graphConfiguration) {
        this.graphConfiguration = graphConfiguration;
    }

    public Boolean getShowBytesOnGraph() {
        return this.showBytesOnGraph;
    }

    public void setShowBytesOnGraph(Boolean showBytesOnGraph) {
        this.showBytesOnGraph = showBytesOnGraph;
    }

    public Integer getWordSize() {
        return this.wordSize;
    }

    public void setWordSize(Integer wordSize) {
        this.wordSize = wordSize;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new MemoryMapProjectAction(project);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> type) {
            return true;
        }

        public String getDisplayName() {
            return "Memory Map Publisher";
        }

        public List<MemoryMapParserDescriptor<?>> getParsers() {
            return AbstractMemoryMapParser.getDescriptors();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            MemoryMapRecorder instance = (MemoryMapRecorder)((Object)req.bindJSON(MemoryMapRecorder.class, formData));
            List graphConfiguration = req.bindParametersToList(MemoryMapGraphConfiguration.class, "graph.config.");
            if (graphConfiguration != null) {
                instance.setGraphConfiguration(graphConfiguration);
            }
            this.save();
            return instance;
        }

        public DescriptorImpl() {
            super(MemoryMapRecorder.class);
            this.load();
        }
    }
}

