/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.memorymap.parser;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import net.praqma.jenkins.memorymap.graph.MemoryMapGraphConfiguration;
import net.praqma.jenkins.memorymap.parser.MemoryMapConfigFileParserDelegate;
import net.praqma.jenkins.memorymap.parser.MemoryMapMapParserDelegate;
import net.praqma.jenkins.memorymap.parser.MemoryMapParsable;
import net.praqma.jenkins.memorymap.parser.MemoryMapParserDescriptor;
import net.praqma.jenkins.memorymap.result.MemoryMapConfigMemory;
import net.praqma.jenkins.memorymap.result.MemoryMapConfigMemoryItem;
import org.apache.commons.collections.ListUtils;

public abstract class AbstractMemoryMapParser
implements Describable<AbstractMemoryMapParser>,
ExtensionPoint,
MemoryMapParsable,
Serializable {
    private static final String UTF_8_CHARSET = "UTF8";
    protected static final Logger logger = Logger.getLogger(AbstractMemoryMapParser.class.toString());
    protected List<Pattern> patterns;
    protected String mapFile;
    private String configurationFile;
    private Integer wordSize;
    private Boolean bytesOnGraph;

    public AbstractMemoryMapParser() {
        this.patterns = ListUtils.EMPTY_LIST;
    }

    public AbstractMemoryMapParser(String mapFile, String configurationFile, Integer wordSize, Boolean bytesOnGraph, Pattern ... pattern) {
        this.patterns = Arrays.asList(pattern);
        this.mapFile = mapFile;
        this.configurationFile = configurationFile;
        this.wordSize = wordSize;
        this.bytesOnGraph = bytesOnGraph;
    }

    protected CharSequence createCharSequenceFromFile(File f) throws IOException {
        return this.createCharSequenceFromFile(UTF_8_CHARSET, f);
    }

    protected CharSequence createCharSequenceFromFile(String charset, File f) throws IOException {
        String chosenCharset = charset;
        CharBuffer cbuf = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f.getAbsolutePath());
            FileChannel fc = fis.getChannel();
            MappedByteBuffer bbuf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc.size());
            if (!Charset.isSupported(chosenCharset)) {
                logger.warning(String.format("The charset %s is not supported", charset));
                cbuf = Charset.defaultCharset().newDecoder().decode(bbuf);
            } else {
                cbuf = Charset.forName(charset).newDecoder().decode(bbuf);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return cbuf;
    }

    @Override
    public MemoryMapConfigMemory parseConfigFile(List<MemoryMapGraphConfiguration> graphConfig, File f) throws IOException {
        MemoryMapConfigMemory config = new MemoryMapConfigMemory();
        CharSequence sequence = this.createCharSequenceFromFile(f);
        for (MemoryMapGraphConfiguration graph : graphConfig) {
            String[] split;
            for (String s : split = graph.getGraphDataList().split(",")) {
                Matcher m = MemoryMapConfigFileParserDelegate.getPatternForMemoryLayout(s).matcher(sequence);
                MemoryMapConfigMemoryItem item = null;
                while (m.find()) {
                    item = new MemoryMapConfigMemoryItem(m.group(1), m.group(3), m.group(5));
                    config.add(item);
                }
                if (item != null) continue;
                logger.logp(Level.WARNING, "parseConfigFile", AbstractMemoryMapParser.class.getName(), String.format("parseConfigFile(List<MemoryMapGraphConfiguration> graphConfig, File f) non existing item: %s", s));
                throw new IOException(String.format("No match found for program memory named %s", s));
            }
        }
        return config;
    }

    @Override
    public MemoryMapConfigMemory parseMapFile(File f, MemoryMapConfigMemory configuration) throws IOException {
        CharSequence sequence = this.createCharSequenceFromFile(f);
        for (MemoryMapConfigMemoryItem item : configuration) {
            Matcher matcher = MemoryMapMapParserDelegate.getPatternForMemorySection(item.getName()).matcher(sequence);
            boolean found = false;
            while (matcher.find()) {
                item.setUsed(matcher.group(8));
                item.setUnused(matcher.group(10));
                found = true;
            }
            if (found) continue;
            logger.logp(Level.WARNING, "parseMapFile", AbstractMemoryMapParser.class.getName(), String.format("parseMapFile(File f, MemoryMapConfigMemory configuration) non existing item: %s", item));
            throw new IOException(String.format("Linker command element %s not found in .map file", item));
        }
        return configuration;
    }

    public String getMapFile() {
        return this.mapFile;
    }

    public void setMapFile(String mapFile) {
        this.mapFile = mapFile;
    }

    public Descriptor<AbstractMemoryMapParser> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public static DescriptorExtensionList<AbstractMemoryMapParser, MemoryMapParserDescriptor<AbstractMemoryMapParser>> all() {
        return Jenkins.getInstance().getDescriptorList(AbstractMemoryMapParser.class);
    }

    public static List<MemoryMapParserDescriptor<?>> getDescriptors() {
        ArrayList list = new ArrayList();
        for (MemoryMapParserDescriptor d : AbstractMemoryMapParser.all()) {
            list.add(d);
        }
        return list;
    }

    public Integer getWordSize() {
        return this.wordSize;
    }

    public void setWordSize(Integer wordSize) {
        this.wordSize = wordSize;
    }

    public Boolean getBytesOnGraph() {
        return this.bytesOnGraph;
    }

    public void setBytesOnGraph(Boolean bytesOnGraph) {
        this.bytesOnGraph = bytesOnGraph;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(String configurationFile) {
        this.configurationFile = configurationFile;
    }
}

