/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.memorymap.parser;

import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.praqma.jenkins.memorymap.graph.MemoryMapGraphConfiguration;
import net.praqma.jenkins.memorymap.parser.AbstractMemoryMapParser;
import net.praqma.jenkins.memorymap.parser.MemoryMapMapParserDelegate;
import net.praqma.jenkins.memorymap.result.MemoryMapConfigMemory;
import net.praqma.jenkins.memorymap.util.FileFoundable;

public class MemoryMapConfigFileParserDelegate
extends FileFoundable<MemoryMapConfigMemory> {
    private static final Logger log = Logger.getLogger(MemoryMapMapParserDelegate.class.getName());
    private AbstractMemoryMapParser parser;
    private List<MemoryMapGraphConfiguration> graphConfig;
    private static HashMap<String, Pattern> patternRegistry;

    public MemoryMapConfigFileParserDelegate() {
    }

    public MemoryMapConfigFileParserDelegate(List<MemoryMapGraphConfiguration> graphConfig, AbstractMemoryMapParser parser) {
        this.parser = parser;
        this.graphConfig = graphConfig;
    }

    public MemoryMapConfigMemory invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        MemoryMapConfigMemory mmcm = null;
        try {
            mmcm = this.parser.parseConfigFile(this.graphConfig, this.findFile(f, this.parser.getConfigurationFile()));
        }
        catch (IOException ex) {
            log.logp(Level.WARNING, "invoke", MemoryMapConfigFileParserDelegate.class.getName(), "invoke caught file not found exception", ex);
            throw new IOException(ex.getMessage());
        }
        if (mmcm == null) {
            log.warning("Result was null, and no exception was thrown, this should NOT happen");
            throw new IOException("Result was null, and no exception was thrown, this should NOT happen");
        }
        return mmcm;
    }

    public AbstractMemoryMapParser getParser() {
        return this.parser;
    }

    public void setParser(AbstractMemoryMapParser parser) {
        this.parser = parser;
    }

    public static Pattern getPatternForMemoryLayout(String sectionName) {
        if (patternRegistry == null) {
            patternRegistry = new HashMap();
        }
        if (patternRegistry.containsKey(sectionName)) {
            return patternRegistry.get(sectionName);
        }
        String regex = String.format("^(\\s+%s\\b)(.*origin\\s=\\s)(0x\\S+)(,.*)(0x\\S+)(.*)$", sectionName);
        Pattern memsection = Pattern.compile(regex, 8);
        patternRegistry.put(sectionName, memsection);
        return memsection;
    }
}

