/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.memorymap.parser;

import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.praqma.jenkins.memorymap.parser.AbstractMemoryMapParser;
import net.praqma.jenkins.memorymap.parser.MemoryMapConfigFileParserDelegate;
import net.praqma.jenkins.memorymap.result.MemoryMapConfigMemory;
import net.praqma.jenkins.memorymap.util.FileFoundable;

public class MemoryMapMapParserDelegate
extends FileFoundable<MemoryMapConfigMemory> {
    private static final Logger log = Logger.getLogger(MemoryMapMapParserDelegate.class.getName());
    private AbstractMemoryMapParser parser;
    private MemoryMapConfigMemory config;
    private static HashMap<String, Pattern> patternRegistry;

    public MemoryMapMapParserDelegate() {
    }

    public MemoryMapMapParserDelegate(AbstractMemoryMapParser parser) {
        this.parser = parser;
    }

    public MemoryMapMapParserDelegate(AbstractMemoryMapParser parser, MemoryMapConfigMemory config) {
        this.parser = parser;
        this.config = config;
    }

    public MemoryMapConfigMemory invoke(File file, VirtualChannel vc) throws IOException, InterruptedException {
        try {
            return this.getParser().parseMapFile(this.findFile(file, this.parser.getMapFile()), this.config);
        }
        catch (FileNotFoundException fnfex) {
            log.logp(Level.WARNING, "invoke", MemoryMapConfigFileParserDelegate.class.getName(), "invoke caught file not found exception", fnfex);
            throw new IOException(fnfex.getMessage());
        }
        catch (IOException ex) {
            log.logp(Level.WARNING, "invoke", MemoryMapConfigFileParserDelegate.class.getName(), "invoke caught IOException", ex);
            throw new IOException(ex.getMessage());
        }
    }

    public AbstractMemoryMapParser getParser() {
        return this.parser;
    }

    public void setParser(AbstractMemoryMapParser parser) {
        this.parser = parser;
    }

    public static Pattern getPatternForMemorySection(String sectionName) {
        if (patternRegistry == null) {
            patternRegistry = new HashMap();
        }
        if (patternRegistry.containsKey(sectionName)) {
            return patternRegistry.get(sectionName);
        }
        String regex = String.format("^(\\s+)(\\b%s)(\\s+)(\\S+)(\\s+)(\\S+)(\\s+)(\\S+)(\\s+)(\\S+)(\\s+)(\\S+)", sectionName);
        Pattern memsection = Pattern.compile(regex, 8);
        patternRegistry.put(sectionName, memsection);
        return memsection;
    }
}

