/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.memorymap.util;

import hudson.FilePath;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public abstract class FileFoundable<T>
implements FilePath.FileCallable<T> {
    public File findFile(File file, String pattern) throws IOException {
        FileSet fileSet = new FileSet();
        Project project = new Project();
        fileSet.setProject(project);
        fileSet.setDir(file);
        fileSet.setIncludes(pattern);
        int numberOfFoundFiles = fileSet.getDirectoryScanner(project).getIncludedFiles().length;
        if (numberOfFoundFiles == 0) {
            throw new FileNotFoundException(String.format("Filematcher found no files using pattern %s in folder %s", pattern, file.getAbsolutePath()));
        }
        File f = new File(file.getAbsoluteFile() + System.getProperty("file.separator") + fileSet.getDirectoryScanner(project).getIncludedFiles()[0]);
        if (!f.exists()) {
            throw new FileNotFoundException(String.format("File %s not found workspace was %s scanner found %s files.", f.getAbsolutePath(), file.getAbsolutePath(), numberOfFoundFiles));
        }
        return f;
    }
}

