/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.praqma.prqa.PRQAApplicationSettings;
import net.praqma.prqa.PRQAReportSettings;
import net.praqma.prqa.exceptions.PrqaSetupException;
import net.praqma.prqa.products.Product;
import net.praqma.prqa.products.QAC;
import net.praqma.prqa.products.QACpp;
import org.apache.commons.lang.StringUtils;

public class PRQARemoteToolCheck
implements FilePath.FileCallable<String> {
    public final BuildListener listener;
    public final boolean isUnix;
    public HashMap<String, String> environment;
    public final PRQAApplicationSettings appSettings;
    public final PRQAReportSettings reportSettings;
    public final Product product;

    public PRQARemoteToolCheck() {
        this.listener = null;
        this.isUnix = false;
        this.environment = null;
        this.appSettings = null;
        this.reportSettings = null;
        this.product = null;
    }

    public PRQARemoteToolCheck(Product product, HashMap<String, String> environment, PRQAApplicationSettings appSettings, PRQAReportSettings reportSettings, BuildListener listener, boolean isUnix) {
        this.listener = listener;
        this.isUnix = isUnix;
        this.environment = environment;
        this.appSettings = appSettings;
        this.reportSettings = reportSettings;
        this.product = product;
    }

    public HashMap<String, String> expandEnvironment(HashMap<String, String> environment, PRQAApplicationSettings appSettings, PRQAReportSettings reportSetting, boolean isUnix) throws PrqaSetupException {
        String pathVar = "path";
        Map<String, String> localEnv = System.getenv();
        for (String s : localEnv.keySet()) {
            if (!s.equalsIgnoreCase(pathVar)) continue;
            pathVar = s;
            break;
        }
        String currentPath = localEnv.get(pathVar);
        String delimiter = System.getProperty("file.separator");
        String pathSep = System.getProperty("path.separator");
        if (environment != null) {
            String qawHome;
            File qawHomeFolder;
            String slashPath;
            if (reportSetting.product.equalsIgnoreCase("qac")) {
                slashPath = PRQAApplicationSettings.addSlash((String)environment.get("QACPATH"), (String)delimiter);
                environment.put("QACPATH", slashPath);
                String qacBin = PRQAApplicationSettings.addSlash((String)environment.get("QACPATH"), (String)delimiter) + "bin";
                environment.put("QACBIN", qacBin);
                environment.put("QACHELPFILES", environment.get("QACPATH") + "help");
                currentPath = environment.get("QACBIN") + pathSep + currentPath;
                environment.put("QACTEMP", System.getProperty("java.io.tmpdir"));
            } else {
                slashPath = PRQAApplicationSettings.addSlash((String)environment.get("QACPPPATH"), (String)delimiter);
                environment.put("QACPPPATH", slashPath);
                String qacppBin = PRQAApplicationSettings.addSlash((String)environment.get("QACPPPATH"), (String)delimiter) + "bin";
                environment.put("QACPPBIN", qacppBin);
                environment.put("QACPPHELPFILES", environment.get("QACPPPATH") + "help");
                currentPath = environment.get("QACPPBIN") + pathSep + currentPath;
                environment.put("QACPPTEMP", System.getProperty("java.io.tmpdir"));
            }
            String qarPath = PRQAApplicationSettings.addSlash((String)appSettings.qarHome, (String)delimiter) + "bin";
            File qarFolder = new File(qarPath);
            if (!qarFolder.exists()) {
                throw new PrqaSetupException(String.format("Non existant QAR home directory (%s) - Check your tool settings", qarPath));
            }
            currentPath = qarPath + pathSep + currentPath;
            if (StringUtils.isBlank((String)appSettings.qavClientHome) && reportSetting.publishToQAV) {
                throw new PrqaSetupException("You have not configured QA\u00b7Verify client home - Check your tool settings");
            }
            if (!StringUtils.isBlank((String)appSettings.qavClientHome) && reportSetting.publishToQAV) {
                String qavClientHome = null;
                qavClientHome = isUnix ? PRQAApplicationSettings.addSlash((String)appSettings.qavClientHome, (String)delimiter) + "bin" : appSettings.qavClientHome;
                File qavClientFolder = new File(qavClientHome);
                if (!qavClientFolder.exists()) {
                    throw new PrqaSetupException(String.format("Non existant QA Verify client home directory (%s) does not exist - Check your tool settings", qavClientHome));
                }
                currentPath = qavClientHome + pathSep + currentPath;
            }
            if (!(qawHomeFolder = new File(qawHome = PRQAApplicationSettings.addSlash((String)appSettings.qawHome, (String)delimiter) + "bin")).exists()) {
                throw new PrqaSetupException(String.format("Non existant QAW home directory (%s) - Check your tool settings", qawHome));
            }
            currentPath = qawHome + pathSep + currentPath;
            environment.put(pathVar, currentPath);
        }
        return environment;
    }

    private void _checkImportantEnvVars(HashMap<String, String> env, Product product) throws PrqaSetupException {
        block4: {
            block5: {
                if (env == null) break block4;
                if (!(product instanceof QAC)) break block5;
                for (String s : QAC.envVarsForTool) {
                    String value = env.get(s);
                    if (value == null) {
                        throw new PrqaSetupException(String.format("The enviroment variable %s is not defined", new Object[0]));
                    }
                    File f = new File(value);
                    if (f.exists()) continue;
                    throw new PrqaSetupException(String.format("Configuration error - Check your QA\u00b7C Product installation path%nThe enviroment created points to a non-existing location%nCheck your tool settings%nThe tool location missing was: %s", f.getAbsolutePath()));
                }
                break block4;
            }
            if (!(product instanceof QACpp)) break block4;
            for (String s : QACpp.envVarsForTool) {
                String value = env.get(s);
                if (value == null) {
                    throw new PrqaSetupException(String.format("The enviroment variable %s is not defined", new Object[0]));
                }
                File f = new File(value);
                if (f.exists()) continue;
                throw new PrqaSetupException(String.format("Configuration error - Check your QA\u00b7C++ Product installation path%nThe enviroment created points to a non-existing location%n Check your tool settings%nThe tool location missing was: %s", f.getAbsolutePath()));
            }
        }
    }

    private void _checkBinaryMatch(HashMap<String, String> env, Product product) throws PrqaSetupException {
        String pathSep = System.getProperty("file.separator");
        if (env != null) {
            if (this.isUnix) {
                if (product instanceof QAC) {
                    File f = new File(env.get("QACBIN") + pathSep + "qac");
                    String path = f.getPath();
                    if (!f.exists()) {
                        throw new PrqaSetupException(String.format("QA\u00b7C was selected as product, but no qac binary found in location: %s", path));
                    }
                } else {
                    File f = new File(env.get("QACPPBIN") + pathSep + "qacpp");
                    String path = f.getPath();
                    if (!f.exists()) {
                        throw new PrqaSetupException(String.format("QA\u00b7C++ was selected as product, but no qacpp binary found in location: %s", path));
                    }
                }
            } else if (product instanceof QAC) {
                File f = new File(env.get("QACBIN") + pathSep + "qac.exe");
                String path = f.getPath();
                if (!f.exists()) {
                    throw new PrqaSetupException(String.format("QA\u00b7C was selected as product, but no qac binary found in location: %s", path));
                }
            } else {
                File f = new File(env.get("QACPPBIN") + pathSep + "qacpp.exe");
                String path = f.getPath();
                if (!f.exists()) {
                    throw new PrqaSetupException(String.format("QA\u00b7C++ was selected as product, but no qacpp binary found in location: %s", path));
                }
            }
        }
    }

    public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        try {
            HashMap<String, String> envExpanded = this.expandEnvironment(this.environment, this.appSettings, this.reportSettings, this.isUnix);
            this._checkImportantEnvVars(envExpanded, this.product);
            if (this.product instanceof QAC || this.product instanceof QACpp) {
                this._checkBinaryMatch(envExpanded, this.product);
            }
            return this.product.getProductVersion(envExpanded, f, this.isUnix);
        }
        catch (PrqaSetupException setupException) {
            throw new IOException("Tool misconfiguration detected", setupException);
        }
    }
}

