/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.notifier;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.tasks.Publisher;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.IOException;
import java.util.HashMap;
import net.praqma.jenkins.plugin.prqa.graphs.PRQAGraph;
import net.praqma.jenkins.plugin.prqa.notifier.PRQANotifier;
import net.praqma.prqa.PRQAReading;
import net.praqma.prqa.PRQAStatusCollection;
import net.praqma.prqa.exceptions.PrqaException;
import net.praqma.prqa.status.PRQAComplianceStatus;
import net.praqma.prqa.status.PRQAStatus;
import net.praqma.prqa.status.StatusCategory;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PRQABuildAction
implements Action {
    private final AbstractBuild<?, ?> build;
    private Publisher publisher;
    private PRQAReading result;
    public static final String DISPLAY_NAME = "PRQA";
    public static final String URL_NAME = "PRQA";

    public PRQABuildAction() {
        this.build = null;
    }

    public PRQABuildAction(AbstractBuild<?, ?> build) {
        this.build = build;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "PRQA";
    }

    public String getUrlName() {
        return "PRQA";
    }

    public Publisher getPublisher() {
        return this.publisher;
    }

    public <T extends Publisher> T getPublisher(Class<T> clazz) {
        return (T)this.publisher;
    }

    public PRQAReading getResult() {
        return this.result;
    }

    public Number getThreshold(StatusCategory cat) {
        if (this.result != null && this.result.getThresholds().containsKey(cat)) {
            return (Number)this.result.getThresholds().get(cat);
        }
        return null;
    }

    public <T extends PRQAStatus> T getResult(Class<T> clazz) {
        try {
            if (this.result.getClass().isAssignableFrom(clazz)) {
                return (T)((PRQAStatus)this.result);
            }
            return null;
        }
        catch (NullPointerException nex) {
            return null;
        }
    }

    public void setResult(PRQAReading result) {
        this.result = result;
    }

    public void setPublisher(Publisher publisher) {
        this.publisher = publisher;
    }

    public PRQABuildAction getPreviousAction() {
        return this.getPreviousAction(this.build);
    }

    public PRQABuildAction getPreviousAction(AbstractBuild<?, ?> base) {
        PRQABuildAction action = null;
        AbstractBuild start = base;
        do {
            if ((start = (AbstractBuild)start.getPreviousNotFailedBuild()) != null) continue;
            return null;
        } while ((action = (PRQABuildAction)start.getAction(PRQABuildAction.class)) == null);
        return action;
    }

    public PRQAReading getBuildActionStatus() {
        return this.result;
    }

    public <T extends PRQAStatus> T getBuildActionStatus(Class<T> clazz) {
        return (T)((PRQAStatus)this.result);
    }

    public StatusCategory[] getComplianceCategories() {
        return StatusCategory.values();
    }

    private HashMap<StatusCategory, Boolean> _doDrawThresholds(StaplerRequest req, StaplerResponse rsp) {
        PRQANotifier notifier = (PRQANotifier)this.getPublisher();
        HashMap<StatusCategory, Boolean> stats = new HashMap<StatusCategory, Boolean>();
        if (notifier != null) {
            String className = req.getParameter("graph");
            PRQAGraph graph = notifier.getGraph(className);
            for (PRQABuildAction prqabuild = this; prqabuild != null; prqabuild = prqabuild.getPreviousAction()) {
                if (prqabuild.getResult() == null) continue;
                PRQAReading stat = prqabuild.getResult();
                for (StatusCategory cat : graph.getCategories()) {
                    Number threshold = prqabuild.getThreshold(cat);
                    if (threshold != null) {
                        stats.put(cat, Boolean.TRUE);
                        continue;
                    }
                    stats.put(cat, Boolean.FALSE);
                }
                return stats;
            }
        }
        return stats;
    }

    public void doReportGraphs(StaplerRequest req, StaplerResponse rsp) throws IOException {
        PRQANotifier notifier = (PRQANotifier)this.getPublisher();
        HashMap<StatusCategory, Boolean> drawMatrix = this._doDrawThresholds(req, rsp);
        if (notifier != null) {
            Integer tSetting = Integer.parseInt(req.getParameter("tsetting"));
            String className = req.getParameter("graph");
            PRQAGraph graph = notifier.getGraph(className);
            PRQAStatusCollection collection = new PRQAStatusCollection();
            DataSetBuilder dsb = new DataSetBuilder();
            ChartUtil.NumberOnlyBuildLabel label = null;
            Double tMax = null;
            for (PRQABuildAction prqabuild = this; prqabuild != null; prqabuild = prqabuild.getPreviousAction()) {
                if (prqabuild.getResult() == null) continue;
                label = new ChartUtil.NumberOnlyBuildLabel(prqabuild.build);
                PRQAReading stat = prqabuild.getResult();
                for (StatusCategory cat : graph.getCategories()) {
                    Number threshold;
                    Number res = null;
                    try {
                        PRQAComplianceStatus cs = (PRQAComplianceStatus)stat;
                        res = cat.equals((Object)StatusCategory.Messages) ? (Number)cs.getMessageCount(tSetting.intValue()) : (Number)stat.getReadout(cat);
                    }
                    catch (PrqaException ex) {
                        continue;
                    }
                    if (drawMatrix.containsKey(cat) && drawMatrix.get(cat).booleanValue() && (threshold = prqabuild.getThreshold(cat)) != null) {
                        if (tMax == null) {
                            tMax = threshold.doubleValue();
                        } else if (tMax < threshold.doubleValue()) {
                            tMax = threshold.doubleValue();
                        }
                        dsb.add(threshold, (Comparable)((Object)String.format("%s Threshold", cat.toString())), (Comparable)label);
                    }
                    dsb.add(res, (Comparable)((Object)cat.toString()), (Comparable)label);
                    collection.add((Object)stat);
                }
            }
            graph.setData(collection);
            graph.drawGraph(req, rsp, (DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dsb, tMax);
        }
    }
}

