/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.notifier;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.jenkins.plugin.prqa.PRQARemoteReport;
import net.praqma.jenkins.plugin.prqa.PRQARemoteToolCheck;
import net.praqma.jenkins.plugin.prqa.VersionInfo;
import net.praqma.jenkins.plugin.prqa.globalconfig.PRQAGlobalConfig;
import net.praqma.jenkins.plugin.prqa.globalconfig.QAVerifyServerConfiguration;
import net.praqma.jenkins.plugin.prqa.graphs.ComplianceIndexGraphs;
import net.praqma.jenkins.plugin.prqa.graphs.MessagesGraph;
import net.praqma.jenkins.plugin.prqa.graphs.PRQAGraph;
import net.praqma.jenkins.plugin.prqa.notifier.AbstractThreshold;
import net.praqma.jenkins.plugin.prqa.notifier.FileComplianceThreshold;
import net.praqma.jenkins.plugin.prqa.notifier.MessageComplianceThreshold;
import net.praqma.jenkins.plugin.prqa.notifier.Messages;
import net.praqma.jenkins.plugin.prqa.notifier.PRQABuildAction;
import net.praqma.jenkins.plugin.prqa.notifier.PRQAProjectAction;
import net.praqma.jenkins.plugin.prqa.notifier.PRQAReportFileListSource;
import net.praqma.jenkins.plugin.prqa.notifier.PRQAReportProjectFileSource;
import net.praqma.jenkins.plugin.prqa.notifier.PRQAReportSource;
import net.praqma.jenkins.plugin.prqa.notifier.PRQAReportSourceDescriptor;
import net.praqma.jenkins.plugin.prqa.notifier.ProjectComplianceThreshold;
import net.praqma.jenkins.plugin.prqa.notifier.ReportFileFilter;
import net.praqma.jenkins.plugin.prqa.notifier.ThresholdSelectionDescriptor;
import net.praqma.jenkins.plugin.prqa.setup.QACToolSuite;
import net.praqma.prqa.CodeUploadSetting;
import net.praqma.prqa.PRQAApplicationSettings;
import net.praqma.prqa.PRQAContext;
import net.praqma.prqa.PRQAReading;
import net.praqma.prqa.PRQAReportSettings;
import net.praqma.prqa.PRQAUploadSettings;
import net.praqma.prqa.QAVerifyServerSettings;
import net.praqma.prqa.exceptions.PrqaException;
import net.praqma.prqa.exceptions.PrqaParserException;
import net.praqma.prqa.exceptions.PrqaSetupException;
import net.praqma.prqa.exceptions.PrqaUploadException;
import net.praqma.prqa.products.Product;
import net.praqma.prqa.products.QAC;
import net.praqma.prqa.products.QACpp;
import net.praqma.prqa.products.QAR;
import net.praqma.prqa.products.QAW;
import net.praqma.prqa.reports.PRQAReport;
import net.praqma.prqa.status.PRQAComplianceStatus;
import net.praqma.prqa.status.StatusCategory;
import net.praqma.util.ExceptionUtils;
import net.praqma.util.structure.Tuple;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class PRQANotifier
extends Publisher {
    private static final Logger log = Logger.getLogger(PRQANotifier.class.getName());
    private PrintStream out;
    private List<PRQAGraph> graphTypes;
    @Deprecated
    private HashMap<StatusCategory, Number> thresholds;
    private EnumSet<PRQAContext.QARReportType> chosenReportTypes;
    public final int threshholdlevel;
    @Deprecated
    public final Boolean totalBetter;
    @Deprecated
    public final Integer totalMax;
    public final String product;
    public final String chosenServer;
    @Deprecated
    public final String settingFileCompliance;
    @Deprecated
    public final String settingMaxMessages;
    @Deprecated
    public final String settingProjectCompliance;
    @Deprecated
    public final Double fileComplianceIndex;
    @Deprecated
    public final Double projectComplianceIndex;
    public final String projectFile;
    public final String vcsConfigXml;
    public final boolean performCrossModuleAnalysis;
    public final boolean publishToQAV;
    public final boolean singleSnapshotMode;
    public final boolean enableDependencyMode;
    public final boolean enableDataFlowAnalysis;
    @Deprecated
    public final boolean generateReports;
    private CodeUploadSetting codeUploadSetting = CodeUploadSetting.None;
    public final String sourceOrigin;
    public final String qaVerifyProjectName;
    public final PRQAReportSource source;
    public final List<AbstractThreshold> thresholdsDesc;

    @DataBoundConstructor
    public PRQANotifier(String product, boolean totalBetter, String totalMax, String fileComplianceIndex, String projectComplianceIndex, String settingMaxMessages, String settingFileCompliance, String settingProjectCompliance, String projectFile, boolean performCrossModuleAnalysis, boolean publishToQAV, String qaVerifyProjectName, String vcsConfigXml, boolean singleSnapshotMode, String snapshotName, String chosenServer, boolean enableDependencyMode, String codeUploadSetting, String msgConfigFile, boolean generateReports, String sourceOrigin, EnumSet<PRQAContext.QARReportType> chosenReportTypes, boolean enableDataFlowAnalysis, int threshholdlevel, PRQAReportSource source, List<AbstractThreshold> thresholdsDesc) {
        this.product = product;
        this.totalBetter = totalBetter;
        this.totalMax = PRQANotifier.parseIntegerNullDefault(totalMax);
        this.fileComplianceIndex = PRQANotifier.parseDoubleNullDefault(fileComplianceIndex);
        this.projectComplianceIndex = PRQANotifier.parseDoubleNullDefault(projectComplianceIndex);
        this.settingProjectCompliance = settingProjectCompliance;
        this.settingMaxMessages = settingMaxMessages;
        this.settingFileCompliance = settingFileCompliance;
        this.projectFile = projectFile;
        this.publishToQAV = publishToQAV;
        this.performCrossModuleAnalysis = performCrossModuleAnalysis;
        this.vcsConfigXml = vcsConfigXml;
        this.singleSnapshotMode = singleSnapshotMode;
        this.qaVerifyProjectName = qaVerifyProjectName;
        this.chosenServer = chosenServer;
        this.enableDependencyMode = enableDependencyMode;
        this.codeUploadSetting = CodeUploadSetting.getByValue((String)codeUploadSetting);
        this.sourceOrigin = sourceOrigin;
        this.chosenReportTypes = chosenReportTypes;
        this.enableDataFlowAnalysis = enableDataFlowAnalysis;
        this.threshholdlevel = threshholdlevel;
        this.source = source;
        this.generateReports = generateReports;
        this.thresholdsDesc = thresholdsDesc;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new PRQAProjectAction(project);
    }

    @Deprecated
    private static Integer parseIntegerNullDefault(String value) {
        try {
            if (value == null || value.equals("")) {
                return null;
            }
            Integer parsed = Integer.parseInt(value);
            return parsed;
        }
        catch (NumberFormatException nex) {
            return null;
        }
    }

    @Deprecated
    private static Double parseDoubleNullDefault(String value) {
        try {
            if (value == null || value.equals("")) {
                return null;
            }
            Double parsed = Double.parseDouble(value);
            return parsed;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    private void copyReourcesToArtifactsDir(String pattern, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        FilePath[] files = build.getWorkspace().list("**/" + pattern);
        if (files.length >= 1) {
            for (int i = 0; i < files.length; ++i) {
                String artifactDir = build.getArtifactsDir().getPath();
                FilePath targetDir = new FilePath(new File(artifactDir + "/" + files[i].getName()));
                files[i].copyTo(targetDir);
                this.out.println(Messages.PRQANotifier_SuccesFileCopy(files[i].getName()));
            }
        }
    }

    private boolean evaluate(PRQAReading previousResult, List<? extends AbstractThreshold> thresholds, PRQAComplianceStatus status) {
        PRQAComplianceStatus previousComplianceStatus = (PRQAComplianceStatus)previousResult;
        HashMap<StatusCategory, Number> tholds = new HashMap<StatusCategory, Number>();
        boolean isStable = true;
        for (AbstractThreshold abstractThreshold : thresholds) {
            this.addThreshold(abstractThreshold, tholds);
            if (abstractThreshold.validate(previousComplianceStatus, status, this.threshholdlevel).booleanValue()) continue;
            status.addNotification(abstractThreshold.onUnstableMessage(previousComplianceStatus, status, this.threshholdlevel));
            isStable = false;
        }
        status.setThresholds(tholds);
        return isStable;
    }

    @Deprecated
    private boolean evaluateOld(String settingProjectCompliance, String settingMaxMessages, String settingFileCompliance, Integer totalMax, Double fileComplianceIndex, Double projectComplianceIndex, PRQAReading lar, PRQAComplianceStatus status, int threshholdlevel) {
        boolean res = false;
        PRQAContext.ComparisonSettings fileCompliance = PRQAContext.ComparisonSettings.valueOf((String)settingFileCompliance);
        PRQAContext.ComparisonSettings projCompliance = PRQAContext.ComparisonSettings.valueOf((String)settingProjectCompliance);
        PRQAContext.ComparisonSettings maxMsg = PRQAContext.ComparisonSettings.valueOf((String)settingMaxMessages);
        try {
            Double currentFileCompliance = status.getReadout(StatusCategory.ProjectCompliance).doubleValue();
            if (fileCompliance == PRQAContext.ComparisonSettings.Improvement) {
                if (lar != null) {
                    Double previous = lar.getReadout(StatusCategory.FileCompliance).doubleValue();
                    if (currentFileCompliance < previous) {
                        status.addNotification(Messages.PRQANotifier_ProjectComplianceIndexRequirementNotMet(currentFileCompliance, previous));
                        res = false;
                    }
                }
            } else if (fileCompliance == PRQAContext.ComparisonSettings.Threshold && currentFileCompliance < fileComplianceIndex) {
                status.addNotification(Messages.PRQANotifier_FileComplianceRequirementNotMet(currentFileCompliance, fileComplianceIndex));
                res = false;
            }
            Double currentProjecCompliance = status.getReadout(StatusCategory.ProjectCompliance).doubleValue();
            if (projCompliance == PRQAContext.ComparisonSettings.Threshold) {
                if (currentProjecCompliance < projectComplianceIndex) {
                    status.addNotification(Messages.PRQANotifier_ProjectComplianceIndexRequirementNotMet(currentProjecCompliance, projectComplianceIndex));
                    res = false;
                }
            } else if (projCompliance == PRQAContext.ComparisonSettings.Improvement && lar != null) {
                Double previous = lar.getReadout(StatusCategory.ProjectCompliance).doubleValue();
                if (currentProjecCompliance < previous) {
                    status.addNotification(Messages.PRQANotifier_ProjectComplianceIndexRequirementNotMet(currentProjecCompliance, previous));
                    res = false;
                }
            }
            int current = status.getMessageCount(threshholdlevel);
            if (maxMsg == PRQAContext.ComparisonSettings.Improvement) {
                int previous;
                if (lar != null && current > (previous = ((PRQAComplianceStatus)lar).getMessageCount(threshholdlevel))) {
                    status.addNotification(Messages.PRQANotifier_MaxMessagesRequirementNotMet(current, previous));
                    res = false;
                }
            } else if (maxMsg == PRQAContext.ComparisonSettings.Threshold && current > totalMax) {
                status.addNotification(Messages.PRQANotifier_MaxMessagesRequirementNotMet(current, totalMax));
                res = false;
            }
        }
        catch (PrqaException ex) {
            this.out.println("Report generation ok. Caught exception evaluation results. Trace written to log");
            log.log(Level.SEVERE, "Storing unexpected result evalution exception", ex);
        }
        return res;
    }

    private void addThreshold(AbstractThreshold threshold, HashMap<StatusCategory, Number> tholds) {
        if (threshold instanceof ProjectComplianceThreshold) {
            tholds.put(StatusCategory.ProjectCompliance, ((ProjectComplianceThreshold)threshold).value);
        } else if (threshold instanceof FileComplianceThreshold) {
            tholds.put(StatusCategory.FileCompliance, ((FileComplianceThreshold)threshold).value);
        } else {
            tholds.put(StatusCategory.Messages, ((MessageComplianceThreshold)threshold).value);
        }
    }

    private void copyReportsToArtifactsDir(PRQAReportSettings settings, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        for (PRQAContext.QARReportType type : settings.chosenReportTypes) {
            String pattern = "**/" + PRQAReport.getNamingTemplate((PRQAContext.QARReportType)type, (String)PRQAReport.XHTML_REPORT_EXTENSION);
            FilePath[] files = build.getWorkspace().list(pattern);
            if (files.length < 1) continue;
            this.out.println(Messages.PRQANotifier_FoundReport(PRQAReport.getNamingTemplate((PRQAContext.QARReportType)type, (String)PRQAReport.XHTML_REPORT_EXTENSION)));
            String artifactDir = build.getArtifactsDir().getPath();
            FilePath targetDir = new FilePath(new File(artifactDir + "/" + PRQAReport.getNamingTemplate((PRQAContext.QARReportType)type, (String)PRQAReport.XHTML_REPORT_EXTENSION)));
            this.out.println(Messages.PRQANotifier_CopyToTarget(targetDir.getName()));
            build.getWorkspace().list("**/" + PRQAReport.getNamingTemplate((PRQAContext.QARReportType)type, (String)PRQAReport.XHTML_REPORT_EXTENSION))[0].copyTo(targetDir);
            this.out.println(Messages.PRQANotifier_SuccesCopyReport());
        }
    }

    public List<PRQAGraph> getSupportedGraphs() {
        ArrayList<PRQAGraph> graphs = new ArrayList<PRQAGraph>();
        for (PRQAGraph g : this.graphTypes) {
            if (!g.getType().equals((Object)PRQAContext.QARReportType.Compliance)) continue;
            graphs.add(g);
        }
        return graphs;
    }

    public PRQAGraph getGraph(String simpleClassName) {
        for (PRQAGraph p : this.getSupportedGraphs()) {
            if (!p.getClass().getSimpleName().equals(simpleClassName)) continue;
            return p;
        }
        return null;
    }

    public PRQAGraph getGraph(Class clazz, List<PRQAGraph> graphs) {
        for (PRQAGraph p : graphs) {
            if (!p.getClass().equals(clazz)) continue;
            return p;
        }
        return null;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        try {
            List files = build.getWorkspace().list((FileFilter)new ReportFileFilter());
            int numberOfReportFiles = build.getWorkspace().list((FileFilter)new ReportFileFilter()).size();
            if (numberOfReportFiles > 0) {
                listener.getLogger().println(String.format("Found %s report fragments, cleaning up", numberOfReportFiles));
            }
            int deleteCounter = 0;
            for (FilePath f : files) {
                f.delete();
                ++deleteCounter;
            }
            if (deleteCounter > 0) {
                listener.getLogger().println(String.format("Succesfully deleted %s report fragments", deleteCounter));
            }
        }
        catch (IOException ex) {
            listener.getLogger().println("Failed to clean up stale report files");
            log.log(Level.SEVERE, "Cleanup crew missing!", ex);
        }
        catch (InterruptedException ex) {
            listener.getLogger().println("Failed to clean up stale report files");
            log.log(Level.SEVERE, "Cleanup crew missing!", ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String productUsed = this.product;
        this.out = listener.getLogger();
        QACToolSuite suite = null;
        QACToolSuite qacSuite = QACToolSuite.getInstallationByName(this.product);
        this.out.println(VersionInfo.getPluginVersion());
        if (qacSuite != null) {
            productUsed = qacSuite.tool;
            suite = qacSuite;
        }
        QAVerifyServerConfiguration conf = PRQAGlobalConfig.get().getConfigurationByName(this.chosenServer);
        PRQAApplicationSettings appSettings = null;
        if (suite != null && suite instanceof QACToolSuite) {
            QACToolSuite cSuite = suite;
            appSettings = new PRQAApplicationSettings(cSuite.qarHome, cSuite.qavHome, cSuite.qawHome, cSuite.getHome());
        }
        PRQAReportSettings settings = null;
        QAR qar = null;
        if (this.source != null && this.source instanceof PRQAReportProjectFileSource) {
            PRQAReportProjectFileSource pSource = (PRQAReportProjectFileSource)this.source;
            settings = new PRQAReportSettings(this.chosenServer, pSource.projectFile, this.performCrossModuleAnalysis, this.publishToQAV, this.enableDependencyMode, this.enableDataFlowAnalysis, this.chosenReportTypes, productUsed);
            qar = new QAR(productUsed, pSource.projectFile, PRQAContext.QARReportType.Compliance);
        } else if (this.source != null && this.source instanceof PRQAReportFileListSource) {
            PRQAReportFileListSource flSource = (PRQAReportFileListSource)this.source;
            settings = new PRQAReportSettings(this.chosenServer, flSource.fileList, this.performCrossModuleAnalysis, this.publishToQAV, this.enableDependencyMode, this.enableDataFlowAnalysis, this.chosenReportTypes, productUsed, flSource.settingsFile);
            qar = new QAR(productUsed, flSource.fileList, PRQAContext.QARReportType.Compliance);
        } else {
            settings = new PRQAReportSettings(this.chosenServer, this.projectFile, this.performCrossModuleAnalysis, this.publishToQAV, this.enableDependencyMode, this.enableDataFlowAnalysis, this.chosenReportTypes, productUsed);
            qar = new QAR(productUsed, this.projectFile, PRQAContext.QARReportType.Compliance);
        }
        this.out.println(Messages.PRQANotifier_ReportGenerateText());
        this.out.println(qar);
        PRQAUploadSettings uploadSettings = new PRQAUploadSettings(this.vcsConfigXml, this.singleSnapshotMode, this.codeUploadSetting, this.sourceOrigin, this.qaVerifyProjectName);
        QAVerifyServerSettings qavSettings = null;
        if (conf != null) {
            qavSettings = new QAVerifyServerSettings(conf.getHostName(), conf.getPortNumber().intValue(), conf.getProtocol(), conf.getPassword(), conf.getUserName());
        }
        HashMap<String, String> environment = null;
        if (suite != null) {
            environment = suite.createEnvironmentVariables(build.getWorkspace().getRemote());
        }
        boolean success = true;
        PRQAComplianceStatus status = null;
        try {
            if (qacSuite == null && !productUsed.equalsIgnoreCase("qacpp") && !productUsed.equalsIgnoreCase("qac")) {
                throw new PrqaSetupException(String.format("The job uses a product configuration (%s) that no longer exists, please reconfigure.", productUsed));
            }
            PRQAReport report = new PRQAReport(settings, qavSettings, uploadSettings, appSettings, environment);
            if (productUsed.equalsIgnoreCase("qac")) {
                String qacVersion = (String)build.getWorkspace().act((FilePath.FileCallable)new PRQARemoteToolCheck((Product)new QAC(), environment, appSettings, settings, listener, launcher.isUnix()));
                this.out.println("QA\u00b7C OK - " + qacVersion);
            } else if (productUsed.equalsIgnoreCase("qacpp")) {
                String qacppVersion = (String)build.getWorkspace().act((FilePath.FileCallable)new PRQARemoteToolCheck((Product)new QACpp(), environment, appSettings, settings, listener, launcher.isUnix()));
                this.out.println("QA\u00b7C++ OK - " + qacppVersion);
            }
            String qawVersion = (String)build.getWorkspace().act((FilePath.FileCallable)new PRQARemoteToolCheck((Product)new QAW(), environment, appSettings, settings, listener, launcher.isUnix()));
            this.out.println("QAW OK - " + qawVersion);
            String qarVersion = (String)build.getWorkspace().act((FilePath.FileCallable)new PRQARemoteToolCheck((Product)qar, environment, appSettings, settings, listener, launcher.isUnix()));
            this.out.println("QAR OK - " + qarVersion);
            status = (PRQAComplianceStatus)build.getWorkspace().act((FilePath.FileCallable)new PRQARemoteReport(report, listener, launcher.isUnix()));
            status.setMessagesWithinThreshold(status.getMessageCount(this.threshholdlevel));
        }
        catch (IOException ex) {
            Throwable myCase = ExceptionUtils.unpackFrom(IOException.class, (Throwable)ex);
            if (myCase instanceof PrqaSetupException) {
                this.out.println(String.format("Most likely cause is a misconfigured tool, refer to documentation (%s) on how to configure them.", "https://wiki.jenkins-ci.org/display/JENKINS/PRQA+Plugin"));
                this.out.println(myCase.getMessage());
                log.log(Level.SEVERE, "Logging PrqaSetupException", myCase);
            } else if (myCase instanceof PrqaUploadException) {
                this.out.println("Upload failed");
                this.out.println(myCase.getMessage());
                log.log(Level.SEVERE, "Logging PrqaUploadException", myCase);
            } else if (myCase instanceof PrqaParserException) {
                this.out.println(myCase.getMessage());
                log.log(Level.SEVERE, "Logging PrqaException", myCase);
            } else if (myCase instanceof PrqaException) {
                this.out.println(myCase.getMessage());
                log.log(Level.SEVERE, "Logging PrqaException", ex);
            }
            success = false;
            boolean qarVersion = false;
            return qarVersion;
        }
        catch (PrqaException pex) {
            this.out.println(pex.getMessage());
            log.log(Level.WARNING, "PrqaException", pex);
        }
        catch (Exception ex) {
            this.out.println(Messages.PRQANotifier_FailedGettingResults());
            this.out.println("This should not be happinging, writing error to log");
            log.log(Level.SEVERE, "Unhandled exception", ex);
            boolean myCase = false;
            return myCase;
        }
        finally {
            try {
                if (success) {
                    this.copyReportsToArtifactsDir(settings, build);
                }
                if (this.publishToQAV && success) {
                    this.copyReourcesToArtifactsDir("*.log", build);
                }
            }
            catch (Exception ex) {
                this.out.println("Error in copying artifacts to artifact dir");
                log.log(Level.SEVERE, "Failed copying build artifacts", ex);
            }
        }
        if (status == null) {
            this.out.println(Messages.PRQANotifier_FailedGettingResults());
            return false;
        }
        Tuple<PRQAReading, AbstractBuild<?, ?>> previousResult = this.getPreviousReading(build, Result.SUCCESS);
        if (previousResult != null) {
            this.out.println(String.format(Messages.PRQANotifier_PreviousResultBuildNumber(new Integer(((AbstractBuild)previousResult.getSecond()).number)), new Object[0]));
            this.out.println(previousResult.getFirst());
        } else {
            this.out.println(Messages.PRQANotifier_NoPreviousResults());
        }
        PRQAReading lar = previousResult != null ? (PRQAReading)previousResult.getFirst() : null;
        boolean res = true;
        log.fine("settingsProjectCompliance is null: " + (this.settingProjectCompliance == null));
        log.fine("settingMaxMessages is null: " + (this.settingMaxMessages == null));
        log.fine("settingFileCompliance is null: " + (this.settingFileCompliance == null));
        log.fine("thresholdsDesc is null: " + (this.thresholdsDesc == null));
        if (this.thresholdsDesc != null) {
            log.fine("thresholdsDescSize: " + this.thresholdsDesc.size());
        }
        try {
            if (this.settingProjectCompliance != null && this.settingMaxMessages != null && this.settingFileCompliance != null && (this.thresholdsDesc == null || this.thresholdsDesc.isEmpty())) {
                res = this.evaluateOld(this.settingProjectCompliance, this.settingMaxMessages, this.settingFileCompliance, this.totalMax, this.fileComplianceIndex, this.projectComplianceIndex, lar, status, this.threshholdlevel);
            } else {
                res = this.evaluate((PRQAReading)status, this.thresholdsDesc, status);
                log.fine("Evaluated to: " + res);
            }
        }
        catch (Exception ex) {
            this.out.println("Report generation ok. Caught exception evaluation results. Trace written to log");
            log.log(Level.SEVERE, "Storing unexpected result evalution exception", ex);
        }
        this.out.println(Messages.PRQANotifier_ScannedValues());
        this.out.println(status);
        PRQABuildAction action = new PRQABuildAction(build);
        action.setResult((PRQAReading)status);
        action.setPublisher(this);
        if (!res) {
            build.setResult(Result.UNSTABLE);
        }
        build.getActions().add(action);
        return true;
    }

    private Tuple<PRQAReading, AbstractBuild<?, ?>> getPreviousReading(AbstractBuild<?, ?> currentBuild, Result expectedResult) {
        Tuple result = null;
        AbstractBuild iterate = currentBuild;
        do {
            if ((iterate = (AbstractBuild)iterate.getPreviousNotFailedBuild()) == null || iterate.getAction(PRQABuildAction.class) == null || !iterate.getResult().equals(expectedResult)) continue;
            result = new Tuple();
            result.setSecond((Object)iterate);
            result.setFirst((Object)((PRQABuildAction)iterate.getAction(PRQABuildAction.class)).getResult());
            return result;
        } while (iterate != null);
        return result;
    }

    @Exported
    public Integer getTotalMax() {
        return this.totalMax;
    }

    @Exported
    public void setGraphTypes(List<PRQAGraph> graphTypes) {
        this.graphTypes = graphTypes;
    }

    @Exported
    public List<PRQAGraph> getGraphTypes() {
        return this.graphTypes;
    }

    public CodeUploadSetting getCodeUploadSetting() {
        return this.codeUploadSetting;
    }

    public void setCodeUploadSetting(String codeUploadSetting) {
        this.codeUploadSetting = CodeUploadSetting.valueOf((String)codeUploadSetting);
    }

    public EnumSet<PRQAContext.QARReportType> getChosenReportTypes() {
        return this.chosenReportTypes;
    }

    public void setChosenReportTypes(EnumSet<PRQAContext.QARReportType> chosenReportTypes) {
        this.chosenReportTypes = chosenReportTypes;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public List<ThresholdSelectionDescriptor<?>> getThresholdSelections() {
            return AbstractThreshold.getDescriptors();
        }

        public FormValidation doCheckVcsConfigXml(@QueryParameter String value) {
            try {
                if (value.endsWith(".xml") || StringUtils.isBlank((String)value)) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)Messages.PRQANotifier_MustEndWithDotXml());
            }
            catch (Exception ex) {
                return FormValidation.error((String)Messages.PRQANotifier_IllegalVcsString());
            }
        }

        public FormValidation doCheckMsgConfigFile(@QueryParameter String value) {
            try {
                if (value.endsWith(".xml") || StringUtils.isBlank((String)value)) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)Messages.PRQANotifier_MustEndWithDotXml());
            }
            catch (Exception ex) {
                return FormValidation.error((String)Messages.PRQANotifier_IllegalVcsString());
            }
        }

        public String getDisplayName() {
            return "Programming Research Report";
        }

        public ListBoxModel doFillThreshholdlevelItems() {
            ListBoxModel model = new ListBoxModel();
            for (int i = 0; i < 10; ++i) {
                model.add("" + i);
            }
            return model;
        }

        public boolean isApplicable(Class<? extends AbstractProject> arg0) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            PRQANotifier instance = (PRQANotifier)((Object)req.bindJSON(PRQANotifier.class, formData));
            JSONArray arr = formData.getJSONArray("chosenReport");
            PRQAContext.QARReportType[] types = this.getOptionalReportTypes().toArray(new PRQAContext.QARReportType[this.getOptionalReportTypes().size()]);
            instance.setChosenReportTypes((EnumSet<PRQAContext.QARReportType>)PRQAContext.QARReportType.REQUIRED_TYPES.clone());
            for (int i = 0; i < arr.size(); ++i) {
                if (!arr.getBoolean(i)) continue;
                instance.chosenReportTypes.add(types[i]);
            }
            instance.chosenReportTypes.add(PRQAContext.QARReportType.Compliance);
            if (instance.getGraphTypes() == null || instance.getGraphTypes().isEmpty()) {
                ArrayList<PRQAGraph> list = new ArrayList<PRQAGraph>();
                list.add(new ComplianceIndexGraphs());
                list.add(new MessagesGraph());
                instance.setGraphTypes(list);
            }
            this.save();
            return instance;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return super.configure(req, json);
        }

        public DescriptorImpl() {
            super(PRQANotifier.class);
            this.load();
        }

        public List<QACToolSuite> getQacTools() {
            QACToolSuite[] prqaInstallations = (QACToolSuite[])((QACToolSuite.DescriptorImpl)Hudson.getInstance().getDescriptorByType(QACToolSuite.DescriptorImpl.class)).getInstallations();
            return Arrays.asList(prqaInstallations);
        }

        public List<PRQAReportSourceDescriptor<?>> getReportSources() {
            return PRQAReportSource.getDescriptors();
        }

        public List<QAVerifyServerConfiguration> getServers() {
            return PRQAGlobalConfig.get().getServers();
        }

        public CodeUploadSetting[] getUploadSettings() {
            return CodeUploadSetting.values();
        }

        public EnumSet<PRQAContext.QARReportType> getOptionalReportTypes() {
            return PRQAContext.QARReportType.OPTIONAL_TYPES;
        }

        public ListBoxModel doFillProductItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("QA\u00b7C", "qac");
            model.add("QA\u00b7C++", "qacpp");
            for (QACToolSuite suite : this.getQacTools()) {
                model.add(suite.getName());
            }
            return model;
        }
    }
}

