/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.notifier;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.ProminentProjectAction;
import hudson.util.DescribableList;
import java.io.IOException;
import net.praqma.jenkins.plugin.prqa.globalconfig.PRQAGlobalConfig;
import net.praqma.jenkins.plugin.prqa.globalconfig.QAVerifyServerConfiguration;
import net.praqma.jenkins.plugin.prqa.notifier.PRQABuildAction;
import net.praqma.jenkins.plugin.prqa.notifier.PRQANotifier;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PRQAProjectAction
extends Actionable
implements ProminentProjectAction {
    private final AbstractProject<?, ?> project;
    private static final String ICON_NAME = "/plugin/prqa-plugin/images/32x32/prqa.png";

    public PRQAProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getDisplayName() {
        return "PRQA Results";
    }

    public String getSearchUrl() {
        return "PRQA";
    }

    public String getIconFileName() {
        return ICON_NAME;
    }

    public String getUrlName() {
        return "PRQA";
    }

    public PRQABuildAction getLatestActionInProject() {
        if (this.project.getLastSuccessfulBuild() != null) {
            return (PRQABuildAction)((AbstractBuild)this.project.getLastSuccessfulBuild()).getAction(PRQABuildAction.class);
        }
        return null;
    }

    public boolean isDrawGraphs() {
        return this.project.getBuilds().size() >= 2;
    }

    public void doReportGraphs(StaplerRequest req, StaplerResponse rsp) {
        PRQABuildAction action = this.getLatestActionInProject();
        if (action != null) {
            try {
                action.doReportGraphs(req, rsp);
            }
            catch (IOException exception) {
                // empty catch block
            }
        }
    }

    public QAVerifyServerConfiguration getConfiguration() {
        DescribableList publishersList = this.project.getPublishersList();
        PRQANotifier notifier = (PRQANotifier)publishersList.get(PRQANotifier.class);
        if (notifier != null) {
            QAVerifyServerConfiguration qavconfig = PRQAGlobalConfig.get().getConfigurationByName(notifier.chosenServer);
            return qavconfig;
        }
        return null;
    }
}

