/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.notifier;

import hudson.Extension;
import hudson.util.FormValidation;
import net.praqma.jenkins.plugin.prqa.notifier.AbstractThreshold;
import net.praqma.jenkins.plugin.prqa.notifier.Messages;
import net.praqma.jenkins.plugin.prqa.notifier.ThresholdSelectionDescriptor;
import net.praqma.prqa.status.PRQAComplianceStatus;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ProjectComplianceThreshold
extends AbstractThreshold {
    public final Double value;

    @DataBoundConstructor
    public ProjectComplianceThreshold(Double value, Boolean improvement) {
        super(improvement);
        this.value = value;
    }

    @Override
    public Boolean validateImprovement(PRQAComplianceStatus lastStableValue, PRQAComplianceStatus currentValue, int thresholdLevel) {
        if (lastStableValue == null) {
            return Boolean.TRUE;
        }
        return currentValue.getProjectCompliance() >= lastStableValue.getProjectCompliance();
    }

    @Override
    public String onUnstableMessage(PRQAComplianceStatus lastStableValue, PRQAComplianceStatus currentValue, int thresholdLevel) {
        if (this.improvement.booleanValue()) {
            return Messages.PRQANotifier_ProjectComplianceIndexRequirementNotMet(currentValue.getProjectCompliance(), lastStableValue.getProjectCompliance());
        }
        return Messages.PRQANotifier_ProjectComplianceIndexRequirementNotMet(currentValue.getProjectCompliance(), this.value);
    }

    @Override
    public Boolean validateThreshold(PRQAComplianceStatus currentValue, int thresholdLevel) {
        return currentValue.getProjectCompliance() >= this.value;
    }

    @Extension
    public static final class DescriptorImpl
    extends ThresholdSelectionDescriptor<ProjectComplianceThreshold> {
        public String getDisplayName() {
            return "Project Compliance Threshold";
        }

        public FormValidation doCheckValue(@QueryParameter String value) {
            try {
                Double parsedValue = Double.parseDouble(value);
                if (parsedValue < 0.0) {
                    return FormValidation.error((String)Messages.PRQANotifier_WrongDecimalValue());
                }
            }
            catch (NumberFormatException ex) {
                return FormValidation.error((String)Messages.PRQANotifier_WrongDecimalPunctuation());
            }
            return FormValidation.ok();
        }

        public String getHelpFile() {
            return "/plugin/prqa-plugin/config/help-thresholds.html";
        }
    }
}

