/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.setup;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.HashMap;
import jenkins.model.Jenkins;
import net.praqma.jenkins.plugin.prqa.setup.PRQAToolSuite;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class QACToolSuite
extends ToolInstallation
implements PRQAToolSuite {
    public final String qarHome;
    public final String qawHome;
    public final String qavHome;
    public final String tool;

    @DataBoundConstructor
    public QACToolSuite(String name, String home, String qarHome, String qawHome, String qavHome, String tool) {
        super(name, home);
        this.qarHome = qarHome;
        this.qawHome = qawHome;
        this.qavHome = qavHome;
        this.tool = tool;
    }

    @Override
    public HashMap<String, String> createEnvironmentVariables(String workspaceRoot) {
        HashMap<String, String> environment = null;
        if (this.tool.equals("qac")) {
            environment = new HashMap<String, String>();
            environment.put("QACPATH", this.getHome());
            environment.put("QACOUTPATH", workspaceRoot);
        } else if (this.tool.equals("qacpp")) {
            environment = new HashMap();
            environment.put("QACPPPATH", this.getHome());
            environment.put("QACPPOUTPATH", workspaceRoot);
        }
        return environment;
    }

    public HashMap<String, String> convert(EnvVars vars) {
        HashMap<String, String> varsMap = new HashMap<String, String>();
        for (String s : vars.keySet()) {
            varsMap.put(s, (String)vars.get((Object)s));
        }
        return varsMap;
    }

    public static QACToolSuite getInstallationByName(String name) {
        QACToolSuite[] installations;
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        for (QACToolSuite install : installations = (QACToolSuite[])((DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class)).getInstallations()) {
            if (!install.getName().equals(name)) continue;
            return install;
        }
        return null;
    }

    public static QACToolSuite[] getInstallations() {
        QACToolSuite[] installations = (QACToolSuite[])((DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class)).getInstallations();
        return installations;
    }

    @Extension
    public static final class DescriptorImpl
    extends ToolDescriptor<QACToolSuite> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "PRQA Tool";
        }

        public QACToolSuite newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            QACToolSuite suite = (QACToolSuite)req.bindJSON(QACToolSuite.class, formData);
            this.save();
            return suite;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return super.configure(req, json);
        }

        public ListBoxModel doFillToolItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("QA\u00b7C", "qac");
            model.add("QA\u00b7C++", "qacpp");
            return model;
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            if (StringUtils.isBlank((String)name)) {
                return FormValidation.errorWithMarkup((String)"Installation name should not be empty.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckHome(@QueryParameter String home) {
            if (StringUtils.isBlank((String)home)) {
                return FormValidation.errorWithMarkup((String)"Product installation path should not be empty.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckQarHome(@QueryParameter String qarHome) {
            if (StringUtils.isBlank((String)qarHome)) {
                return FormValidation.errorWithMarkup((String)"QAR Home should not be empty.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckQawHome(@QueryParameter String qawHome) {
            if (StringUtils.isBlank((String)qawHome)) {
                return FormValidation.errorWithMarkup((String)"QAW Home should not be empty.");
            }
            return FormValidation.ok();
        }
    }
}

