/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import net.revelc.code.formatter.FormatterMojo;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jface.text.BadLocationException;

@Mojo(name="validate", defaultPhase=LifecyclePhase.VALIDATE, requiresProject=true, threadSafe=true)
public class ValidateMojo
extends FormatterMojo {
    @Parameter(defaultValue="false", property="aggregator", required=true)
    private boolean aggregator;
    @Parameter(defaultValue="${project.executionRoot}", required=true)
    private boolean executionRoot;
    @Parameter(defaultValue="${mojo.groupId}", required=true, readonly=true)
    private String mojoGroupId;
    @Parameter(defaultValue="${mojo.artifactId}", required=true, readonly=true)
    private String mojoArtifactId;
    @Parameter(defaultValue="${mojo.version}", required=true, readonly=true)
    private String mojoVersion;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.aggregator && !this.executionRoot) {
            return;
        }
        super.execute();
    }

    @Override
    protected void doFormatFile(File file, FormatterMojo.ResultCollector rc, Properties hashCache, String basedirPath, boolean dryRun) throws IOException, MojoFailureException, BadLocationException, MojoExecutionException {
        super.doFormatFile(file, rc, hashCache, basedirPath, true);
        if (rc.successCount != 0) {
            String errorMessage = String.format("File '%s' has not been previously formatted. Please format file (for example by invoking `%s`) and commit before running validation!", file, this.formatCommand());
            throw new MojoFailureException(errorMessage);
        }
        if (rc.failCount != 0) {
            throw new MojoExecutionException("Error formatting '" + file + "' ");
        }
    }

    private String formatCommand() {
        String mojoInvocation = String.format("%s:%s:%s:%s", this.mojoGroupId, this.mojoArtifactId, this.mojoVersion, "format");
        boolean isMultiModule = this.mavenSession.getAllProjects().size() > 1;
        Path moduleDir = Path.of(".", new String[0]).toAbsolutePath().relativize(this.mavenProject.getBasedir().toPath().toAbsolutePath());
        String specifyModule = isMultiModule ? String.format("-f %s", moduleDir) : "";
        return String.format("mvn %s %s", specifyModule, mojoInvocation).replace("  ", " ");
    }
}

