/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.jhlabs.image.BoxBlurFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.screenshots.BlurLevel;
import net.thucydides.core.screenshots.QueuedScreenshot;
import net.thucydides.core.screenshots.ScreenshotDigest;
import net.thucydides.core.screenshots.ScreenshotProcessor;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.ProvidedDriverConfiguration;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Photographer {
    private final WebDriver driver;
    private final File targetDirectory;
    private Optional<BlurLevel> blurLevel;
    private final Logger logger = LoggerFactory.getLogger(Photographer.class);
    private ScreenshotProcessor screenshotProcessor;
    private EnvironmentVariables environmentVariables;

    protected Logger getLogger() {
        return this.logger;
    }

    public Photographer(WebDriver driver, File targetDirectory) {
        this(driver, targetDirectory, (ScreenshotProcessor)Injectors.getInjector().getInstance(ScreenshotProcessor.class), null);
    }

    public Photographer(WebDriver driver, File targetDirectory, BlurLevel blurLevel) {
        this(driver, targetDirectory, (ScreenshotProcessor)Injectors.getInjector().getInstance(ScreenshotProcessor.class), blurLevel);
    }

    public Photographer(WebDriver driver, File targetDirectory, ScreenshotProcessor screenshotProcessor) {
        this(driver, targetDirectory, screenshotProcessor, null);
    }

    public Photographer(WebDriver driver, File targetDirectory, ScreenshotProcessor screenshotProcessor, BlurLevel blurLevel) {
        this(driver, targetDirectory, screenshotProcessor, blurLevel, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public Photographer(WebDriver driver, File targetDirectory, ScreenshotProcessor screenshotProcessor, BlurLevel blurLevel, EnvironmentVariables environmentVariables) {
        Preconditions.checkNotNull((Object)targetDirectory);
        Preconditions.checkNotNull((Object)screenshotProcessor);
        this.driver = driver;
        this.targetDirectory = targetDirectory;
        this.screenshotProcessor = screenshotProcessor;
        this.blurLevel = Optional.fromNullable((Object)((Object)blurLevel));
        this.environmentVariables = environmentVariables;
    }

    public Optional<BlurLevel> getBlurLevel() {
        return this.blurLevel;
    }

    public Optional<File> takeScreenshot() {
        if (this.driver != null && this.driverCanTakeSnapshots()) {
            try {
                File screenshotTempFile = null;
                Object capturedScreenshot = ((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
                if (this.isAFile(capturedScreenshot)) {
                    screenshotTempFile = this.copyScreenshotWorkingCopyFrom((File)capturedScreenshot);
                } else if (this.isByteArray(capturedScreenshot)) {
                    screenshotTempFile = this.saveScreenshotData((byte[])capturedScreenshot);
                }
                if (screenshotTempFile != null && this.blurLevel.isPresent()) {
                    screenshotTempFile = this.blur(screenshotTempFile);
                }
                if (screenshotTempFile != null) {
                    String storedFilename = this.getDigestScreenshotNameFor(screenshotTempFile);
                    File savedScreenshot = this.targetScreenshot(storedFilename);
                    if (!Files.exists(savedScreenshot.toPath(), new LinkOption[0])) {
                        this.screenshotProcessor.queueScreenshot(new QueuedScreenshot(screenshotTempFile, savedScreenshot));
                    }
                    return Optional.of((Object)savedScreenshot);
                }
            }
            catch (Throwable e) {
                this.getLogger().warn("Failed to write screenshot (possibly an out of memory error): ", e);
            }
        }
        return Optional.absent();
    }

    private File copyScreenshotWorkingCopyFrom(File capturedScreenshot) throws IOException {
        Path temporaryScreenshotFile = Files.createTempFile("screenshot", "", new FileAttribute[0]);
        Files.copy(capturedScreenshot.toPath(), temporaryScreenshotFile, StandardCopyOption.REPLACE_EXISTING);
        return temporaryScreenshotFile.toFile();
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    private String getDigestScreenshotNameFor(File screenshotTempFile) throws IOException {
        ScreenshotDigest screenshotDigest = new ScreenshotDigest(this.environmentVariables, (BlurLevel)((Object)this.blurLevel.orNull()));
        return screenshotDigest.forScreenshot(screenshotTempFile);
    }

    protected File blur(File srcFile) throws IOException {
        BufferedImage srcImage = ImageIO.read(srcFile);
        BufferedImage destImage = this.deepCopy(srcImage);
        BoxBlurFilter boxBlurFilter = new BoxBlurFilter();
        boxBlurFilter.setRadius(((BlurLevel)((Object)this.blurLevel.get())).getRadius());
        boxBlurFilter.setIterations(3);
        destImage = boxBlurFilter.filter(srcImage, destImage);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)destImage, "png", outStream);
        return this.saveScreenshotData(outStream.toByteArray());
    }

    private BufferedImage deepCopy(BufferedImage srcImage) {
        ColorModel cm = srcImage.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = srcImage.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    private File saveScreenshotData(byte[] capturedScreenshot) throws IOException {
        Path temporaryScreenshotFile = Files.createTempFile("screenshot", "", new FileAttribute[0]);
        Files.write(temporaryScreenshotFile, capturedScreenshot, new OpenOption[0]);
        return temporaryScreenshotFile.toFile();
    }

    private boolean isAFile(Object screenshot) {
        return screenshot instanceof File;
    }

    private boolean isByteArray(Object screenshot) {
        return screenshot instanceof byte[];
    }

    private File targetScreenshot(String storedFilename) {
        this.targetDirectory.mkdirs();
        return new File(this.targetDirectory, storedFilename);
    }

    protected boolean driverCanTakeSnapshots() {
        if (this.driver == null) {
            return false;
        }
        if (this.driverIsProvided()) {
            ProvidedDriverConfiguration sourceConfig = new ProvidedDriverConfiguration(this.environmentVariables);
            return sourceConfig.getDriverSource().takesScreenshots();
        }
        if (this.driver instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.driver).canTakeScreenshots() && ((WebDriverFacade)this.driver).getProxiedDriver() != null;
        }
        return TakesScreenshot.class.isAssignableFrom(this.driver.getClass());
    }

    private boolean driverIsProvided() {
        return false;
    }

    public void setScreenshotProcessor(ScreenshotProcessor screenshotProcessor) {
        this.screenshotProcessor = screenshotProcessor;
    }

    protected ScreenshotProcessor getScreenshotProcessor() {
        return this.screenshotProcessor;
    }
}

