/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.maven.plugins;

import java.io.File;
import net.serenitybdd.maven.plugins.MavenProjectHelper;
import net.serenitybdd.maven.plugins.UpdatedClassLoader;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.reports.ResultChecker;
import net.thucydides.core.webdriver.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="check", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class SerenityCheckMojo
extends AbstractMojo {
    @Parameter(property="serenity.outputDirectory")
    public String outputDirectoryPath;
    @Parameter(property="tags", defaultValue="")
    public String tags;
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Parameter(defaultValue="${project}")
    public MavenProject project;

    protected ResultChecker getResultChecker() {
        MavenProjectHelper.propagateBuildDir(this.session);
        File outputDirectory = StringUtils.isNotEmpty((CharSequence)this.outputDirectoryPath) ? this.session.getCurrentProject().getBasedir().toPath().resolve(this.outputDirectoryPath).toFile() : this.session.getCurrentProject().getBasedir().toPath().resolve(this.getConfiguration().getOutputDirectory().toPath()).toFile();
        return new ResultChecker(outputDirectory, StringUtils.trimToEmpty((String)this.tags));
    }

    private Configuration getConfiguration() {
        return (Configuration)Injectors.getInjector().getProvider(Configuration.class).get();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Checking Serenity test results");
        UpdatedClassLoader.withProjectClassesFrom(this.project);
        TestResult testResult = this.getResultChecker().checkTestResults();
        switch (testResult) {
            case ERROR: {
                throw new MojoFailureException("An error occurred in the Serenity tests");
            }
            case FAILURE: {
                throw new MojoFailureException("A failure occurred in the Serenity tests");
            }
            case COMPROMISED: {
                throw new MojoFailureException("There were compromised tests in the Serenity test suite");
            }
        }
    }
}

