/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.webdrivermanager.WebDriverManagerSetup;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DownloadableDriverProvider
implements DriverProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DriverProvider.class);
    private static final ThreadLocal<Set<String>> DOWNLOADED_DRIVERS = ThreadLocal.withInitial(CopyOnWriteArraySet::new);

    protected List<String> argumentsIn(String options) {
        return Splitter.on((String)";").omitEmptyStrings().splitToList((CharSequence)options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadDriverIfRequired(String driver, EnvironmentVariables environmentVariables) {
        if (ThucydidesSystemProperty.WEBDRIVER_AUTODOWNLOAD.booleanFrom(environmentVariables, Boolean.valueOf(false)).booleanValue() && !DOWNLOADED_DRIVERS.get().contains(driver)) {
            ThreadLocal<Set<String>> threadLocal = DOWNLOADED_DRIVERS;
            synchronized (threadLocal) {
                DOWNLOADED_DRIVERS.get().add(driver);
                if (this.isDriverAutomaticallyDownloaded(environmentVariables)) {
                    LOGGER.info("Using WebDriverManager configuration for " + driver);
                    switch (driver) {
                        case "chrome": {
                            WebDriverManagerSetup.usingEnvironmentVariables(environmentVariables).forChrome();
                            break;
                        }
                        case "edge": {
                            WebDriverManagerSetup.usingEnvironmentVariables(environmentVariables).forEdge();
                            break;
                        }
                        case "firefox": {
                            WebDriverManagerSetup.usingEnvironmentVariables(environmentVariables).forFirefox();
                            break;
                        }
                        case "ie": 
                        case "iexplore": {
                            WebDriverManagerSetup.usingEnvironmentVariables(environmentVariables).forIE();
                            break;
                        }
                        case "safari": {
                            WebDriverManagerSetup.usingEnvironmentVariables(environmentVariables).forSafari();
                            break;
                        }
                        case "opera": {
                            WebDriverManagerSetup.usingEnvironmentVariables(environmentVariables).forOpera();
                        }
                    }
                } else {
                    LOGGER.info("Not using automatically driver download");
                }
            }
        }
    }
}

