/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders.cache;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.webdriver.driverproviders.WebDriverInitialisationException;
import net.serenitybdd.core.webdriver.enhancers.BeforeAWebdriverScenario;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.reflection.ClassFinder;
import net.thucydides.core.util.EnvironmentVariables;

public class PreScenarioFixtures {
    private static final List<BeforeAWebdriverScenario> CACHED_BEFORE_A_WEBDRIVER_SCENARIOS = Collections.synchronizedList(new ArrayList());
    private static AtomicBoolean beforeScenariosLoaded = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BeforeAWebdriverScenario> executeBeforeAWebdriverScenario() {
        if (!beforeScenariosLoaded.get()) {
            AtomicBoolean atomicBoolean = beforeScenariosLoaded;
            synchronized (atomicBoolean) {
                CACHED_BEFORE_A_WEBDRIVER_SCENARIOS.addAll(PreScenarioFixtures.loadBeforeScenarios());
                beforeScenariosLoaded.set(true);
            }
        }
        return CACHED_BEFORE_A_WEBDRIVER_SCENARIOS;
    }

    private static List<BeforeAWebdriverScenario> loadBeforeScenarios() {
        ArrayList<BeforeAWebdriverScenario> enhancers = new ArrayList<BeforeAWebdriverScenario>();
        List<Class> capabilityEnhancers = ClassFinder.loadClasses().thatImplement(BeforeAWebdriverScenario.class).fromPackage("net.serenitybdd.plugins").stream().map(extension -> extension).collect(Collectors.toList());
        EnvironmentVariables environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
        capabilityEnhancers.addAll(PreScenarioFixtures.customEnhancers(environmentVariables));
        capabilityEnhancers.forEach(enhancerType -> {
            try {
                enhancers.add((BeforeAWebdriverScenario)enhancerType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new WebDriverInitialisationException("Failed to instantiate custom capability enhancer " + enhancerType.getName(), e);
            }
        });
        return enhancers;
    }

    private static List<Class<BeforeAWebdriverScenario>> customEnhancers(EnvironmentVariables environmentVariables) {
        List extensionPackages = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getListOfValues(ThucydidesSystemProperty.SERENITY_EXTENSION_PACKAGES);
        return extensionPackages.stream().flatMap(extensionPackage -> ClassFinder.loadClasses().thatImplement(BeforeAWebdriverScenario.class).fromPackage(extensionPackage).stream().map(extension -> extension)).collect(Collectors.toList());
    }
}

