/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.servicepools;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.util.EnvironmentVariables;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.service.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DriverServicePool<T extends DriverService> {
    private static final ConcurrentMap<String, DriverService> DRIVER_SERVICES = new ConcurrentHashMap<String, DriverService>();
    protected final EnvironmentVariables environmentVariables;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    protected abstract T newDriverService();

    protected abstract String serviceName();

    protected abstract WebDriver newDriverInstance(Capabilities var1);

    public DriverServicePool() {
        this(ConfiguredEnvironment.getEnvironmentVariables());
    }

    public DriverServicePool(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    protected T getDriverService() {
        return this.driverServiceWithName(this.serviceName());
    }

    private T driverServiceWithName(String serviceName) {
        if (DRIVER_SERVICES.get(serviceName) != null) {
            return (T)((DriverService)DRIVER_SERVICES.get(serviceName));
        }
        DRIVER_SERVICES.putIfAbsent(serviceName, (DriverService)this.newDriverService());
        return (T)((DriverService)DRIVER_SERVICES.get(serviceName));
    }

    public synchronized void start() throws IOException {
        if (!this.getDriverService().isRunning()) {
            this.getDriverService().start();
        }
    }

    public synchronized void shutdown() {
        if (this.getDriverService().isRunning()) {
            this.getDriverService().stop();
        }
    }

    public WebDriver newDriver(Capabilities capabilities) {
        try {
            this.logger.debug("Creating new driver instance with capabilities: {}", (Object)capabilities);
            return new RemoteWebDriver(this.getDriverService().getUrl(), capabilities);
        }
        catch (WebDriverException couldNotReachDriverService) {
            this.logger.warn("Remote driver creation failed ({}), falling back on default driver creation", (Object)couldNotReachDriverService.getMessage().split("\n")[0]);
            return this.newDriverInstance(capabilities);
        }
    }

    public boolean isRunning() {
        return this.getDriverService().isRunning();
    }

    public void ensureServiceIsRunning() throws IOException {
        this.start();
    }
}

