/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import java.util.HashMap;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.DriverStrategySelector;
import net.thucydides.core.webdriver.WebdriverManager;
import org.openqa.selenium.WebDriver;

class RequestedDrivers {
    private final EnvironmentVariables environmentVariables;
    private WebdriverManager webdriverManager;
    private static final Map<String, String> BROWSERSTACK_BROWSER_NAMES = new HashMap<String, String>();
    private static final Map<String, String> SAUCELABS_BROWSER_NAMES = new HashMap<String, String>();

    private RequestedDrivers(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static RequestedDrivers withEnvironmentVariables(EnvironmentVariables environmentVariables) {
        return new RequestedDrivers(environmentVariables);
    }

    public WebDriver requestedDriverFor(String fieldName, String driverName, String driverOptions) {
        if (DriverStrategySelector.inEnvironment(this.environmentVariables).browserStackUrlIsDefined()) {
            return this.webdriverManager.withOptions(driverOptions).withProperty(ThucydidesSystemProperty.BROWSERSTACK_BROWSER.getPropertyName(), BROWSERSTACK_BROWSER_NAMES.getOrDefault(driverName, driverName)).getWebdriverByName(fieldName, "remote");
        }
        if (DriverStrategySelector.inEnvironment(this.environmentVariables).sauceLabsIsUsed()) {
            return this.webdriverManager.withOptions(driverOptions).withProperty(ThucydidesSystemProperty.SAUCELABS_BROWSERNAME.getPropertyName(), SAUCELABS_BROWSER_NAMES.getOrDefault(driverName, driverName)).getWebdriverByName(fieldName, "remote");
        }
        return this.webdriverManager.withOptions(driverOptions).getWebdriver(driverName);
    }

    public RequestedDrivers andWebDriverManager(WebdriverManager webdriverManager) {
        this.webdriverManager = webdriverManager;
        return this;
    }

    static {
        BROWSERSTACK_BROWSER_NAMES.put("iexplorer", "IE");
        BROWSERSTACK_BROWSER_NAMES.put("firefox", "Firefox");
        BROWSERSTACK_BROWSER_NAMES.put("safari", "Safari");
        BROWSERSTACK_BROWSER_NAMES.put("chrome", "Chrome");
        BROWSERSTACK_BROWSER_NAMES.put("opera", "Opera");
        BROWSERSTACK_BROWSER_NAMES.put("edge", "Edge");
        SAUCELABS_BROWSER_NAMES.put("iexplorer", "internet explorer");
        SAUCELABS_BROWSER_NAMES.put("edge", "MicrosoftEdge");
    }
}

